/**
 * Copyright ile ( http://wonderfl.net/user/ile )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/tj8b
 */

// forked from ile's WaterDropsSample
// forked from ile's WaterDropMaker
/* 
shape で WaterDrop を作ってみました。 
waterdrop.size=dropRadius
*/
package  {
    
import flash.display.MovieClip;
import flash.events.Event;

    public class Suiteki extends MovieClip {
        
        public function Suiteki() {
            var dropN:uint = 50;
            var waitN:uint = 300;
            var dropMax:uint = 30;
            var dropMin:uint = 5;
            var drops:Array=new Array();
            var drop:WaterDropMaker;
            
            dropDrop();
            addEventListener(Event.ENTER_FRAME, enterFrameHandler);
            
            function enterFrameHandler():void {
                
                if (!waitN--) {
                    waitN = 300;
                    for (var i:uint = 0; i < dropN; i++) {
                        removeChild(drops[i]);
                    }
                    graphics.clear();
                    dropDrop();
                }
            }
            
            function dropDrop():void {
                //backgroundColor
                var bgColor:uint = 0x345678;
                
                graphics.beginFill(bgColor);
                graphics.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
                graphics.endFill();
                graphics.beginFill (Math.random() * 0x1000000, 1.0);
                graphics.drawCircle  ( 270, 100 , 150);
                graphics.endFill();
                
                //WaterDropsMake 
                for(var i:uint=0;i<dropN;i++){
                    do{
                        drop = new WaterDropMaker(sq(Math.random())*dropMax + dropMin);
                        addChild(drop);
                        drops[i] = drop;
                        var reFlg:Boolean=false;
                        drops[i].x = Math.random() * stage.stageWidth;
                        
                        //Vanishing by Height
                        drops[i].y = Math.random() * stage.stageHeight * (int(i*8/dropN)+2)/10;
                        
                        if(i){
                            for(var j:uint=0;j<i;j++) {
                                if (dropHitTest(drops[i], drops[j])) {
                                    removeChild(drops[i]);
                                    reFlg = true;
                                    break;
                                }
                            }
                        }
                    }while (reFlg);
                    drops[i].rotation = -45;
                }
            }
            //Overlap?true:false
            function dropHitTest(d1:WaterDropMaker, d2:WaterDropMaker):Boolean {
                if (d1.size + d2.size > pythagora(d1.x - d2.x,d1.y - d2.y)) {
                    return true;
                }else {
                    return false;
                }
            }
            //r^2=n^2+m^2
            function pythagora(n:int,m:int):uint{
                return Math.sqrt(m*m+n*n);
            }
            function sq(n:Number):Number{
                return n*n;
            }

            
        }
    }
}

import flash.display.Sprite;
import flash.display.MovieClip;
import flash.events.Event;
import flash.display.Shape;
import flash.display.GradientType;
import flash.display.SpreadMethod;
import flash.display.Graphics;
import flash.events.NetStatusEvent;
import flash.geom.Matrix;
import flash.display.BlendMode;

class WaterDropMaker extends MovieClip {
    private var dropSize:uint;

    public function WaterDropMaker(n:uint):void {
        dropSize = n;
        var shadowColor:uint = 0x000000;
        var lightColor:uint = 0xFFFFFF;
        var initialSize:uint = 1;
        var maxWidth:Number;
        var heightRatio:Number;
        var endFrameile:uint = Math.random() * 300+50;
        var nowFrameile:uint=1;
        
        var container:Sprite = addChild(new Sprite) as Sprite;
        //container.x = container.y = dropSize;
     
        var shape:Shape = container.addChild(new Shape) as Shape;
        var g:Graphics = shape.graphics;
        var matrix:Matrix = new Matrix;
        
        dropDraw();
        
        //minimize
        maxWidth = container.width;
        container.width = initialSize;
        heightRatio = container.width * container.height / maxWidth;
        container.height = heightRatio;
        
        //animation
        addEventListener(Event.ENTER_FRAME, expandle);
        function expandle():void {
            if (nowFrameile <= endFrameile) {
                nowFrameile++;
                //smooth quadric (-(((x-F)^2)*M)/(F^2))+M;
                container.width = ((-(((nowFrameile-endFrameile)*(nowFrameile-endFrameile))*maxWidth))/(endFrameile*endFrameile))+maxWidth+initialSize;
                container.height = container.width * heightRatio / initialSize;
            }else{
                removeEventListener(Event.ENTER_FRAME, expandle);
            }
        }
        
        function dropDraw():void {
            //long shadow
            shape =  container.addChild(new Shape) as Shape;
            g = shape.graphics;
            //createGradientBox(w,h,r,X,Y)
            matrix.createGradientBox(dropSize * 2, dropSize * 4, 0, -dropSize, -dropSize*2);
            g.beginGradientFill(GradientType.RADIAL, [shadowColor, shadowColor, shadowColor], [0.0,0.03,0], [0,200,255], matrix, SpreadMethod.PAD);
            g.moveTo(-dropSize, 0);
            g.curveTo ( -dropSize , dropSize * 2, 0 , dropSize * 2 );
            g.curveTo ( dropSize , dropSize*2, dropSize , 0 );
            g.curveTo ( dropSize*0.88 , dropSize*0.88, 0 , dropSize );
            g.curveTo ( -dropSize*0.88 , dropSize*0.88, -dropSize , 0 );
            g.endFill();
            
            //around OUTSIDE shadow
            shape =  container.addChild(new Shape) as Shape;
            g = shape.graphics;
            matrix.createGradientBox(dropSize * 2.6, dropSize * 2.6+dropSize/5, 0, -dropSize*1.3, -dropSize*1.3);
            g.beginGradientFill(GradientType.RADIAL, [shadowColor,shadowColor, shadowColor], [0.01,0.02,0], [0,200,255], matrix, SpreadMethod.PAD);
            g.drawCircle(0, dropSize/5, dropSize*1.5);
            g.endFill();
            
            //base color
            shape =  container.addChild(new Shape) as Shape;
            g = shape.graphics;
            g.beginFill (0x888888, 0.12);
            g.drawCircle  ( 0, 0 , dropSize);
            g.endFill();
            shape.blendMode = BlendMode.LIGHTEN;

            //around INSIDE shadow
            shape =  container.addChild(new Shape) as Shape;
            g = shape.graphics;
            matrix.createGradientBox(dropSize * 3.5, dropSize * 3.7, 0, -dropSize * 1.8, -dropSize * 1.0);
            g.beginGradientFill(GradientType.RADIAL, [shadowColor,shadowColor, shadowColor], [0,0.01,0.02], [0,200,255], matrix, SpreadMethod.PAD);
            g.drawCircle  ( 0, 0 , dropSize);
            g.endFill();
            
            //under　shadow
            shape =  container.addChild(new Shape) as Shape;
            g = shape.graphics;
            matrix.createGradientBox(dropSize * 5, dropSize * 5, 0, -dropSize*2.5, -dropSize*3);
            g.beginGradientFill(GradientType.RADIAL, [shadowColor,shadowColor,shadowColor,shadowColor], [0,0, 0.1,0.4], [0,95,222,255], matrix, SpreadMethod.PAD);
            g.drawCircle(0, 0, dropSize);
            g.endFill();
            
            //base gradation
            shape =  container.addChild(new Shape) as Shape;
            g = shape.graphics;
            matrix.createGradientBox(dropSize * 3.5, dropSize * 3.7, 0, -dropSize*1.8, -dropSize*1.0);
            g.beginGradientFill(GradientType.RADIAL, [lightColor,lightColor, lightColor,lightColor,lightColor,lightColor], [0.25,0.12, 0.03,0,0,0.12], [0,70, 181,216,245,255], matrix, SpreadMethod.PAD);
            g.drawCircle(0, 0, dropSize);
            g.endFill();
            shape.blendMode = BlendMode.OVERLAY;
            
            //highlight
            shape =  container.addChild(new Shape) as Shape;
            g = shape.graphics;
            matrix.createGradientBox(dropSize/2, dropSize/2, 0, -dropSize/4, -dropSize*0.9);
            g.beginGradientFill(GradientType.RADIAL, [lightColor,lightColor,lightColor], [0.6,0.08 ,0], [0,85,255], matrix, SpreadMethod.PAD);
            g.drawCircle(0, 0, dropSize);
            g.endFill();
        }
    }
    
    public function get size():int {
    return dropSize;
    }
}