/**
 * Copyright okoi ( http://wonderfl.net/user/okoi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/tiaA
 */

//
//	塗りつぶし円弧を描画する処理
//
package 
{
	import flash.display.Graphics;
	import flash.display.Sprite;
	import flash.events.Event;
	
	/**
	 * @author okoi
	 */
	public class Main extends Sprite 
	{
		
		public function Main():void 
		{
			if (stage) init();
			else addEventListener(Event.ADDED_TO_STAGE, init);
		}
		
		private function init(e:Event = null):void 
		{
			removeEventListener(Event.ADDED_TO_STAGE, init);
			// 適当に何個か出します。
			for ( var i:int = 0; i < 50; i++ )
			{
				var posX:int = int(Math.random() * stage.stageWidth);
				var posY:int = int(Math.random() * stage.stageHeight);
				var w:Number = Math.random() * 200;
				var h:Number = Math.random() * 200;
				var sA:Number = Math.random() * 360;
				var aA:Number = Math.random() * 360;
				var color:uint = uint(Math.random() * 0xFFFFFF);
				FillArc( this.graphics, posX, posY, w, h, sA, aA, color );
			}
		}
		
		/**
		 * 円弧を描画する(width,height指定バージョン。楕円もいける)
		 * 指定する座標は円の左上の位置になるので中心を指定したい場合はまた別の関数を作ればおｋ
		 * @param	g			描画対象オブジェクトのGraphics
		 * @param	_x			描画座標(左上位置
		 * @param	_y			描画座標(左上位置
		 * @param	_w			円を描いた場合の円の幅
		 * @param	_h			円を描いた場合の円の高さ
		 * @param	startAngle
		 * @param	arcAngle
		 */
		private function FillArc( g:Graphics, _x:Number, _y:Number, _w:Number, _h:Number, startAngle:Number, arcAngle:Number, color:uint = 0x00000000 ) : void {
			
			var	startRadian:Number = startAngle * Math.PI / 180;
			var	rX:Number = _w/2;
			var rY:Number = _h/2;
			
			//	中心点を求める
			var	centerX:Number = _x + _w/2;
			var centerY:Number = _y + _h/2;
			
			//	始点位置を求める
			var	x:Number = Math.cos( startRadian )*rX + centerX;
			var y:Number = Math.sin( startRadian )*rY*-1 + centerY;
			
			
			
			//	１周以上しても意味がないので
			if( Math.abs( arcAngle ) > 360 )	arcAngle = 360;
			
			var	segs:Number 	= Math.ceil( Math.abs(arcAngle)/45);
			var	segAngle:Number = arcAngle/segs;
			var	theta:Number = -(segAngle/180)*Math.PI;
			var	angle:Number = -(startAngle/180)*Math.PI;
			var	ax:Number = x-Math.cos(angle)*rX;
			var ay:Number = y-Math.sin(angle)*rY;
			
			g.beginFill( color );
			g.moveTo( x, y );
						
			if( segs > 0 )
			{
				for( var i:uint = 0; i < segs; i++ )
				{
					angle += theta;	
					var	angleMid:Number = angle - (theta/2);
					var bx:Number = ax+Math.cos(angle)*rX;
					var by:Number = ay+Math.sin(angle)*rY;
					var cx:Number = ax+Math.cos(angleMid)*(rX/Math.cos(theta/2));
					var cy:Number = ay+Math.sin(angleMid)*(rY/Math.cos(theta/2));
					g.curveTo(cx,cy,bx,by);
				}		
			}
			
			//	円じゃない場合、中心とかにもパスを通す
			if( arcAngle < 360 )
			{
				g.lineTo( centerX, centerY );	
				g.lineTo( x, y );
			}
			
			g.endFill();
		}
		
		
	}
	
	
}