/**
 * Copyright aruerula ( http://wonderfl.net/user/aruerula )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/tiUG
 */

package  
{
    //http://d.hatena.ne.jp/ActionScript/20090414/as3_line_circle
    
    import caurina.transitions.Tweener;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    import flash.text.TextFormat;
    
    [SWF(width = 465, height = 465, backgroundColor = 0x000000, frameRate = 30)]
    
    public class Circle extends Sprite 
    {
        private var _scx:Number = stage.stageWidth  * 0.5; // ステージ中央のX座標
        private var _scy:Number = stage.stageHeight * 0.5; // ステージ中央のY座標
        private var _txtfld:TextField;
        
        public function Circle():void 
        {
            setup();
        }
        
        private function setup():void
        {
            var txtfmt:TextFormat = new TextFormat("_ゴシック", 9, 0xFFFFFF);
            _txtfld = new TextField();
            _txtfld.defaultTextFormat = txtfmt;
            _txtfld.autoSize = TextFieldAutoSize.LEFT;
            _txtfld.text = "画面をクリックすると、クリックした座標を中心にした円が線で描かれます。";
            _txtfld.x = _scx - _txtfld.width  * 0.5;
            _txtfld.y = _scy - _txtfld.height * 0.5;
            _txtfld.selectable = false;
            _txtfld.name = "text";
            this.stage.addChildAt(_txtfld, 0);
            
            this.stage.addEventListener(MouseEvent.CLICK, function(event:MouseEvent):void
            {
                stage.removeEventListener(MouseEvent.CLICK, arguments.callee);
                Tweener.addTween(_txtfld, { alpha:0, time:3, delay:0, transition:"easeOutExpo", onComplete:function():void
                {
                    stage.removeChild(_txtfld);
                }});
            });
            
            this.stage.addEventListener(MouseEvent.CLICK, mouseClickHandler);
        }
        
        private function mouseClickHandler(event:MouseEvent):void 
        {
            // 円のスプライト作成
            var sp:Sprite = new Sprite();
            this.stage.addChild(sp);
            draw(sp, mouseX, mouseY);
        }
        
        private function draw(sp:Sprite, cx:Number, cy:Number):void 
        {
            var radius:Number = 200 * Math.random() + 10; // 半径をランダム
            var angle:Number = -90 * Math.PI / 180; // 開始角度(をラジアンで)
            var max:Number = 2 * Math.PI + angle; // 終了角度(をラジアンで)
            var fx:Function = function(r:Number, t:Number, x:Number):Number { return r * Math.cos(t) + x };
            var fy:Function = function(r:Number, t:Number, y:Number):Number { return r * Math.sin(t) + y };
            
            sp.graphics.lineStyle(radius * 0.1, 0xFFFFFF * Math.random()); // 線の太さは半径に比例、色はランダム
            sp.graphics.moveTo(fx(radius, angle, cx), fy(radius, angle, cy)); // 線描画の開始点
            
            // 線を描画する無名関数
            sp.addEventListener(Event.ENTER_FRAME, function(event:Event):void
            {
                angle += 0.05; // 約2.9度ずつ回転 ＝ 線を描画
                sp.graphics.lineTo(fx(radius, angle, cx), fy(radius, angle, cy));
                
                if (angle >= max)
                {
                    sp.removeEventListener(Event.ENTER_FRAME, arguments.callee);
                    Tweener.addTween(sp, { alpha:0, time:2, transition:"easeInExpo", onComplete:function():void
                    {
                        stage.removeChild(sp);
                    }});
                }
            });
        }
        
    }
    
}