/**
 * Copyright keegs ( http://wonderfl.net/user/keegs )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/thdn
 */

// forked from kawakita's Line Works vol.01 : Draw Line.
package {
    // 初 wonderfl ＞＜
    // USBメモリ内に昔作った小さいのがあったので晒してみる．
    // 正直コードは綺麗じゃないのではずかぴー
    
    // @author flair4jp.
    // @title  Line Works vol.01
    
    import flash.display.Sprite;
    import flash.events.Event;
    
    public class FlashTest extends Sprite {
        
        //------- CONST --------------------------
        private static const _NUM_LINES:uint = 5;
        
        //------- MEMBER -------------------------
        
        //------- PUBLIC -------------------------
        public function FlashTest() {
            stage.frameRate = 60;
            // 線を生成.
            for( var i:uint = 0; i < _NUM_LINES; i++ ){
                addChild( new Line() );
            }
            addEventListener(Event.ENTER_FRAME, _onEnterFrame );
        }
        
        //------- PRIVATE -------------------------
        private function _onEnterFrame(e:Event):void{
            var line:Line;
            var len:uint = numChildren;
            for( var i:uint = 0; i < len; i++ ){
                line = getChildAt(i) as Line;
                line.drawTo( stage.mouseX, stage.mouseY );
            }
        }
        
    }
}

import flash.display.Graphics;
import flash.display.MovieClip;
import flash.geom.Point;
    
class Line extends MovieClip{
    
    //------- CONST -------------------------------
    private static const _NUM_POINTS:uint = 500;
    
    //------- MEMBER ------------------------------
    private var _graphics:Graphics;
    private var _pArr:Array;
    private var _xSpring:Spring;
    private var _ySpring:Spring;
    
    //------- PUBLIC ------------------------------
    public function Line():void {
        // Graphics の設定.
        _graphics = this.graphics;
        // ポイントの生成.
        _pArr = new Array();
        for ( var i:uint = 0; i < _NUM_POINTS; i++ ) {
            _pArr.push( new Point() );
        }
        // ばねの設定.
        var rand:Number = Math.random() * 0.6;
        _xSpring = new Spring( 0, 0, 0.3, rand, 0.001 );
        _ySpring = new Spring( 0, 0, 0.3, rand, 0.001 );
    }
    
    //------- INTERNAL ----------------------------
    internal function drawTo( x_:Number, y_:Number ):void {
        var i:uint;
        // 描画処理.
        _graphics.clear();
        _graphics.lineStyle( 0, 0x000000 );
        _graphics.moveTo( _pArr[0].x, _pArr[0].y );
        var len:uint = _pArr.length;
        for ( i = 1; i < len; i++ ) {
            _graphics.lineTo( _pArr[i].x, _pArr[i].y );
        }
        // 計算処理.
        _xSpring.targetValue = x_;
        _ySpring.targetValue = y_;
        _pArr[0].x = _xSpring.getNext();
        _pArr[0].y = _ySpring.getNext();
        for ( i = 1; i < _pArr.length; i++ ) {
            _pArr[i].x += (_pArr[i-1].x - _pArr[i].x) * 0.7;
            _pArr[i].y += (_pArr[i-1].y - _pArr[i].y) * 0.7;
        }
    }
}

/** ばね計算. */
class Spring {

    //------- MEMBER -----------------------------------------------------------------------
    /** ばねの力 */
    private var _power:Number;
    /** 慣性（０～１）大きいほど動き続ける. */
    private var _inertia:Number;
    /** ばね係数、大きいほど強いばね. */
    private var _coefficient:Number;
    /** 収束すべき値. */
    private var _target:Number;
    /** 開始の値. */
    private var _current:Number;
    private var _accuracy:Number;
    
    //------- PUBLIC -----------------------------------------------------------------------
    public function Spring( target:Number , current:Number , coefficient:Number,
                            inertia:Number, accuracy:Number ):void{
        if ( accuracy <= 0 ) throw new Error("accuracyは0より大きい必要があります.");
        _power       = 0;
        _target      = target;
        _current     = current;
        _coefficient = coefficient;
        _inertia     = inertia;
        _accuracy    = accuracy;
    }
    
    // 各種setter.
    public function set targetValue( value:Number ):void{ _target = value; }
    public function set currentValue( value:Number ):void{ _current = value; }
    public function set coefficient( value:Number ):void{ _coefficient  = value; }
    public function set accuracy( value:Number ):void{ _accuracy  = value; }
    public function set inertia( value:Number ):void{ _inertia = value; }
    
    /**
    * 次の値を取得する.
    * @return
    */
    public function getNext():Number {
        _power = _power * _inertia + ( _target - _current ) * _coefficient;
        _current += _power;
        return (isEnd()) ? _target : _current;
    }
    
    /**
    * 目標地点に到達しているか.
    * @return
    */
    public function isEnd():Boolean{
        return ( Math.abs( _target - _current ) < _accuracy );
    }
    
}

