/**
 * Copyright yuuganisakase ( http://wonderfl.net/user/yuuganisakase )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/tgI5
 */

package 
{
	import flash.display.*;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.filters.BlurFilter;
	import flash.geom.Rectangle;
	import flash.net.URLRequest;
	import flash.system.Security;
	import flash.utils.Timer;
	import org.libspark.betweenas3.BetweenAS3;
	import org.libspark.betweenas3.easing.Sine;
	import org.libspark.betweenas3.tweens.ITween;
	import org.libspark.betweenas3.tweens.ITweenGroup;
	import org.papervision3d.lights.PointLight3D;
	import org.papervision3d.materials.ColorMaterial;
	import org.papervision3d.materials.MovieMaterial;
	import org.papervision3d.materials.shadematerials.FlatShadeMaterial;
	import org.papervision3d.materials.utils.MaterialsList;
	import org.papervision3d.objects.DisplayObject3D;
	import org.papervision3d.objects.primitives.Cube;
	import org.papervision3d.objects.primitives.Plane;
	import org.papervision3d.view.BasicView;
	import org.papervision3d.view.layer.util.ViewportLayerSortMode;


	[SWF(width=465, height=465, frameRate=30, backgroundColor=0x333333)]
	public class Alice extends BasicView
	{
		private var display:MovieMaterial;
		private var loader:Loader;
		private var loader2:Loader;
		private var movie:MovieClip;
		
		private var stateNumber:int = 1;
		private var ipad:DisplayObject3D;
		private var proMovie:MovieClip;
		private var m:MovieClip = new MovieClip();
		
		public function Alice():void 
		{
			super(465, 465);
			
			loader = new Loader();
			Security.loadPolicyFile("http://lucasclaus.sakura.ne.jp/crossdomain.xml");
			
			loader.load(new URLRequest("http://lucasclaus.sakura.ne.jp/swf/Clock.swf"));
			
			loader.contentLoaderInfo.addEventListener(Event.COMPLETE, onLoad);
		}
		
		private function onLoad(e:Event):void 
		{
			stage.quality = StageQuality.MEDIUM;
			
			movie = loader.content as MovieClip;
			movie.scaleX = 1;
			m.addChild(movie);
			movie.x = -900;
			loader2 = new Loader();
			loader2.load(new URLRequest("http://lucasclaus.sakura.ne.jp/swf/Opening.swf"));
			loader2.contentLoaderInfo.addEventListener(Event.COMPLETE, onLoad2);
			
		}
		
		private function onLoad2(e:Event):void 
		{
			proMovie = loader2.content as MovieClip;
			m.addChildAt(proMovie,0);
			init();
		}
		
		
		private function init(e:Event = null):void 
		{	
			const wid:int = 384;
			const hei:int = 512;
			viewport.containerSprite.sortMode = ViewportLayerSortMode.INDEX_SORT;
			var light:PointLight3D = new PointLight3D();
			light.z = -300;
			scene.addChild(light);
			var fm:FlatShadeMaterial = new FlatShadeMaterial(light, 0x222222, 0x000000, 1);
			var cm:ColorMaterial = new ColorMaterial(0xaaaaaa);
			var ml:MaterialsList = new MaterialsList();
			var mc:MovieClip = new MovieClip();
			mc.graphics.beginFill(0xff0000);
			mc.graphics.drawCircle(200, 200, 200);
			
			addChild(m);
			m.y = -900;
			display = new MovieMaterial(m, true, true, true, new Rectangle(0, 0, wid, hei));
			
			ml.addMaterial(fm, "all");
			ml.addMaterial(cm, "back");
			var plane:Plane = new Plane(display, wid, hei);
			ipad = new DisplayObject3D();
			var cube:Cube = new Cube(ml, wid + 5, 30, hei + 5);
			viewport.getChildLayer(plane).layerIndex = 2;
			viewport.getChildLayer(cube).layerIndex = 1;
			viewport.getChildLayer(cube).filters = [new BlurFilter(2,2,1)];
			plane.z = -15;
			ipad.addChild(cube);
			ipad.addChild(plane);
			scene.addChild(ipad);
			camera.z = -400;
			
			addEventListener(Event.ENTER_FRAME, onEnter);
			stage.addEventListener(MouseEvent.CLICK, onClick);
		}
		private function changeState():void
		{
			const time:Number = 1.0;
			var t1:ITween; var t2:ITween;
			if (stateNumber == 1) {
				stateNumber = 2;
				t1 = BetweenAS3.tween(movie, { x:0 }, { x:400 }, time, Sine.easeOut);
				t2 = BetweenAS3.tween(proMovie, { x: -400 }, { x:0 }, time, Sine.easeOut);
			}else if (stateNumber == 2) {
				stateNumber = 1;
				t1 = BetweenAS3.tween(proMovie, { x:0 }, { x:380 }, time, Sine.easeOut);
				t2 = BetweenAS3.tween(movie, { x: -380 }, { x:0 }, time, Sine.easeOut);
			}
			var tween:ITweenGroup= BetweenAS3.parallel(t1,t2);
			tween.play();
			
		}
		
		private function onClick(e:MouseEvent):void 
		{
			changeState();
		}
		
		private function onEnter(e:Event):void 
		{
			singleRender();
			changeAngle();
			if (stateNumber == 2) movie.input(-ipad.rotationY/2, -ipad.rotationX/2);
			
		}
		private function changeAngle():void
		{
			const Div:Number = 5;
			if(ipad != null){
				ipad.rotationX = (mouseY - WW / 2) / Div;
				ipad.rotationY = (mouseX - HH / 2) / Div;
			}
		}
	}
	
}

const WW:int = 465;
const HH:int = 465;




/*
 * 
 * source of Clock.swf
 * 
 * 
 * 
package Movie
{
	import com.actionsnippet.qbox.QuickBox2D;
	import com.actionsnippet.qbox.QuickObject;
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.MovieClip;
	import flash.display.Shape;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.system.Security;

	[SWF(width=384, height=512, frameRate=30, backgroundColor=0x333333)]
	public class Clock extends MovieClip
	{
		[Embed(source = '../Assets/Alice_Comp1.jpg')] private var Image3:Class;
		

		private var cc:Shape;
		private var box:QuickBox2D;
		
		public function Clock():void 
		{
			Security.allowDomain("http://swf.wonderfl.net/");
			var bm:Bitmap = new Image3() as Bitmap
			addChild(bm);
			createBoxWorld();
			addEventListener(Event.ENTER_FRAME, onEnter);
		}
		
		private function createBoxWorld():void
		{
			box = new QuickBox2D(this,{gravityX:0.0, gravityY:8, 
										iterations: 4, timeStep: 1 / 30, 
										bounds: [ -100, -100, 100, 100], debug:false, 
										simpleRender:true, renderJoints:true } );
			box.setDefault( { frequencyHz:0, dampingRatio:0 ,collideConnected:false,density:1,restitution:0.1} );
			var clock:QuickObject = box.addCircle( { skin:ClockImage,scaleSkin:false, x:3, y:10, radius:1.3 , density:0.1} );
			const StringWid:Number = 0.22;
			const StringLength:Number = 0.1;
			var a:QuickObject = box.addBox( {skin:ClockChain, x:2, y:10, width:StringWid,height:StringWid*1.5} );
			box.addJoint( { type:"distance", a:box.w.GetGroundBody(), x1:4,y1:9.8, b:a.body, length:StringLength } );
			var b:QuickObject;
			for (var i:int = 1; i < 6; i++) 
			{
				b  = box.addBox( { skin:ClockChain, scaleSkin:false, x:2, y:10 + i * 0.5,width:StringWid,height:StringWid*1.5} );
				box.addJoint( { type:"distance", a:a.body, b:b.body,x1:a.body.GetPosition().x ,y1:a.body.GetPosition().y-StringWid/2, x2:b.body.GetPosition().x,y2:b.body.GetPosition().y+StringWid/2 ,length:StringLength ,collideConnected:false} );
				a = b;
			}
			box.addJoint( { type:"distance", a:b.body, b:clock.body, length:StringLength,x1:b.body.GetPosition().x,y1:b.body.GetPosition().y,x2:3,y2:7 } );
			box.start();
		}
		
		public function input(xx:int, yy:int):void
		{
			box.w.m_gravity.x = xx;
			box.w.m_gravity.y = yy;
		}
		private function onEnter(e:Event):void 
		{
		}	

	}
	
}
import flash.display.Bitmap;
import flash.display.DisplayObject;
import flash.display.MovieClip;
import flash.display.Shape;
import flash.filters.BevelFilter;
import flash.filters.BlurFilter;
import flash.filters.ColorMatrixFilter;
import flash.filters.GlowFilter;
import flash.geom.ColorTransform;
import flash.geom.Point;
class ClockChain extends MovieClip
{
	[Embed(source = '../Assets/alice2_chain.png')] private var Image5:Class;

	public function ClockChain()
	{
		super();
		var im:Bitmap = (new Image5()) as Bitmap;
		im.transform.colorTransform = new ColorTransform(0.2, 0.2, 0.1);
		
		this.alpha = 0.8;
		im.scaleX = 0.8;
		im.scaleY = 1.2;
		addChild(im);
		im.x = -im.width / 2;
		im.y =  -im.height / 2;
	}
}
class ClockImage extends MovieClip
{
	[Embed(source = '../Assets/Alice_watch.png')] private var Image4:Class;

	public function ClockImage()
	{
		super();
		var im:Bitmap = (new Image4()) as Bitmap;
		addChild(im);
		im.x = -im.width / 2;
		im.y =  -im.height / 2;
	}
}
 * */
	