/**
 * Copyright kske ( http://wonderfl.net/user/kske )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/tfzY
 */

package {
    import flash.display.*;
    import flash.geom.*;
    import flash.events.*;
    import flash.utils.Timer;

    [SWF(width=512, height=512, backgroundColor=0xffffff, frameRate=30)]
    public class Blower extends Sprite{
        private var frq:Number;

        public function Blower(){
            frq = 0.7;
            initRiseTimer(0, 0, onRiseBlower);
        }

        private function onRiseBlower(e:TimerEvent):void{
            addEventListener(Event.ENTER_FRAME, onBlowing);
            var dropTimer:Timer = new Timer(2000);
            dropTimer.repeatCount = 1;
            dropTimer.addEventListener(TimerEvent.TIMER, function():void{
                initRiseTimer(1500, 1000, onRiseBlower);
                removeEventListener(Event.ENTER_FRAME, onBlowing);
                dropTimer.removeEventListener(TimerEvent.TIMER, arguments.callee);
                dropTimer = null;
            });
            dropTimer.start();
        }

        private function onBlowing(e:Event):void{
            var f:Number;
            var p:Particle;

            for( f = frq; f > 0; f -= Math.random() ){
                p = new Particle( Math.random() * 40 - 20, Math.random() * 40 -20, 10, 10);
                stage.addChild(p);
                p.startAnimate();
            }
        }

        private function initRiseTimer(minInterval:int, amp:int, listener:Function):void{
            var riseTimer:Timer = new Timer(minInterval + amp * Math.random());
            riseTimer.repeatCount = 1;
            riseTimer.addEventListener(TimerEvent.TIMER, listener);
            riseTimer.addEventListener(TimerEvent.TIMER_COMPLETE, function():void{
                riseTimer.removeEventListener(TimerEvent.TIMER, listener);
                riseTimer.removeEventListener(TimerEvent.TIMER_COMPLETE, arguments.callee);
                riseTimer = null;
            });

            riseTimer.start();
        }

    }
}

import flash.display.Sprite;
import flash.geom.*;
import flash.events.Event;
class Particle extends Sprite
{
    // emitterは外に持ちたいけどEnterFrameはまとめたいんだよなぁ
    private var emitterX:Number;
    private var emitterY:Number;
    private var power:Number;
    private var rad:Number;
    private var G:Number;
    private var frict:Number;
    public function Particle(posX:Number, posY:Number, minSize:Number, amp:int)
    {
        emitterX = 600;
        emitterY = 512;
        x = emitterX + posX;
        y = emitterY + posY;
        var difRad:Number = Math.atan2(emitterY - y, emitterX - x) / 28;
        var difPow:Number = Math.sqrt( (emitterY - y) * (emitterY - y) + (emitterX - x) * (emitterX - x));
        power = 35 + difPow / 2;
        rad = 1.35 * Math.PI + difRad;
        G = -25;
        frict = 0.2;

        graphics.beginFill(0xffffff * Math.random(), 0.7);
        graphics.drawCircle(0, 0, minSize + Math.random() *amp);
    }

    public function startAnimate():void
    {
        stage.addEventListener(Event.ENTER_FRAME, onLiving);
    }

    private function onLiving(e:Event):void
    {
        y += Math.sin(rad) * power - G;
        x += Math.cos(rad) * power;
        G += G * 0.0055;

        power -= frict;
        power = power < 0 ? 0 : power;

        if( y < -100 || x < -100){
            stage.removeEventListener(Event.ENTER_FRAME, onLiving);
            stage.removeChild(this);
        }
    }
}
