/**
 * Copyright yashikei ( http://wonderfl.net/user/yashikei )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/tftS
 */

//PaperVision3D
//Planeの端っこを軸とした回転モーション

package{
    import flash.display.*;
    import flash.events.*;
    import flash.utils.Timer;
    
    import org.papervision3d.materials.*;
    import org.papervision3d.objects.*;
    import org.papervision3d.objects.primitives.*;
    import org.papervision3d.view.*;
    
    import caurina.transitions.Tweener;
    
    public class box3D extends BasicView{
        public function box3D(){
            camera.y = 800;
            camera.x = 500;
            
            var material:ColorMaterial = new ColorMaterial(0x00f000);
            material.doubleSided = true;
            
            //回転させるオブジェクト
            var r:Number = 100;            
            var obj:Plane = new Plane(material, r*2, r*2, 1, 1);
            obj.rotationY = 0;
            
            //回転角度に応じて、onjの（中心）座標を移動
            var rotateY:Number = 70;
            var newX:Number = - ( r - r * Math.cos( rotateY * Math.PI/180));
            var newZ:Number = - r * Math.sin( rotateY * Math.PI / 180 );;
            
            scene.addChild(obj);

            Tweener.addTween(obj, {time:10, x:newX, z:newZ, rotationY:rotateY, transition:'easeOutCirc'});            

            //軸
            var cylinder:Cylinder = new Cylinder(null, 5, 400);
            cylinder.x = -100;
            scene.addChild(cylinder);
            
            startRendering();
        }
        
    }
}