/**
 * Copyright nulldesign ( http://wonderfl.net/user/nulldesign )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/tfsU
 */

/**
	城戸さんにキュンときて・・・
	
	３Dの基本をざっくり
	これから軽量自作3Dエンジンにしていく予定。
	http://nulldesign.jp/
*/

package 
{

	import flash.display.Stage;
	import flash.display.StageAlign;
	import flash.display.StageScaleMode;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.TimerEvent;
	import flash.events.MouseEvent;
	import caurina.transitions.*;
	import flash.utils.Timer;

	public class Main extends Sprite
	{

		public var R:Number = 64;
		private var _num:int = 1024;
		private var _list:Vector.<GlassBall > ;
		private var _last:GlassBall;
		private var _world:Sprite;

		public function Main()
		{
			// constructor code
			//trace("hello CS5");

			stage.align = StageAlign.TOP_LEFT;
			stage.scaleMode = StageScaleMode.NO_SCALE;
			_list= new Vector.<GlassBall>();

			_world = new Sprite();
			addChild( _world );
			_world.x = stage.stageWidth * .5;
			_world.y = stage.stageHeight * .5;

			var past:GlassBall = null;
			var R:int = 128;
			for (var i:int = 0; i < _num; i++)
			{
				var _g:GlassBall = new GlassBall();
				_world.addChild( _g );
				_list.push( _g );
				_g._x = i % 32 * R - ( 16 * R);
				_g._y = Math.random() * 512 - 256;
				_g._z = Math.floor( i / 32 ) * R- ( 16 * R);
				_g.next = past;
				past = _g;
			}
			_last = _g;

			addEventListener( Event.ENTER_FRAME, _loop );

			stage.addEventListener( Event.RESIZE, _onResize );

			var tim:Timer = new Timer(1000 / 30);
			tim.addEventListener( TimerEvent.TIMER, _loop2 );
			tim.start();

		}

		public var __c:int = 0;
		private function _loop2( e:Event = null ):void
		{
			__c +=  10;
			var _count:int = __c;
			var _g:GlassBall = _last;
			var _h:Number = _h = 200;
			//var R:Number = Math.random() * 160;
			while ( _g != null )
			{
				//Tweener.addTween( _g, { delay: _count / _num, _y: _h + Math.sin( _count / 180 * Math.PI ) * R, time: 3, transition: "easeOutElastic" });
				_g._y = Math.sin(_count / 180 * Math.PI) * R + _h;
				_g = _g.next;
				_count++;
			}
		}

		private function _loop( e:Event ):void
		{
			var len:int = _list.length;
			var _g:GlassBall = _last;
			while ( _g != null )
			{
				_g.update();
				_g = _g.next;
			}
			
			_list.sort( _compare );
			
			len = _list.length;
			while( len-- )
			{
				_world.addChild( _list[len] );
			}
			
		}

		private function _compare( a, b ):Number
		{
			var _g1:Number = a._z;
			var _g2:Number = b._z;
			return ( _g1 > _g2 )? 1 : -1;
		}

		private function _onResize( e:Event ):void
		{
			_world.x = stage.stageWidth * .5;
			_world.y = stage.stageHeight * .5;
		}
	}
}



	import flash.display.Sprite;
	import flash.display.GradientType;
	import flash.filters.BlurFilter;

	class GlassBall extends Sprite
	{

		public static var distance:Number = 1000;
		public static var focus:Number = 500;

		public var _x:Number = 0;
		public var _y:Number = 0;
		public var _z:Number = 0;
		public var _vx:Number = 0;
		public var _vy:Number = 0;
		public var _vz:Number = 0;
		public var next:GlassBall;
		private var _head:Sprite;
		private var _light:Sprite;
		private var _filter:BlurFilter;

		private var _r:Number = .2;
		private var _sin:Number = Math.sin(_r / 180 * Math.PI);
		private var _cos:Number = Math.cos(_r / 180 * Math.PI);

		public function GlassBall(_size:Number = 32, _x:Number = 0, _y:Number = 0, _z:Number = 0 )
		{
			// constructor code
			this._x = _x;
			this._y = _y;
			this._z = _z;
			this.visible = false;
			_head = new Sprite();
			addChild( _head );
			
			var fillType:String = GradientType.LINEAR;
			var colors:Array = [0x071AD9, 0x192E6D];
			var alphas:Array = [1, 1];
			var ratios:Array = [0x00, 0xFF];
			
			_head.graphics.beginGradientFill(fillType, colors, alphas, ratios);
			_head.graphics.drawCircle( 0, 0, _size );
			_head.graphics.endFill();
			
			_light = new Sprite();
			addChild( _light );
			
			colors = [0xFFFFFF, 0xFFFFFF];
			alphas = [.4, 0];
			
			_light.graphics.beginGradientFill(fillType, colors, alphas, ratios);
			_light.graphics.drawCircle( 0, 0, _size );
			_light.graphics.endFill();
			_light.scaleX = .5;
			_light.scaleY = .7;
			_light.x = -_size * .45;
			
			this.rotation = 90;
		}

		public function update():void
		{
			this._x = this._x * _cos - this._z * _sin;
			this._z = this._x * _sin + this._z * _cos;

			var _scaleRatio:Number = focus / ( focus + ( this._z + distance ));

			if (_scaleRatio > .01 && this._z - distance < 0)
			{
				this.visible = true;
				this.x = this._x * _scaleRatio;
				this.y = this._y * _scaleRatio;
				this.scaleX = this.scaleY = _scaleRatio;

				var _b:Number = ( this._z > 0 )? this._z : -this._z;
				_b = _b / distance;
				var _f:int = Math.floor(_b * 5);
				_f = ( _f > 3 )? 3 : _f;
				_f = Math.pow(2,_f);
				_filter = new BlurFilter(_f,_f);
				this.filters = [_filter];
			}
			else
			{
				this.visible = false;
				this.filters = null;
			}
		}
	}