/**
 * Copyright sowcodWonderfl ( http://wonderfl.net/user/sowcodWonderfl )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/teqk
 */

package {
    import flash.display.Sprite;
    import flash.display.Graphics;
    import flash.media.Sound;
    import flash.media.SoundChannel;
    import flash.media.SoundTransform;
    import flash.events.SampleDataEvent;
    import flash.events.MouseEvent;
    import flash.events.Event;
    import flash.geom.Rectangle;
    import flash.text.TextField;
    import flash.text.TextFormat;
    import flash.text.TextFieldAutoSize;
    
    public class UFO extends Sprite {
        private var _sound:Sound;
        private var _channel:SoundChannel;
        private var _textField:TextField;
        private var _ufo:Sprite;
        private var _moirLayer:Sprite;
        
        public static var TEXT_STOPPING:String = "Click to Play";
        public static var TEXT_PLAYING:String = "Click to Stop";
        
        public function UFO() {
            this._sound = new Sound();
            this._sound.addEventListener(SampleDataEvent.SAMPLE_DATA,onSampleData);
            
           this.addChild(createBackground());
           this.addEventListener(MouseEvent.CLICK, onClick);
           
           this._moirLayer = new Sprite();
           this.addChild(this._moirLayer);
           
           this._textField = createTextField();
           this.addChild(this._textField);
           
           this._ufo = createUFO();
           this._ufo.visible = false;
           this.addChild(this._ufo);
           
           this._channel = null;
           this._textField.text = TEXT_STOPPING;
        }
        
        private function onClick(ev:MouseEvent):void {
            if(this._channel == null) {
                this._channel = this._sound.play();
                this._ufo.visible = true;
                this._textField.text = TEXT_PLAYING;
            } else {
                this._channel.stop();
                this._channel = null;
                this._ufo.visible = false;
                this._textField.text = TEXT_STOPPING;
            }
        }
        
        private function onSampleData(ev:SampleDataEvent):void {
			var wave:Number = Math.random() * 3 + 1;
            for ( var c:int=0; c<4000; c++ ) {
				ev.data.writeFloat(Math.sin((Number(c+ev.position)/Math.PI/wave))*0.25);
				ev.data.writeFloat(Math.sin((Number(c+ev.position)/Math.PI/wave))*0.25);
			}
			if (this._channel != null) {
			    var pan:Number = Math.sin(Math.random()*2-1);
			    var trans:SoundTransform = new SoundTransform(1,pan);
			    this._channel.soundTransform = trans;
			    this._ufo.x = 250 + pan * 250;
			    this._ufo.y = 250 + ((wave - 2.5) / 3) * 250;
			    
			    // create Moir effect
			    var moir:Moir = new Moir();
			    var self:UFO = this;
			    moir.x = this._ufo.x;
			    moir.y = this._ufo.y;
			    moir.addEventListener(Event.COMPLETE,function(ev:Event):void{
 			        self._moirLayer.removeChild(moir);
			        moir.removeEventListener(Event.COMPLETE, arguments.callee);
			    });
			    this._moirLayer.addChild(moir);
			}
        }
        
        private function createBackground():Sprite {
            var sp:Sprite = new Sprite();
            var g:Graphics = sp.graphics;
            g.beginFill(0x000000);
            g.drawRect(0,0,500,500);
            
            return sp;
        }
        
        private function createTextField():TextField {
            var field:TextField = new TextField();
            var format:TextFormat = new TextFormat();
            
            format.size = 30;
            format.color = 0xffffff;
            
            field.defaultTextFormat = format;
            field.autoSize = TextFieldAutoSize.LEFT;
            
            return field;
        }
        
        private function createUFO():Sprite {
            var sp:Sprite = new Sprite();
            var g:Graphics = sp.graphics;
            g.beginFill(0x005588);
            g.drawCircle(0,0,15);
            g.endFill();
            g.lineStyle(0,0xff0000);
            g.drawEllipse(-20,-10,40,20);
            
            return sp;
        }
    }
}

import flash.display.Sprite;
import flash.display.Graphics;
import flash.events.Event;

class Moir extends Sprite {
    private var _step:Number;
    public static var MAX_STEP:Number = 12;
    public static var MAX_SIZE:Number = 70;
    
    public function Moir() {
        var g:Graphics = this.graphics;
        g.lineStyle(0,0xffffff);
        g.drawCircle(0,0,1);
        
        this._step = 0;
        
        this.addEventListener(Event.ENTER_FRAME,onEnterFrame);
    }
    
    private function onEnterFrame(ev:Event):void {
        this._step += 1;
        if( this._step <= MAX_STEP ) {
            this.alpha = Math.cos((this._step / MAX_STEP)*Math.PI/2);
            this.scaleX = this.scaleY = Math.sin((this._step / MAX_STEP)*Math.PI/2) * MAX_SIZE;
        } else {
            // finish
            this.dispatchEvent(new Event(Event.COMPLETE));
            this.removeEventListener(Event.ENTER_FRAME,onEnterFrame);
        }
    }
}