/**
 * Copyright naokey0221 ( http://wonderfl.net/user/naokey0221 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/teYH
 */

// forked from abe02makoto's forked from: [Box2D][PV3D] 3D Ball Simulation
// forked from clockmaker's [Box2D][PV3D] 3D Ball Simulation
/*===================================================*//**
 * Box23DAS3 and Papervision3D Demo
 * Please drag stage balls
 * 
 * @author Yasu
 * @see http://clockmaker.jp/blog/
 * @since 2009.03.31
 *//*===================================================*/
package
{
    import Box2D.Collision.Shapes.*;
    import Box2D.Collision.b2AABB;
    import Box2D.Common.Math.b2Vec2;
    import Box2D.Dynamics.Joints.*;
    import Box2D.Dynamics.*;
    import flash.ui.*;
    import jp.progression.casts.CastButton;
    
    import flash.display.*;
    import flash.events.*;
    import flash.geom.*;
    import flash.net.*;
    
    import org.papervision3d.events.*;
    import org.papervision3d.lights.*;
    import org.papervision3d.materials.shadematerials.*;
    import org.papervision3d.objects.*;
    import org.papervision3d.view.*;
    import org.papervision3d.objects.primitives.*;

    [SWF(width="464", height="465", frameRate="60", backgroundColor="0")]
    public class Main extends BasicView
    {
        // const vars
        static public const OBJ_SIZE:int = 10;
        static public const OBJ_NUM:uint = 50;
        static public const OBJ_COLOR:uint = 0x3399FF;
        
        // vars for Box2D
        private var worldWidth:Number;
        private var worldHeight:Number;
        private var m_iterations:int;
        private var m_wallWidth:Number;
        private var m_wallHeight:Number;
        private var m_timeStep:Number;
        private var m_physScale:Number;
        private var m_world:b2World;
        private var m_mouseJoint:b2MouseJoint;
        private var m_draggedBody:b2Body;
        private var mouseXWorldPhys:Number;
        private var mouseYWorldPhys:Number;
        private var isMouseDown:Boolean;
        private var arrayIndex:int;
        
        // array of objs
        private var pv3dObjsArr:Vector.<DisplayObject3D> = new Vector.<DisplayObject3D>(OBJ_NUM, true);
        private var box3dSpapesArr:Vector.<b2Body> = new Vector.<b2Body>(OBJ_NUM, true);
        
        /**
         * Constructor
         */
        public function Main()
        {
            stage.quality = StageQuality.MEDIUM;
            
            // init PV3D
            super(465, 465, false, true);
            
            // init PV3D World
            createPaervision3dWorld();
            
            // init Box2D World
            createBox2dWorld()
            
            // init vars for drag
            arrayIndex = -1;
            isMouseDown = false;

            // addEvent
            addEventListener(Event.ENTER_FRAME, enterFrameHandler);
            stage.addEventListener(MouseEvent.MOUSE_DOWN, mouseDownHandler);
            stage.addEventListener(MouseEvent.MOUSE_UP, mouseUpHandler);
            
            // Backgound
            createBackGround();
            cerateFullScreenBtn();
        }
        
        /**
         * Create Papervision3D World
         */
        private function createPaervision3dWorld():void
        {
            camera.zoom = 1000 / camera.focus + 1;
            camera.x = 0;
            camera.z = -1000;
            
            // create light
            var light:PointLight3D = new PointLight3D();
            light.z = -100;
            
            for(var i:int=0; i < OBJ_NUM; i++)
            {
                var mat:FlatShadeMaterial = new FlatShadeMaterial(light, OBJ_COLOR);
                mat.interactive = true;
                
                var obj3d:DisplayObject3D = scene.addChild(new Sphere(mat, OBJ_SIZE/2, 10, 10));
                obj3d.extra = { radius:OBJ_SIZE, arrayPos:i };
                obj3d.x = - i * 50 + 100;
                obj3d.y = Math.random() * -200;
                obj3d.addEventListener(InteractiveScene3DEvent.OBJECT_PRESS, obj3dMousePressHandler);
                obj3d.addEventListener(InteractiveScene3DEvent.OBJECT_OVER, obj3dMouseOverHandler);
                obj3d.addEventListener(InteractiveScene3DEvent.OBJECT_OUT, obj3dMouseOutHandler);
                
                pv3dObjsArr[i] = obj3d;
            }
        }
        
        /**
         * Create Box2D World
         */
        private function createBox2dWorld():void
        {
            // init Box2D
            worldWidth = stage.stageWidth;
            worldHeight = stage.stageHeight;
            m_iterations = 30;
            m_timeStep = 1 / stage.frameRate;
            m_physScale = 60;
            var worldAABB:b2AABB = new b2AABB();
            worldAABB.lowerBound.Set( -1000, -1000);
            worldAABB.upperBound.Set(1000, 1000);
            var gravity:b2Vec2 = new b2Vec2(0, 30);
            var doSleep:Boolean = true;
            m_world = new b2World(worldAABB, gravity, doSleep);

            // craete wall for Box2D
            var wallShapeDef:b2PolygonDef = new b2PolygonDef();
            var wallBodyDef:b2BodyDef = new b2BodyDef();
            var wall:b2Body;
            m_wallWidth = stage.stageWidth;
            m_wallHeight = stage.stageHeight;

            // left wall
            wallShapeDef.SetAsBox(10 / m_physScale, m_wallHeight / 2 / m_physScale);
            wallBodyDef.position.Set(0, m_wallHeight / 2 / m_physScale);
            wall = m_world.CreateBody(wallBodyDef);
            wall.CreateShape(wallShapeDef);

            // right wall
            wallBodyDef.position.Set(m_wallWidth / m_physScale, m_wallHeight / 2 / m_physScale);
            wall = m_world.CreateBody(wallBodyDef);
            wall.CreateShape(wallShapeDef);

            // upper wall
            wallShapeDef.SetAsBox(m_wallWidth / 2 / m_physScale, 10 / m_physScale);
            wallBodyDef.position.Set(m_wallWidth / 2 / m_physScale, 0);
            wall = m_world.CreateBody(wallBodyDef);
            wall.CreateShape(wallShapeDef);
            
            // bottom wall
            wallBodyDef.position.Set(m_wallWidth / 2 / m_physScale, m_wallHeight / m_physScale);
            wall = m_world.CreateBody(wallBodyDef);
            wall.CreateShape(wallShapeDef);
            
            wall.SetMassFromShapes();
            
            for(var i:int=0; i < OBJ_NUM; i++)
            {
                var obj3d:DisplayObject3D = pv3dObjsArr[i];
                
                var boxShape:b2CircleDef = new b2CircleDef();
                boxShape.radius = OBJ_SIZE / m_physScale / 2;
                boxShape.density = 3;
                boxShape.friction = 5;
                boxShape.restitution = 0.5;
                var bodyDef:b2BodyDef = new b2BodyDef();
                bodyDef.position.Set((obj3d.x + worldWidth / 2) / m_physScale, (obj3d.y + worldHeight / 2) / m_physScale);
                var body:b2Body = m_world.CreateBody(bodyDef);
                body.CreateShape(boxShape);
                body.SetUserData(obj3d);
                body.SetMassFromShapes();
                
                box3dSpapesArr[i] = body;
            }
        }
        
        
        /**
         * get mouse position, and convert box2d scale
         */
        private function updateMouseWorld():void
        {
            mouseXWorldPhys = mouseX / m_physScale;
            mouseYWorldPhys = mouseY / m_physScale;
        }

        /**
         * Enter Frame
         * @param    event
         */
        private function enterFrameHandler(event:Event):void
        {
            // update Box2D step
            updateMouseWorld();
            mouseDrag();
            m_world.Step(m_timeStep, m_iterations);

            // sync position to PV3D from Box2D
            for (var bb:b2Body = m_world.GetBodyList(); bb; bb = bb.GetNext())
            {
                if (bb.GetUserData()is DisplayObject3D)
                {
                    bb.GetUserData().x = bb.GetPosition().x * m_physScale - worldWidth / 2;
                    bb.GetUserData().y = -bb.GetPosition().y * m_physScale + worldHeight / 2;
                    bb.GetUserData().rotationZ = -bb.GetAngle() * (180 / Math.PI);
                }
            }
            singleRender();    
        }

        /**
         * get number of pv3d clicked obj
         * @param    event
         */
        private function obj3dMousePressHandler(event:InteractiveScene3DEvent):void
        {
            arrayIndex = (event.target as DisplayObject3D).extra.arrayPos;
        }

        /**
         * Drag And Drop
         */
        private function mouseDrag():void
        {
            if (isMouseDown && ! m_mouseJoint)
            {
                m_draggedBody = null;
                    
                if (arrayIndex > -1)
                    m_draggedBody = box3dSpapesArr[arrayIndex];
                
                if (m_draggedBody)
                {
                    var md:b2MouseJointDef = new b2MouseJointDef();
                    md.body1 = m_world.GetGroundBody();
                    md.body2 = m_draggedBody;
                    md.target.Set(mouseXWorldPhys, mouseYWorldPhys);
                    md.maxForce = 300 * m_draggedBody.GetMass();
                    md.timeStep = m_timeStep;
                    m_mouseJoint = m_world.CreateJoint(md) as b2MouseJoint;
                    m_draggedBody.WakeUp();
                }
            }

            if (!isMouseDown)
            {
                if ( m_mouseJoint )
                {
                    m_world.DestroyJoint( m_mouseJoint );
                    m_mouseJoint = null;
                }
            }

            if ( m_mouseJoint )
            {
                var p2:b2Vec2 = new b2Vec2(mouseXWorldPhys, mouseYWorldPhys);
                m_mouseJoint.SetTarget(p2);
            }
        }
        
        /**
         * Mouse Down
         * @param    event
         */
        private function mouseDownHandler(event:MouseEvent):void
        {
            
            isMouseDown = true;
        }

        /**
         * Mouse Up
         * @param    event
         */
        private function mouseUpHandler(event:MouseEvent):void
        {
            Mouse.cursor = MouseCursor.ARROW;
            isMouseDown = false;
            arrayIndex = -1;
        }
        
        private function obj3dMouseOverHandler(e:InteractiveScene3DEvent):void 
        {
            Mouse.cursor = MouseCursor.HAND;
        }
        
        private function obj3dMouseOutHandler(e:InteractiveScene3DEvent):void 
        {
            if(!isMouseDown)
                Mouse.cursor = MouseCursor.ARROW;
        }
        
        private function createBackGround():void
        {
            var bgMatrix:Matrix = new Matrix();
            bgMatrix.rotate(90 * Math.PI / 180);
            graphics.beginGradientFill("linear", [0xFFFFFF, 0x001122], [100, 100], [0, 255], bgMatrix);
            graphics.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
        }
        
        private function cerateFullScreenBtn():void
        {
            var btn:CastButton = new CastButton();
            btn.toolTip.text = "Go Full Screen / Normal Screen";
           // btn.toolTip.delay = 250;
            
            var loader:Loader = new Loader();
            loader.load(new URLRequest("http://wonderfl.kayac.com/img/code/out_arrow_o.gif"));
            
            btn.addChild(loader);
            btn.x = 435;
            btn.y = 5;
            
            btn.addEventListener(MouseEvent.CLICK, function():void
            {
                if (stage.displayState == StageDisplayState.FULL_SCREEN)
                    stage.displayState = StageDisplayState.NORMAL;
                else
                    stage.displayState = StageDisplayState.FULL_SCREEN;
            });
            
            addChild(btn);
        }
    }
}