/**
 * Copyright nhubben ( http://wonderfl.net/user/nhubben )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/teJc
 */

// forked from nhubben's Slightly more interesting Beach Wind Thingy
// forked from nhubben's Stupid Beach Wind Thingy
package {
    import flash.display.Sprite;
    import flash.display.MovieClip;
    import flash.events.Event;
    import flash.display.BlendMode;
    import flash.filters.*;
    
  
    import com.bit101.components.*;
    
    [SWF(width="500", height="500", backgroundColor="#000000", frameRate="60")]
    public class StupidWindThingy extends Sprite {
        
        private var thingy:Sprite;
        private var color:uint = Math.random() * 0xFFFFFF;
        private var form:String = "circle";
        
        private var rings:Vector.<MovieClip> = new Vector.<MovieClip>();
        
        public function StupidWindThingy() {
            
            thingy = new Sprite();
            addChild( thingy );
            thingy.x = stage.stageWidth * .5;
            thingy.y = stage.stageHeight * .5;
            
             
            var r:MovieClip;
            var total:int = 20;
            var angleSegment:Number = 90 / total;
            var size:Number;
            var half:Number;
            
            var clrSegment:Number = 360 / total;
             var clr:uint ;
            for( var i:int = 0 ; i < total ; i++ ){
                
                r = new MovieClip();
                size = 40 + ( i * 20 );
                half = size * .5;
                
                with( r.graphics ){
                    
                   clr = HSLtoRGB( 1, i*clrSegment, 1, .5)
                   lineStyle( 5, clr );
                     
                    switch( form ){
                        case "circle":
                            drawCircle( 0, 0, size  * 0.5 );
                            break;
                            
                        case "diamond":
                            //drawRect( -half, -half, size, size );
                            moveTo( 0, -half );
                            lineTo( half, 0 );
                            lineTo( 0, half );
                            lineTo( -half, 0 );
                            lineTo( 0, -half );
                            break;
                    }
              
                }
             
                r.spin = ( i * 12) / i  ;
                
                r.rotationY = i * angleSegment * 4;
                thingy.addChild( r );    
            
                rings.push( r );
            }
             
            
            thingy.filters = [ new BlurFilter(44,44) ]; 
            
            thingy.blendMode = BlendMode.MULTIPLY; 
             
             
            addEventListener( Event.ENTER_FRAME, draw );
        }
       
        
            
        private function draw(e:Event):void{
            // thingy.rotationY += 5;
            
            for each( var mc:MovieClip in rings ){
                mc.rotationY += mc.spin;
            }

        }
        
        
        // HSL to RGB
        // from http://blog.wonderwhy-er.com/as3-hsl-to-rgb/
        //
        private function HSLtoRGB(a:Number=1,hue:Number=0,saturation:Number=0.5,lightness:Number=1 ) : uint{
            a = Math.max(0,Math.min(1,a));
            saturation = Math.max(0,Math.min(1,saturation));
            lightness = Math.max(0,Math.min(1,lightness));
            hue = hue%360;
            if(hue<0)hue+=360;
            hue/=60;
            var C:Number = (1-Math.abs(2*lightness-1))*saturation;
            var X:Number = C*(1-Math.abs((hue%2)-1));
            var m:Number = lightness-0.5*C;
            C=(C+m)*255;
            X=(X+m)*255;
            m*=255;
            
            if(hue<1) return (Math.round(a*255)<<24)+(C<<16)+(X<<8)+m;
            if(hue<2) return (Math.round(a*255)<<24)+(X<<16)+(C<<8)+m;
            if(hue<3) return (Math.round(a*255)<<24)+(m<<16)+(C<<8)+X;
            if(hue<4) return (Math.round(a*255)<<24)+(m<<16)+(X<<8)+C;
            if(hue<5) return (Math.round(a*255)<<24)+(X<<16)+(m<<8)+C;
            
            return ( Math.round(a*255) << 24 ) + (C<<16) + ( m<<8) + X;
        }

    }
   
}
 