/**
 * Copyright Jacky.Riawan ( http://wonderfl.net/user/Jacky.Riawan )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/td5m
 */

package  
{
    import flash.display.Sprite;
    import flash.display.StageQuality;
    import flash.events.Event;
    import flash.events.FocusEvent;
    import flash.events.KeyboardEvent;
    import flash.events.MouseEvent;
    import flash.media.Sound;
    import flash.media.SoundLoaderContext;
    import flash.net.URLRequest;
    import flash.system.Security;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    import flash.text.TextFormat;
    /**
     * ...
     * @author Jacky Riawan
     */
    [SWF(width=400,height=400,frameRate=40)]
    public class Main extends Sprite
    {
        private const musicURL:String = "http://www.jekipedia.com/upload/music/track.mp3";
        private const tableDamageURL:String = "http://www.jekipedia.com/upload/music/tabledamage.mp3";
        private const tableSafeURL:String = "http://www.jekipedia.com/upload/music/tablesafe.mp3";
        private const tableThrowURL:String = "http://www.jekipedia.com/upload/music/tablethrow.mp3";
        private const buttonURL:String = "http://www.jekipedia.com/upload/music/button.mp3";
        private const crossDomain:String="http://www.jekipedia.com/crossdomain.xml"
        private const angryDude:Sprite = new Sprite();
        private const chillDude:Sprite = new Sprite();
        private const angryDudeText:TextField=new TextField();
        private const chillDudeText:TextField = new TextField();
        private const angryDudeSpeech:Sprite = new Sprite();
        private const chillDudeSpeech:Sprite = new Sprite();
        private const angrySpeech:TextField = new TextField();
        private const chillSpeech:TextField = new TextField();
        private var chillTextTimer:int = 0;
        private var angryTextTimer:int = 0;
        //
        private const THROWSTATE:String = "(╯°□°）╯";
        private const NOTHROWSTATE:String = "(\\°□°）\\";
        private const CATCHSTATE:String = "ノ(º_ºノ)";
        private const NOCATCHSTATE:String = "\\(º_º\\)";
        private const CHILLSTATE:String = "(\\°_°）\\";
        //
        
        //
        private const EMPTY:int = 0;
        private const READY:int = 1;
        private const FULL:int = 2;
        //
        private var chillDudeState:int;
        //
        private var ground:int = 0;
        private var rightLimit:int = 0;
        private var leftLimit:int = 100;
        //table
        private var tableTimer:int = 0;
        private var tableList:Array
        private var tableParts:Array
        //angry dude
        private var angryDudePosX:int;
        private var launchTimer:int = 40;
        private var throwTimer:int = 40;
        private var throwTimerMax:int = 40;
        private var angryDudeState:int = EMPTY;
        //chill dude
        private var speedMove:int = 0;
        private var catchTimer:int = 0
        //
        private const gameTitle:TextField = new TextField();
        private const startTxt:TextField = new TextField();
        private const instruction:TextField = new TextField();
        private const bigFont:TextFormat = new TextFormat(null, 25);
        private const skipText:TextField = new TextField();
        //
        private const difficulty:TextField = new TextField();
        private const easy:TextField = new TextField();
        private const normal:TextField = new TextField();
        private const hard:TextField = new TextField();
        private const insane:TextField = new TextField();
        
        //
        private const stressLevelText:TextField = new TextField();
        private const tableLeftText:TextField = new TextField();
        private const stressBar:Sprite = new Sprite();
        private var stressNum:int = 100;
        private var stressMax:int=100
        //
        private var preloaderText:TextField = new TextField();
        //
        private var staggerTime:int = 0;
        private var storyTimer:int = 0;
        private var story:Array = new Array();
        private var waveData:Array = new Array();
        //
        private const angryWords:Array = ["GRRR!!", "SMASH!","STUPID TABLE!", "NOOO!!", "GYAAA", "GROAAAA!!", "THAT'S IT!!", "!%$^!!", "WHY MEEEE!!", "LIFE IS SUCKS!!", "NO MORE!!", "I HATE THIS TABLE!", "STUPID!!", "I DESERVE BETTER!", "WHYYY??", "NEVER!!!", "CRUEL LIFE!!", "I HATE LIFE!", "WHY IT HAVE TO BE LIKE THIS?"];
        private const chillWords:Array = ["Calm down bro!","Chill out bro!","That was close!","Phew!","Relax man!","Think about it","Chill bro","Calm down man!","Don't worry","Stop it!","No more this ok?","Why don't we talk?","Don't worry","It's gonna be OK!","Calm yourself!","Everything gonna be ok!","Let me help you!"];
        private const preloaderWords:Array=["The game will be\nloaded soon!","Hang in there!","You doing GREAT!","It will be fun!","Any moment now!","Patience is a virtue","Soon i can feel it!","This game is presented by:\nJacky Riawan"] 
        private var loseStory:Array;
        private var winStory:Array;
        private var bgm:Sound;
        private var buttonSound:Sound;
        private var tableDamageSound:Sound;
        private var tableSafeSound:Sound;
        private var tableThrowSound:Sound;
        private var numLoaded:int = 0;
        public function Main() 
        {
            Security.loadPolicyFile(crossDomain);
            //
            stage.quality = StageQuality.LOW;
            stage.focus = stage;
            addEventListener(FocusEvent.FOCUS_OUT, focusBack);
            initGameObjects();
            //initGame();
            //initMenu();
            loadingAssets();    
        }
        
        private function loadingAssets():void 
        {
            bgm = new Sound(new URLRequest(musicURL), new SoundLoaderContext(4000, true));
            buttonSound = new Sound(new URLRequest(buttonURL));
            tableDamageSound = new Sound(new URLRequest(tableDamageURL));
            tableSafeSound = new Sound(new URLRequest(tableSafeURL));
            tableThrowSound = new Sound(new URLRequest(tableThrowURL));
            bgm.addEventListener(Event.COMPLETE, playMusic);
            buttonSound.addEventListener(Event.COMPLETE, soundLoaded);
            tableDamageSound.addEventListener(Event.COMPLETE, soundLoaded);
            tableSafeSound.addEventListener(Event.COMPLETE, soundLoaded);
            tableThrowSound.addEventListener(Event.COMPLETE, soundLoaded);
            addEventListener(Event.ENTER_FRAME, preloaderStep);
            addChild(chillDude);
            addChild(preloaderText);
            addChild(chillDudeSpeech);
            chillDudeText.text = CATCHSTATE;
            chillDude.x = stage.stageWidth - 160;
            chillDude.y = stage.stageHeight-50;
            chillDudeSpeech.x = chillDude.x;
            chillDudeSpeech.y = chillDude.y - 30;
            addChild(chillDudeSpeech);
            updateText("Hi, please relax...!\nThe game is loading", true);
            storyTimer = 900;
        }
        private function preloaderStep(e:Event):void 
        {
            updateSpeech();
            if (numLoaded == 5) {
                chillSpeech.text = "";
                removeChild(chillDudeSpeech);
                removeEventListener(Event.ENTER_FRAME, preloaderStep);
                removeChild(chillDude);
                removeChild(preloaderText);
                initMenu();
            }else{
                preloaderText.text = "External assets loaded: " + numLoaded + " / 5"
                if(storyTimer==0){
                    updateText(preloaderWords[int(preloaderWords.length * Math.random())], true);
                    storyTimer = 400;
                }else {
                    storyTimer--;
                }
            }
        }
        
        private function soundLoaded(e:Event):void 
        {
            numLoaded++;
            e.target.removeEventListener(Event.COMPLETE, soundLoaded);
        }
        
        private function playMusic(e:Event):void 
        {
            numLoaded++;
            bgm.play(0, 99999);
            bgm.removeEventListener(Event.COMPLETE, playMusic);
        }
        
        private function initMenu():void 
        {
            
            addChild(gameTitle);
            addChild(startTxt);
            addChild(instruction);
        }
        private function initDifficulty():void {
            addChild(difficulty);
            addChild(easy);
            addChild(normal);
            addChild(hard);
            addChild(insane);
        }
        private function focusBack(e:FocusEvent):void 
        {
            stage.focus = stage;
        }
        
        private function initGameObjects():void 
        {
            preloaderText.autoSize = TextFieldAutoSize.CENTER;
            preloaderText.selectable = false;
            preloaderText.y = 100;
            preloaderText.x = stage.stageWidth / 2;
            //
            easy.text = "Easy";
            normal.text = "Normal";
            hard.text = "Hard";
            insane.text = "Insane";
            easy.selectable = normal.selectable = hard.selectable = insane.selectable = false;
            easy.autoSize = normal.autoSize = hard.autoSize = insane.autoSize = TextFieldAutoSize.CENTER;
            easy.x = stage.stageWidth / 2 - easy.width / 2;
            normal.x = stage.stageWidth / 2 - normal.width / 2;
            hard.x = stage.stageWidth / 2 - hard.width / 2;
            insane.x = stage.stageWidth / 2 - insane.width / 2;
            easy.y = 140;
            normal.y = 170;
            hard.y = 200;
            insane.y = 230;
            easy.addEventListener(MouseEvent.CLICK, easyHandler);
            normal.addEventListener(MouseEvent.CLICK, normalHandler);
            hard.addEventListener(MouseEvent.CLICK, hardHandler);
            insane.addEventListener(MouseEvent.CLICK, insaneHandler);
            //
            difficulty.text = "Difficulty";
            difficulty.selectable = false;
            difficulty.setTextFormat(bigFont);
            difficulty.autoSize = TextFieldAutoSize.CENTER;
            difficulty.x = stage.stageWidth / 2 - startTxt.width / 2;
            difficulty.y = 90;
            //
            startTxt.text = "Start Game";
            startTxt.selectable = false;
            startTxt.autoSize = TextFieldAutoSize.CENTER;
            startTxt.addEventListener(MouseEvent.CLICK, startHandler);
            startTxt.x = stage.stageWidth / 2 - startTxt.width / 2;
            startTxt.y = 200;
            //
            instruction.text = "Instructions:\nCalm down your friend & save as many table as possible!\nControl:\n[A] or [<=] to Move Left\n[D] or [=>] to Move Right\n\nGame by: Jacky Riawan";
            instruction.selectable = false;
            instruction.autoSize = TextFieldAutoSize.CENTER;
            instruction.y = 230;
            instruction.x = stage.stageWidth / 2 - instruction.width / 2;
            //
            gameTitle.text = "Chill Out Bro!";
            gameTitle.autoSize = TextFieldAutoSize.CENTER;
            gameTitle.setTextFormat(bigFont);
            gameTitle.y = 90;
            gameTitle.x = stage.stageWidth / 2 - gameTitle.width / 2;
            gameTitle.selectable = false;
            //
            stressBar.addChild(stressLevelText);
            stressBar.addChild(tableLeftText);
            stressLevelText.y = 8;
            tableLeftText.y = 25;
            tableLeftText.selectable = false;
            stressLevelText.x = tableLeftText.x = 12;
            //
            skipText.text = "Skip";
            skipText.x = stage.stageWidth - skipText.width / 2;
            skipText.selectable = false;
            skipText.addEventListener(MouseEvent.CLICK, skipEvent);
            //
            angryDudeText.text = NOTHROWSTATE;
            angryDudeText.selectable = false;
            angryDude.addChild(angryDudeText);
            chillDudeText.text = NOCATCHSTATE;
            chillDudeText.selectable = false;
            chillDude.addChild(chillDudeText);
            angryDudeSpeech.addChild(angrySpeech);
            chillDudeSpeech.addChild(chillSpeech);
            angrySpeech.selectable = false;
            chillSpeech.selectable = false;
            angrySpeech.autoSize = TextFieldAutoSize.LEFT;
            chillSpeech.autoSize = TextFieldAutoSize.LEFT;
        }
        
        private function insaneHandler(e:MouseEvent):void 
        {
            staggerTime = 0;
            throwTimerMax = 5;
            stressMax = 500;
            stressLevelText.text="Stress lv. 4"
            story = ["I HATE THEM!", false, "Who's you're talking about?", true, "My parents!", false, "Oh... why?", true, "They are getting divorced...", false, "Oh...", true, "We once a happy family...", false, "Now it's gone!!", false, "THAT'S HER FAULT", false, "Who?", true, "THAT EVIL WOMAN!", false, "My dad going to marry her!!", false, "After the divorce", false, "I'M GOING TO KILL HER!", false, "Whoah.. calm down bro!", true, "Maybe it's for the best", true, "No...", false , "Maybe they have talked\nabout this...", true, "No...", false, "It's the best for all of you!", true, "...", false, "I'm sure they still love you!", true, "NO!!! THEY DON'T CARE ABOUT ME!", false, "THEY NEVER CARE ABOUT ME!!", false];
            winStory = ["...", false, "Hey...", true,"Are you calm now?",true,"...",false,"... yeah",false, "Want to hear\nmy advice?", true, "...", false, "Yes...", false, "Did you love your parents?", true, "Yeah...", false, "More than anything?", true, "Yeah...", false, "More than anything...", false, "You want them to be happy right?", true, "Yeah...", false, "Then as long as...", true,"They happy you should...",true,"Be happy for them...",true,"Maybe this is the way for them\n",true,"To be happy...",true,"...",false,"You're right... I was selfish...",false,"Thanks for being my friend...",false,"That i can count for",false,"No sweat bro...",true,"Do you want an ice cream?",true,"Cmon my treat",true,"I heard that...",true,"Ice cream is magic medicine",true,"That can heal a broken heart",true,"Hahaha... let's go then :D",false,":D",true];
            waveData = [50,20,20,15,10,15,30,15,70,80,10,15,10,15,30,30,10,15,30,25,25,15,15,10,23,10,14,40,90,10,40,10,50,60,70,20,15,10,15,10,50,70,90,10,15,10,15,20,60,60,70,100,20,20,20,10,10,15,10,50,50,60,50,20,20,15,10,15,30,15,70,80,10,15,10,15,30,30,10,15,30,25,25,15,15,10,23,10,14,40,10];
            tableLeftText.text = "Table left: " + waveData.length;
            removeDiff();
            initGame();
        }
        
        private function skipEvent(e:MouseEvent):void 
        {
            buttonSound.play();
            story = new Array();
            storyTimer=0;
        }
        
        private function hardHandler(e:MouseEvent):void 
        {
            staggerTime = 20;
            throwTimerMax = 10;
            stressMax = 300;
            stressLevelText.text="Stress lv. 3"
            story = ["I CAN'T BELIEVE THIS!!", false, "Hey, what's going on?", true, "My girlfriend cheated on me!", false, "Oh... are you sure?", true, "I love her...", false, "So much...", false, "How could she?", false, "HOW COULD SHE!!!", false, "...", true, "I TRUST HER!", false, "She betrayed my trust!!", false, "Calm down bro...", true, "NO! I WONT CALM DOWN!", false, "Please calm down...", true, "NO I WONT!", false, "Uh oh...", true, "I smell alcohol", true, "Did you had a drink?", true, "ARRRGGGGGHHH", false, "Uh oh!...", true, "WHYYYYYYYYYY!!", false];
            winStory = ["No...", false, "What have i done!?", false, "You ok dude?", true, "Yeah i feel much better", false, "Good...", true, "Hey...", false, "Yeah?", true, "Why did she cheat on me?", false, "I don't know...", true, "Maybe she doesn't", true, "Maybe it's all just...", true, "Misunderstanding...", true, "...", false,"Yeah, you probably right",false,"Sorry i lose my temper",false,"Don't worry about it",true,"Thanks :)",false,"You welcome bro...",true,"No... I really mean it...",false,"Thanks...",false,":)",true];
            waveData = [50,50,40,40,60,60,150,60,20,20,20,20,20,60,70,20,40,40,30,40,40,30,60,37,70,120,50,60,20,20,20,30,20,40,30,20,30,20,40,60];
            tableLeftText.text = "Table left: " + waveData.length;
            removeDiff();
            initGame();
        }
        
        private function normalHandler(e:MouseEvent):void 
        {
            staggerTime = 40;
            stressMax = 200;
            throwTimerMax = 20;
            stressLevelText.text="Stress lv. 2"
            story = ["THIS IS STUPID!!", false, "What happen?", true, "I failed my exam!", false, "Did you study?", true, "Yeah i study, but i still got bad grade", false, "And I might not...", false, "Be able to go to university", false, "Because of my bad grade!!", false, "STUPID EXAM!!", false, "AND STUPID SCHOOL!", false, "Calm down bro!", true, "There's must be another way", true, "WHAT DO YOU KNOW??", false, "I CAN'T THINK!", false, "Uh oh!...", true, "GRRRRRRAAAAAAOOOOO!!", false];
            winStory = ["*hufff*", false, "....", false, "You ok dude?", true, "...", false, "...", true, "...", false, "I'm ok just...", false, "A bit tired...", false, "Wanna go chill out with me?", true, "Have some beer...", true, "Sure :)", false, "Hey!", false, "Yeah?", true,"Thank you for\nbeing my friend!",false,":)",true,":')",false];
            waveData = [120,100,40,40,80,80,40,80,80,80,70,70,120,70,40,80,60,60,60,40,90,70,67,70,120,100,100,70,50,50,60,70,70,80,50];
            tableLeftText.text = "Table left: " + waveData.length;
            removeDiff();
            initGame();
        }
        
        private function easyHandler(e:MouseEvent):void 
        {
            
            staggerTime = 50;
            stressMax = 100;
            throwTimerMax = 30;
            stressLevelText.text="Stress lv. 1"
            story = ["Nooooo!!", false, "Yo! what's up?", true, "My Adobe flash just crash", false, "Do you have a back up?", true, "Yeah but it's from last week", false, "And I'm on tight deadline!", false, "Calm down bro!", true, "ARRRGGHHH!!", false, "I'm so angry right now!!", false, "%$&!", false, "Uh oh! I think...", true, "He's gonna EXPLODEEE!!", true];
            winStory = ["...", false, "....", false, "Feeling better now?", true, "Dude! don't worry", true, "Everything gonna be OK!", true, "...", false, "...", false, "I'll help you", true, "Throwing things...", true, "Is not going to...", true, "Make things better", true, "Yeah you're right! :)", false, "I'm sorry", false,"It's ok let's go and finish the work!",true,"Let me help you!",true,"Thanks...",false];
            
            waveData = [200, 180, 100, 120, 150, 100, 120, 60, 70, 60, 80, 120, 80, 100, 120, 90, 60,110,70,50];
            tableLeftText.text = "Table left: " + waveData.length;
            removeDiff();
            initGame();
        }
        
        private function removeDiff():void 
        {
            removeChild(difficulty);
            removeChild(easy);
            removeChild(normal);
            removeChild(hard);
            removeChild(insane);
        }
        
        private function startHandler(e:MouseEvent):void 
        {
            buttonSound.play();
            removeChild(instruction);
            removeChild(gameTitle);
            removeChild(startTxt);
            initDifficulty();
        }
        private function updateText(txt:String, isChill:Boolean):void {
            if (isChill) {
                
                chillSpeech.text = txt + "\n\\";
                chillDudeSpeech.y = chillDude.y-chillSpeech.numLines*15;
                chillTextTimer = 60;
            }else {
                angrySpeech.text = txt + "\n/";
                angryDudeSpeech.y = angryDude.y-angrySpeech.numLines*15;
                angryTextTimer = 60;
            }
        }
        private function brokenParts(posx:Number,posy:Number,isLong:Boolean):void {
            var le:int = 5;
            if (isLong) {
                le = 17;
            }
            var part:Sprite = new Sprite();
            part.graphics.lineStyle(1);
            part.graphics.moveTo(-le,0);
            part.graphics.lineTo(le, 0);
            part.x = posx;
            part.y = posy;
            tableParts.push([part,(Math.random()-.5)*10,2+Math.random()*5,0]);
            addChild(part);
        }
        private function initGame():void 
        {
            throwTimer = throwTimerMax;
            storyTimer = 0;
            buttonSound.play();
            tableTimer = 100;
            loseStory = ["Uh oh...",true,"Oh no!",true,"He destroyed all the table",true,"GRRRR!!%$!!",false,"I BETTER RUN!!",true,"&%&£!!",false];
            tableParts = new Array();
            tableList =new Array();
            addChild(angryDude);
            addChild(chillDude);
            angryDudePosX=angryDude.x = 10
            ground = stage.stageHeight - 20;
            chillDude.y =ground-10;
            angryDude.y = ground-80;
            rightLimit = stage.stageWidth - 40;
            //
            chillDude.x = stage.stageWidth;
            angryDudeSpeech.x = angryDudePosX + 30;
            angryDudeSpeech.y = angryDude.y - 30;
            chillDudeSpeech.y = chillDude.y - 30;
            chillDudeSpeech.x = chillDude.x;
            addChild(chillDudeSpeech);
            addChild(angryDudeSpeech);
            //
            graphics.lineStyle(1);
            graphics.moveTo(0, ground - 63);
            graphics.lineTo(leftLimit, ground - 63);
            graphics.lineTo(leftLimit, ground+9);
            graphics.lineTo(stage.stageWidth, ground + 9);
            //
            addChild(stressBar);
            stressNum = stressMax;
            stressBarUpdate();
            stressBar.y = -40;
            addChild(skipText);
            //addEventListener(Event.ENTER_FRAME, update);
            addEventListener(Event.ENTER_FRAME, storyUpdate);
            
            //
        }
        private function removeGame():void {
            buttonSound.play();
            for (var i:int = 0; i < tableList.length; i++) {
                removeChild(tableList[i][0]);
                tableList[i][0] = null;
            }
            for (i = 0; i < tableParts.length; i++) {
                removeChild(tableParts[i][0]);
                tableParts[i] = null;
            }
            tableList = new Array();
            tableParts = new Array();
            graphics.clear();
            removeChild(stressBar);
            removeChild(angryDude);
            removeChild(chillDude);
            removeEventListener(Event.ENTER_FRAME, update);
            stage.removeEventListener(KeyboardEvent.KEY_DOWN, keyHandler);
        }
        private function storyUpdate(e:Event):void 
        {
            if (storyTimer == 0) {
                if (story.length == 0) {
                    addEventListener(Event.ENTER_FRAME, update);
                        stage.focus = stage;
                        removeChild(skipText);
                        stage.addEventListener(KeyboardEvent.KEY_DOWN, keyHandler);
                        removeEventListener(Event.ENTER_FRAME, storyUpdate);
                    }else {
                        updateText(story[0], story[1]);
                        story.splice(0, 2);
                        storyTimer = 100;
                    }
            }else {
                    chillDudeSpeech.x = chillDude.x;
                    if (chillDude.x > leftLimit + 140) {
                        chillDude.x-= 3;
                    }
                    updateSpeech();
                    storyTimer--;
                }
        }
        
        private function keyHandler(e:KeyboardEvent):void 
        {
            if (e.keyCode == 65||e.keyCode == 37) {//left
                speedMove=-10;
            }else if (e.keyCode == 68||e.keyCode == 39) {//right
                speedMove= 10;
            }
        }
        
        private function update(e:Event):void 
        {
            if (stressBar.y < 10) {
                stressBar.y+=2;
            }
            updateTables();
            
            //
            if(stressNum>0){
                switch(angryDudeState) {
                    case READY:
                        if (launchTimer == 0) {
                            angryDude.x = angryDudePosX;
                            launchTimer = staggerTime;
                        }else {
                            launchTimer--;
                            angryDude.x = angryDudePosX + (Math.random() - .5) * 2;
                        }
                        break;
                    case FULL:
                        if (throwTimer == 0) {
                            angryDudeText.text = NOTHROWSTATE;
                            angryDudeState = EMPTY;
                            angryDude.x = angryDudePosX;
                            throwTimer = throwTimerMax;
                        }else {
                            throwTimer--
                            angryDude.x = angryDudePosX + (Math.random() - .5) * 2;
                        }
                        break;
                    case EMPTY:
                        break;
                }
            }
            //
            chillDude.x += speedMove;
            if (chillDude.x < leftLimit) {
                chillDude.x = leftLimit;
            }else if (chillDude.x > rightLimit) {
                chillDude.x = rightLimit;
            }
            if (catchTimer == 0) {
                
            }else {
                catchTimer--;
                if (catchTimer == 0) {
                    chillDudeText.text = NOCATCHSTATE;
                }
            }
            speedMove *= .9;
            //
            updateParticles();
            updateSpeech();
            checkGameEnd();
        }
        
        private function checkGameEnd():void 
        {
            
            if (stressNum == 0) {
                if (storyTimer == 0) {
                    if (winStory.length == 0) {
                        removeGame();
                        initMenu();
                    }else {
                        updateText(winStory[0], winStory[1]);
                        winStory.splice(0, 2);
                        storyTimer = 100;
                    }
                }else {
                    storyTimer--;
                }
            }else if (Math.max(waveData.length,tableList.length) == 0) {
                    if (storyTimer == 0) {
                        if (loseStory.length == 0) {
                            removeGame();
                            initMenu();
                        }else {
                            updateText(loseStory[0], loseStory[1]);
                            loseStory.splice(0, 2);
                            storyTimer = 100;
                        }
                    }else {
                        storyTimer--;
                    }
            }else {
                
                if(waveData.length>0){
                    if (tableTimer == 0) {
                        createTable();
                        tableTimer = waveData[0];
                        waveData.splice(0, 1);
                        tableLeftText.text = "Table left: " + waveData.length;
                    }else {
                        tableTimer--;
                    }
                }
            }
        }
        private function stressBarUpdate(num:int = 0):void {
            stressNum = Math.max(0, stressNum - num);
            if (stressNum == 0) {
                angryDudeText.text = CHILLSTATE;
                chillDudeText.text = CATCHSTATE;
            }
            var le:Number=(stage.stageWidth-20)
            stressBar.graphics.clear();
            stressBar.graphics.beginFill(0xCCCCCC);
            stressBar.graphics.drawRect(10, 10, le * stressNum / stressMax, 15);
            stressBar.graphics.endFill();
            stressBar.graphics.lineStyle(1, 0);
            stressBar.graphics.drawRect(8, 8, le + 3, 18);
        }
        private function updateSpeech():void 
        {
            if (angryTextTimer == 0) {
            }else {
                angryTextTimer--;
                if (angryTextTimer == 0) {
                    angrySpeech.text = "";
                }
            }
            if (chillTextTimer == 0) {
            }else {
                chillTextTimer--;
                chillDudeSpeech.x = chillDude.x;
                if (chillTextTimer == 0) {
                    chillSpeech.text = "";
                }
            }
        }
        
        private function updateParticles():void 
        {
            for (var i:int = 0; i < tableParts.length; i++) {
                var part:Sprite = tableParts[i][0];
                var speedx:Number = tableParts[i][1];
                var speedy:Number = tableParts[i][2];
                var grav:Number = tableParts[i][3];
                part.x += speedx;
                part.y += grav - speedy;
                part.rotation+= speedx * 3;
                grav += .2
                if (part.y > ground+10) {
                    removeChild(part);
                    part = null;
                    tableParts[i][0] = null;
                    tableParts.splice(i, 1);
                }else {
                    tableParts[i]=[part, speedx, speedy, grav];
                }
            }
        }
        
        private function updateTables():void 
        {
            for (var i:int = 0; i < tableList.length; i++) {
                
                if (tableList[i][6]==true) {
                    removeChild(tableList[i][0]);
                    tableList[i][0] = null;
                    tableList.splice(i, 1);
                }else {
                    tableList[i] = updateTable(tableList[i]);
                }
            }
        }
        private function updateTable(data:Array):Array {
            var table:Sprite = data[0];
            var speedX:Number = data[1];
            var speedY:Number = data[2];
            var isLaunch:Boolean = data[3];
            var grav:Number = data[4];
            var isCatch:Boolean = data[5];
            var isDestroy:Boolean = data[6];
            var isSafe:Boolean = data[7];
            data[0] = null;
            data = null;
            if (isDestroy) {
            }else {
                if (isSafe) {
                    if (table.alpha <= 0) {
                        isDestroy = true;
                    }else {
                        table.alpha -= .04;
                    }
                }else{
                    grav = Math.min(15, grav + .23);
                    speedY = speedY*.9//+grav;
                    table.y += speedY+grav;
                    table.x += speedX;
                    if (isLaunch) {
                        if (table.y >= ground + 7) {
                            isDestroy = true;
                            tableDamageSound.play();
                            table.y = ground+7;
                            speedX = 0;
                            speedY = 0;
                            brokenParts(table.x, ground, true);
                            brokenParts(table.x,ground, false);
                            brokenParts(table.x, ground, false);
                        }else {
                            var dist:Number = Math.pow(table.x - chillDude.x-20, 2) + Math.pow(table.y - chillDude.y, 2);
                            if (dist<900) {
                                table.x = chillDude.x;
                                table.y = ground+7;
                                table.rotation = 0;
                                stressBarUpdate(10);
                                tableSafeSound.play();
                                updateText(chillWords[int(Math.random()*chillWords.length)], true);
                                chillDudeText.text = CATCHSTATE;
                                catchTimer = 40;
                                isSafe = true;
                            }else{
                                table.rotation += speedX * 2;
                            }
                        }
                    }else {
                        if (table.y >= ground - 70) {
                            if (launchTimer==0) {
                                speedX =2.6+Math.random()*4.8;
                                speedY=-30-Math.random()*40
                                angryDudeState = FULL;
                                angryDudeText.text = THROWSTATE;
                                tableThrowSound.play();
                                updateText(angryWords[int(angryWords.length*Math.random())], false);
                                launchTimer = 20;
                                isLaunch = true;
                            }else if(angryDudeState==EMPTY){
                                angryDudeState = READY;
                            }
                            table.y = ground-65;
                        }
                    }
                }
            }
            return [table, speedX, speedY, isLaunch,grav,isCatch,isDestroy,isSafe];
        }
        private function createTable():void {
            var table:Sprite = new Sprite();
            table.graphics.lineStyle(1);
            table.graphics.moveTo( -17, -3);
            table.graphics.lineTo( 17, -3);
            table.graphics.moveTo( -10, -3);
            table.graphics.lineTo( -10, 3);
            table.graphics.moveTo( 10, -3);
            table.graphics.lineTo( 10, 3);
            addChild(table);
            table.x = 65;
            table.y = 0;
            tableList.push([table,0,0,false,0,false,false,false]);
        }
        
    }

}