/**
 * Copyright geta ( http://wonderfl.net/user/geta )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/tcmH
 */

// forked from nacookan's 無名関数内のthisの話
// 普段はthisを書かない派ですが、Tweensyで自身をトゥイーンしたいとき等は仕方なくthisを書きます。
// でも、イベントハンドラとして渡した無名関数の中では、thisはglobalになってしまうので使えません。
// だからクロージャーでthisを無名関数内に持ち込むことにしました。
// ところが"this"は予約語なので、他の名前を付ける必要があります。今回は"self"としてみました。
// こんなやり方しかないのでしょうか？ もっといいやり方があれば教えてください。
// または、皆さんは普段どのように書いていますか？
// このやり方では、thisを書かなかったり、書いたり、selfと書いたり、一貫性が無いのが悩みです。
// コードの先頭で var self = this; と書いてあとはselfだけを使うという手もありますが。。。
// それか、最も内側でwithされてるインスタンスを取得する方法があればそれがベストかも知れません。
package {
    import flash.display.*;
    import flash.events.*;
    import flash.text.*;
    import com.flashdynamix.motion.*;
    import fl.motion.easing.*;
    
    public class ThisSelf extends Sprite {
        public function ThisSelf() {
            
            var t:TextField = new TextField();
            t.autoSize = TextFieldAutoSize.LEFT;
            t.text = '';
            addChild(t);
            
            // 普段、thisは書かない派でも、
            graphics.beginFill(0xff0000);
            graphics.drawRect(100, 100, 100, 100);
            graphics.endFill();
            
            // こういうときはthisを書くしかない(ですよね？違う？)。
            Tweensy.to(this, { x: 100 }, 2);
            
            // 当然ここのthisは、ちゃんと自身のインスタンスを示しています。
            t.appendText('normal\n');
            t.appendText('this : ' + this + '\n');
            t.appendText('\n');
            
            addEventListener(Event.ENTER_FRAME, (function(self:Object):Function{
                return function(e:Event):void{
                    removeEventListener(e.type, arguments.callee);
                    // しかし、無名関数内のthisはglobalになってしまいます。
                    // そこでクロージャーで外のthisを持ち込んで、その名前(self)でアクセスします。
                    t.appendText('in closure\n');
                    t.appendText('this : ' + this + '\n');
                    t.appendText('self : ' + self + '\n');
                    Tweensy.to(self, { x: 0 }, 2, null, 10);
                    
                    //Tweensy.to(this, { x: 0 }, 2, null, 2); // thisはダメ
                    //Tweensy.to(????, { x: 0 }, 2, null, 2); // withされてるインスタンスを取得する方法がある？
                }
            })(this));
        }
    }
}