/**
 * Copyright 9balls ( http://wonderfl.net/user/9balls )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/tauO
 */

package {
    import flash.system.*;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.SecurityErrorEvent;
    import flash.net.URLLoader;
    import flash.net.URLLoaderDataFormat;
    import flash.net.URLRequest;
    import flash.system.ApplicationDomain;
    import flash.text.TextField;

    /**
     * ...
     * @author
     */
    public class Main extends Sprite {

        public function Main():void {
            var loader:URLLoader = new URLLoader();
            loader.dataFormat = URLLoaderDataFormat.TEXT;
            loader.addEventListener(Event.COMPLETE, onLoad);
            loader.addEventListener(SecurityErrorEvent.SECURITY_ERROR, onError);
            Security.loadPolicyFile("http://max.adobe.com/crossdomain.xml");
            Security.loadPolicyFile("http://max.adobe.com/api/crossdomain.xml");
            Security.loadPolicyFile("http://max.adobe.com/api/events/crossdomain.xml");
            Security.loadPolicyFile("http://max.adobe.com/api/events/adobemax2011/crossdomain.xml");
            loader.load(new URLRequest("http://max.adobe.com/api/events/adobemax2011/sessions.json"));
        }

        private function onError(e:SecurityErrorEvent):void {
            var tf:TextField = new TextField();
            addChild(tf);
            tf.text = "error";
        }

        private function onLoad(e:Event):void {
            var json:Object = ApplicationDomain.currentDomain.getDefinition('JSON').parse((e.currentTarget as URLLoader).data);
            var length:int = json.length;
            var str:String = "";
            for (var i:int = 0; i < length; i++){
                var att:Object = json[i]["attachments"];
                var attLength:uint = att.length;
                for (var j:int = 0; j < attLength; j++){
                    str += json[i]["name"] + " : <font color=\"#0000ff\"><a href=\"" + att[j]["url"] + "\">" + att[j]["filename"] + "</a></font> (" + att[j]["url"] + ")" + "\n";
                }
            }
            //
            var text:TextField = new TextField();
            addChild(text);
            text.width = 465;
            text.height = 465;
            text.htmlText = str;
        }

    }

}