/**
 * Copyright zahir ( http://wonderfl.net/user/zahir )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/taoH
 */

package{
	// TextEvent.Linkを使ってみた。
	
	import flash.display.Graphics;
	import flash.display.Sprite;
	import flash.events.TextEvent;
	import flash.text.TextField;
	
	[SWF(width=465, height=465, backgroundColor=0xFFFFFF)]

	public class TextButton1 extends Sprite{
		
		public function TextButton1(){
			var g:Graphics = this.graphics;
			var w:int = this.stage.stageWidth;
			var h:int = this.stage.stageHeight;
			
			var red:String = font(0xFF0000, link( "0xFF0000", "赤" ) );
			var green:String = font(0x00FF00, link("0x00FF00", "緑") );
			var blue:String = font(0x00CCFF, link("0x0000FF", "青") ); //0000FFの原色だとつぶれちゃうので
			var undef:String = link("0xFFFFFF", "■");
			
			var tf:TextField = new TextField();
			this.addChildAt( tf, 0 );
			
			tf.background = true;
			tf.backgroundColor = 0x0;
			tf.textColor = 0xFFFFFF;
			tf.autoSize = "left";
			tf.htmlText = "      " + red + "     " + green + "     " + blue + "     " + undef + "      ";
			tf.x = (w - tf.width) >> 1;
			tf.y = (h - tf.height) >> 1;
			
			tf.addEventListener(TextEvent.LINK,function(e:TextEvent):void{
				g.clear();
				g.beginFill( Number(e.text) );
				g.drawRect( 0, 0, w, h );
				g.endFill();
			});
		}
		private function link( eventText:String, text:String ):String{
			return "<u><a href=\"event:"+ eventText + "\">"+ text + "</a></u>";
		}
		private function font( color:uint, text:String):String{
			return "<font color=\"#" + color.toString(16) + "\">" + text + "</font>";
		}
	}
}