/**
 * Copyright aruerula ( http://wonderfl.net/user/aruerula )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/tZwN
 */

// forked from ProjectNya's HeartButton
// forked from Event's Button
////////////////////////////////////////////////////////////////////////////////
// HeartButton
//
// 音はTsabeat より拝借
// http://www.ektoplazm.com/free-music/tsabeat-warp-speed-ep/
////////////////////////////////////////////////////////////////////////////////

package {

    import flash.display.Sprite;
    import flash.display.Shape;
    import flash.geom.Rectangle;
    import flash.events.Event;
    import flash.events.MouseEvent;

    [SWF(backgroundColor="#cccccc, width="465", height="465", frameRate="30")]

    public class Main extends Sprite {
        private var playBtn:Btn;
        private var light:LightHeart;
        private var playing:Boolean = true;

        public function Main() {
            init();
        }

        private function init():void {
            graphics.beginFill(0x000000);
            graphics.drawRect(0, 0, 465, 465);
            graphics.endFill();
            var rect:Rectangle = new Rectangle(0, 0, 465, 465);
            light = new LightHeart(rect);
            addChild(light);
            light.addEventListener(Event.COMPLETE, complete, false, 0, true);
            //light.start();
            playBtn = new Btn();
            playBtn.x = 232;
            playBtn.y = 232;
            playBtn.buttonMode = true;
            playBtn.addEventListener(MouseEvent.CLICK, click, false, 0, true);
        }
        private function complete(evt:Event):void {
            addChild(playBtn);
            playBtn.start();
        }
        private function click(evt:MouseEvent):void {
            playBtn.stop();
            playBtn.removeEventListener(MouseEvent.CLICK, click);
            removeChild(playBtn);
            light.start();
        }

    }

}


import flash.display.Sprite;
import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.geom.Matrix;
import flash.filters.BlurFilter;
import flash.geom.Rectangle;
import flash.geom.Point;
import flash.events.Event;
//ColorTransform
import flash.geom.ColorTransform;
import flash.media.Sound;
import flash.media.SoundChannel;
import flash.media.SoundLoaderContext;
import flash.media.SoundMixer;
import flash.utils.ByteArray;
import flash.net.URLRequest;
import flash.system.Security;

class LightHeart extends Sprite {
    private var rect:Rectangle;
    private var canvas:BitmapData;
    private var bitmapData:BitmapData;
    private static var scale:Number = 1.25;
    private var matrix:Matrix;
    private var blur:BlurFilter;
    private static var point:Point = new Point();
    private var light:EmitLight;
    //ColorTransform
    private var colorTrans:ColorTransform;
    private static var policyPath:String = "http://mutast.heteml.jp/crossdomain.xml";
    private var sound:Sound;
    private var channel:SoundChannel;
    private static var soundPath:String = "http://mutast.heteml.jp/works/music/music.mp3";
    private var byteArray:ByteArray;
    private static var channels:uint = 256;
    private var factors:uint = 0;

    public function LightHeart(r:Rectangle) {
        rect = r;
        init();
    }

    private function init():void {
        canvas = new BitmapData(rect.width, rect.height, true, 0xFF000000);
        addChild(new Bitmap(canvas));
        bitmapData = new BitmapData(rect.width, rect.height, false, 0xFF000000);
        matrix = new Matrix();
        matrix.scale(scale, scale);
        var w:int = (rect.width - rect.width*scale)*0.5;
        var h:int = (rect.height - rect.height*scale)*0.5;
        matrix.translate(w, h);
        blur = new BlurFilter(1, 1, 3);
        light = new EmitLight();
        addChild(light);
        light.initialize(40);
        light.x = rect.width*0.5;
        light.y = rect.height*0.5;
        //ColorTransform
        colorTrans = new ColorTransform(0.96, 0.96, 0.96, 1, 0, 0, 0, 0);
        //
        Security.loadPolicyFile(policyPath);
        sound = new Sound();
        sound.addEventListener(Event.COMPLETE, complete, false, 0, true);
        sound.load(new URLRequest(soundPath), new SoundLoaderContext(10, true));
        byteArray = new ByteArray();
    }
    private function complete(evt:Event):void {
        evt.target.removeEventListener(Event.COMPLETE, complete);
        //start();
        dispatchEvent(evt);
    }
    public function start():void {
        channel = sound.play(0, 1000);
        addEventListener(Event.ENTER_FRAME, update, false, 0, true);
    }
    private function update(evt:Event):void {
        SoundMixer.computeSpectrum(byteArray, true, factors);
        var data:Array = new Array();
        for (var n:uint = 0; n < channels; n++) {
            var p:Number = byteArray.readFloat();
                data.push(p);
        }
        draw(data);
    }
    private function draw(data:Array):void {
        light.create(data);
        bitmapData.lock();
        bitmapData.draw(this);
        bitmapData.applyFilter(bitmapData, rect, point, blur);
        bitmapData.unlock();
        canvas.lock();
        //ColorTransform
        canvas.draw(bitmapData, matrix, colorTrans, null, rect, true);
        canvas.unlock();
        light.emit();
    }

}


import flash.display.Sprite;
import flash.geom.Rectangle;
import flash.display.BlendMode;
import frocessing.color.ColorHSV;

class EmitLight extends Sprite {
    private var radius:uint;
    private var circles:Array;
    private static var deceleration:Number = 0.9;
    private var id:uint;
    private var color:ColorHSV;

    public function EmitLight() {
        init();
    }

    private function init():void {
        circles = new Array();
        color = new ColorHSV(335, 1, 1);
    }
    public function initialize(r:uint):void {
        radius = r;
    }
    public function create(data:Array):void {
        id ++;
        var angle:uint = id*3%360;
        color.s = Math.cos(angle*Math.PI/180)*0.4 + 0.6;
        var circle:Heart = new Heart(color.value);
        addChild(circle);
        circle.x = Math.cos(-angle*Math.PI/180)*radius;
        circle.y = Math.sin(-angle*Math.PI/180)*radius;
        circle.vx = (Math.random()*2 - 1)*20;
        circle.vy = (Math.random()*2 - 1)*20;
        //circle.scale = Math.random()*0.75 + 0.25;
        circle.scale = data[1];
        circle.blendMode = BlendMode.HARDLIGHT;
        circles.push(circle);
    }
    public function emit():void {
        for (var n:uint = 0; n < circles.length; n++) {
            var circle:Heart = circles[n];
            circle.vx *= deceleration;
            circle.vy *= deceleration;
            circle.x += circle.vx;
            circle.y += circle.vy;
            circle.scale *= deceleration;
            if (circle.scale < 0.1) {
                circles.splice(n, 1);
                removeChild(circle);
                circle = null;
            }
        }
    }

}


import flash.display.Shape;
import flash.display.LineScaleMode;
import flash.display.CapsStyle;
import flash.display.JointStyle;

class Heart extends Shape {
    private var rgb:uint = 0xFFFFFF;
    private var _scale:Number = 1;
    public var vx:Number = 0;
    public var vy:Number = 0;

    public function Heart(c:uint = 0xFFFFFF) {
        rgb = c;
        draw();
    }

    private function draw():void {
        graphics.clear();
        graphics.lineStyle(30, rgb, 1 , false, LineScaleMode.NORMAL, CapsStyle.ROUND, JointStyle.MITER);
        graphics.moveTo(-20, -15);
        graphics.lineTo(0, 5);
        graphics.lineTo(20, -15);
    }
    public function get scale():Number {
        return _scale;
    }
    public function set scale(param:Number):void {
        _scale = param;
        scaleX = scaleY = _scale;
    }

}


import flash.display.Sprite;
import flash.events.Event;

class Btn extends Sprite {
    private var heart:Heart;
    private static var baseScale:Number = 0.4;
    private static var targetScale:Number = 0.7;
    private var scale:Number = baseScale;
    private var amplitude:Number = 0;
    private static var deceleration:Number = 0.85;
    private static var friction:Number = 0.8;
    private static var acceleration:Number = 0.4;

    public function Btn() {
        draw();
    }

    private function draw():void {
        heart = new Heart(0xFF6699);
        addChild(heart);
    }
    public function start():void {
        addEventListener(Event.ENTER_FRAME, elastic, false, 0, true);
    }
    public function stop():void {
        removeEventListener(Event.ENTER_FRAME, elastic);
        removeEventListener(Event.ENTER_FRAME, slide);
    }
    private function elastic(evt:Event):void {
        amplitude += targetScale - scale;
        scale += amplitude*friction;
        amplitude *= deceleration;
        heart.scaleX = heart.scaleY = scale;
        if (Math.abs(targetScale - scale) < 0.005 && Math.abs(amplitude) < 0.001) {
            removeEventListener(Event.ENTER_FRAME, elastic);
            amplitude = 0;
            scale = targetScale;
            heart.scaleX = heart.scaleY = targetScale;
            addEventListener(Event.ENTER_FRAME, slide, false, 0, true);
        }
    }
    private function slide(evt:Event):void {
        scale += (baseScale - scale)*acceleration;
        heart.scaleX = heart.scaleY = scale;
        if (Math.abs(baseScale - scale) < 0.005) {
            removeEventListener(Event.ENTER_FRAME, slide);
            scale = baseScale;
            heart.scaleX = heart.scaleY = baseScale;
            addEventListener(Event.ENTER_FRAME, elastic, false, 0, true);
        }
    }

}