/**
 * Copyright hacker_szoe51ih ( http://wonderfl.net/user/hacker_szoe51ih )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/tZtf
 */

package {
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;

    public class Main extends Sprite {

        private var ballNum:int = 10;
        private var ballsArr:Array;
        private var ball0Dragging:Boolean = false;
        private var ball1Dragging:Boolean = false;
        private var ball2Dragging:Boolean = false;
        private var ball3Dragging:Boolean = false;
        private var ball4Dragging:Boolean = false;
        private var ball5Dragging:Boolean = false;
        private var ball6Dragging:Boolean = false;
        private var ball7Dragging:Boolean = false;
        private var ball8Dragging:Boolean = false;
        private var ball9Dragging:Boolean = false;
        private var spring:Number = 0.03;
        private var gravity:Number = 0.08;
        private var friction:Number = 0.7;
        private var springLength:Number = 100;
        private var bounce:Number = -0.7;
        private var left:Number = 0;
        private var top:Number = 0;
        private var right:Number = stage.stageWidth;
        private var bottom:Number = stage.stageHeight;

        public function Main() {
            init();
        }

        private function init():void {
            ballsArr=new Array();
            for (var i:int=0; i<ballNum; i++) {
                var b:Ball = new Ball(10,Math.random() * 0xffffff);
           
                b.x = Math.random() * stage.stageWidth;
                b.y = Math.random() * stage.stageHeight;
                b.addEventListener(MouseEvent.MOUSE_DOWN, downHandler);
                addChild(b);
                ballsArr.push(b);
            }
            addEventListener(Event.ENTER_FRAME, onEnterFrame);
            stage.addEventListener(MouseEvent.MOUSE_UP, upHandler);
        }


        private function onEnterFrame(event:Event):void {
            var i:int = 0;
            if (! ball0Dragging) {
                i = 0;
                for (i; i<ballNum; i++) {
                    if (i != 0) {
                        springTo(ballsArr[0], ballsArr[i]);
                    }
                }
            }
            if (! ball1Dragging) {
                i = 0;
                for (i; i<ballNum; i++) {
                    if (i != 1) {
                        springTo(ballsArr[1], ballsArr[i]);
                    }
                }
            }
            if (! ball2Dragging) {
                i = 0;
                for (i; i<ballNum; i++) {
                    if (i != 2) {
                        springTo(ballsArr[2], ballsArr[i]);
                    }
                }
            }
            if (! ball3Dragging) {
                i = 0;
                for (i; i<ballNum; i++) {
                    if (i != 3) {
                        springTo(ballsArr[3], ballsArr[i]);
                    }
                }
            }
            if (! ball4Dragging) {
                i = 0;
                for (i; i<ballNum; i++) {
                    if (i != 4) {
                        springTo(ballsArr[4], ballsArr[i]);
                    }
                }
            }
            if (! ball5Dragging) {
                i = 0;
                for (i; i<ballNum; i++) {
                    if (i != 5) {
                        springTo(ballsArr[5], ballsArr[i]);
                    }
                }
            }
            if (! ball6Dragging) {
                i = 0;
                for (i; i<ballNum; i++) {
                    if (i != 6) {
                        springTo(ballsArr[6], ballsArr[i]);
                    }
                }
            }
            if (! ball7Dragging) {
                i = 0;
                for (i; i<ballNum; i++) {
                    if (i != 7) {
                        springTo(ballsArr[7], ballsArr[i]);
                    }
                }
            }
            if (! ball8Dragging) {
                i = 0;
                for (i; i<ballNum; i++) {
                    if (i != 8) {
                        springTo(ballsArr[8], ballsArr[i]);
                    }
                }
            }
            if (! ball9Dragging) {
                i = 0;
                for (i; i<ballNum; i++) {
                    if (i != 9) {
                        springTo(ballsArr[9], ballsArr[i]);
                    }
                }
            }

            graphics.clear();
            graphics.lineStyle(1);
            graphics.moveTo(ballsArr[0].x, ballsArr[0].y);
            for (var j:int=1; j<ballNum; j++) {
                graphics.lineTo(ballsArr[j].x, ballsArr[j].y);
            }
            graphics.lineTo(ballsArr[0].x, ballsArr[0].y);

        }

        private function springTo(ballA:Ball, ballB:Ball):void {
            var dx:Number = 0;
            var dy:Number = 0;
            dx = ballB.x - ballA.x;
            dy = ballB.y - ballA.y;
            var angle:Number = Math.atan2(dy,dx);
            var targetX:Number = ballB.x - Math.cos(angle) * springLength;
            var targetY:Number = ballB.y - Math.sin(angle) * springLength;
            ballA.vx += (targetX - ballA.x) * spring;
            ballA.vy += (targetY - ballA.y) * spring;
            ballA.vx*=friction;
            ballA.vy*=friction;
            ballA.vy+=gravity;

            ballA.x+=ballA.vx;
            ballA.y+=ballA.vy;

            for (var i:int=0; i<ballNum-1; i++) {
                var ball0:Ball=ballsArr[i];
                for (var j:int=i+1; j<ballNum; j++) {
                    var ball1:Ball=ballsArr[j];
                    dx=ball1.x-ball0.x;
                    dy=ball1.y-ball0.y;
                    var dist:Number=Math.sqrt(dx*dx+dy*dy);
                    var minDist:Number=ball0.radius+ball1.radius;
                    if (dist<minDist) {
                        var tx:Number=ball0.x+(dx/dist*minDist);
                        var ty:Number=ball0.y+(dy/dist*minDist);
                        var ax:Number=(tx-ball0.x)*spring;
                        var ay:Number=(ty-ball0.y)*spring;
                        ball0.vx-=ax;
                        ball0.vy-=ay;
                        ball1.vx+=ax;
                        ball1.vy+=ay;
                    }
                }
            }

            if (ballA.x+ballA.radius>right) {
                ballA.x=right-ballA.radius;
                ballA.vx*=bounce;
            } else if (ballA.x - ballA.radius < left) {
                ballA.x=left+ballA.radius;
                ballA.vx*=bounce;
            }
            if (ballA.y+ballA.radius>bottom) {
                ballA.y=bottom-ballA.radius;
                ballA.vy*=bounce;
            } else if (ballA.y - ballA.radius < top) {
                ballA.y=top+ballA.radius;
                ballA.vy*=bounce;
            }

            if (ballB.x+ballB.radius>right) {
                ballB.x=right-ballB.radius;
                ballB.vx*=bounce;
            } else if (ballB.x - ballB.radius < left) {
                ballB.x=left+ballB.radius;
                ballB.vx*=bounce;
            }
            if (ballB.y+ballB.radius>bottom) {
                ballB.y=bottom-ballB.radius;
                ballB.vy*=bounce;
            } else if (ballB.y - ballB.radius < top) {
                ballB.y=top+ballB.radius;
                ballB.vy*=bounce;
            }


        }

        private function downHandler(event:MouseEvent):void {
            event.target.startDrag();
            if (event.target==ballsArr[0]) {
                ball0Dragging=true;
            }
            if (event.target==ballsArr[1]) {
                ball1Dragging=true;
            }
            if (event.target==ballsArr[2]) {
                ball2Dragging=true;
            }
            if (event.target==ballsArr[3]) {
                ball3Dragging=true;
            }
            if (event.target==ballsArr[4]) {
                ball4Dragging=true;
            }
            if (event.target==ballsArr[5]) {
                ball5Dragging=true;
            }
            if (event.target==ballsArr[6]) {
                ball6Dragging=true;
            }
            if (event.target==ballsArr[7]) {
                ball7Dragging=true;
            }
            if (event.target==ballsArr[8]) {
                ball8Dragging=true;
            }
            if (event.target==ballsArr[9]) {
                ball9Dragging=true;
            }
        }

        private function upHandler(event:MouseEvent):void {
            for (var i:int=0; i<ballNum; i++) {
                ballsArr[i].stopDrag();
            }
            ball0Dragging=false;
            ball1Dragging=false;
            ball2Dragging=false;
            ball3Dragging=false;
            ball4Dragging=false;
            ball5Dragging=false;
            ball6Dragging=false;
            ball7Dragging=false;
            ball8Dragging=false;
            ball9Dragging=false;
        }
    }
}



import flash.display.Sprite;

class Ball extends Sprite {
    public var radius:Number;
    public var color:uint;
    public var vx:Number=0;
    public var vy:Number=0;

    public function Ball(radius:Number=40, color:uint=0xff0000) {
        this.radius=radius;
        this.color=color;
        buttonMode=true;
        useHandCursor=true;
        init();
    }
    public function init():void {
        graphics.beginFill(color);
        graphics.drawCircle(0, 0, radius);
        graphics.endFill();
    }
}