/**
 * Copyright colbrand ( http://wonderfl.net/user/colbrand )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/tZib
 */

package
{
    import flash.display.*;
    import flash.events.*;
    import flash.geom.*;
    import flash.text.*;
    import flash.utils.*;
    
    public class Snakes extends MovieClip
    {
        public const ss:uint = 20;
        public var snakeParts:Array;
        public var fieldSprite:Sprite;
        public var nRow:uint = 12;
        public var nCol:uint = 16;
        public var gridColor:Array;
        public var snakeHead:Sprite;
        public var gameTimer:Timer;
        public var gameSpeed:int = 300;
        public var moveX:int = 1;
        public var moveY:int = 0;
        public var nextX:int;
        public var nextY:int;
        public var food:Sprite = new Sprite();
        public var foodX:uint;
        public var foodY:uint;
        public var snakeX:int;
        public var snakeY:int;
        public var delayMov:int = 5;
    
        
        
        
        public function Snakes()
        {
            snakeParts = new Array();
            generateField();
            generateHead();
            placeFood();
            
            stage.addEventListener(KeyboardEvent.KEY_DOWN, keyDown);
            gameTimer = new Timer(gameSpeed);
            gameTimer.addEventListener(TimerEvent.TIMER, moveSnake);
            gameTimer.start();
        
        }
        
        public function generateField()
        {
            gridColor = new Array("0x333333", "0x444444");
            fieldSprite = new Sprite();
            addChild(fieldSprite);
            fieldSprite.graphics.lineStyle(0,0x000000);
            for(var i:uint = 0; i < nRow; i++)
            {
                for (var j:uint = 0; j < nCol; j++)
                {
                    fieldSprite.graphics.beginFill(gridColor[(i%2+j%2)%2]);
                    fieldSprite.graphics.drawRect(ss*i, ss*j, ss, ss);
                    fieldSprite.graphics.endFill();
                }
            }     
        }
        
        public function generateHead()
        {
            snakeHead = new Sprite;
            snakeHead.graphics.lineStyle(0,0x000000);
            snakeHead.graphics.beginFill(0x3ADF00);
            snakeHead.graphics.drawRect(0, 0, ss, ss);
            snakeHead.graphics.endFill();
            snakeHead.x = ss*4;
            snakeHead.y = ss*6;
            snakeParts.push(snakeHead);
            addChild(snakeHead);
            newPart();
            snakeParts[1].x = ss*3;
            snakeParts[1].y = ss*6;
            newPart();
            snakeParts[2].x = ss*2;
            snakeParts[2].y = ss*6;
            
        }
        
        public function keyDown(event:KeyboardEvent)
        {
            if(event.keyCode == 39)
            {
                if(nextX != -1)
                {
                    moveX = 1;
                    moveY =0;
                }
            }
            else if(event.keyCode == 38)
            {
                if(nextY != 1)
                {
                    moveX = 0;
                    moveY =-1;
                }
            }
            else if(event.keyCode == 37)
            {
                if(nextX != 1)
                {
                    moveX = -1;
                    moveY = 0;
                }
            }
            else if(event.keyCode == 40)
            {
                if(nextY != -1)
                {
                    moveX = 0;
                    moveY = 1;
                }
            }
            
        }
        
        public function moveSnake(event:TimerEvent)
        {
            nextX = moveX;
            nextY = moveY;
            snakeX= snakeParts[0].x + nextX*ss;
            snakeY = snakeParts[0].y + nextY*ss;
            
        
            if((snakeX == food.x) && (snakeY == food.y))
            {
                newPart();
                removeChild(food);
                placeFood();
                gameTimer.delay -= delayMov;
                
            }
        
            placeEnd();
            snakeParts[0].x = snakeX;
            snakeParts[0].y = snakeY;
            
            addChild(snakeParts[0]);
            for(var i:int = snakeParts.length-1; i > 0; i--)
            {
                if((snakeParts[0].x == snakeParts[i].x) && (snakeParts[0].y == snakeParts[i].y))
                {
                    gameOver();
                }
            }
            if(snakeParts[0].x < 0 || snakeParts[0].x > 220 || snakeParts[0].y < 0 || snakeParts[0].y > 300)
            {
                removeChild(snakeParts[0]);
                gameOver();
            }
            
        }
        
        public function placeFood()
        {
            food = new Sprite();
            food.graphics.lineStyle(0, 0x000000);
            food.graphics.beginFill(0xFF0040);
            food.graphics.drawRect(0, 0, ss, ss);
            food.graphics.endFill();
            foodX = Math.floor(Math.random()*12);
            foodY = Math.floor(Math.random()*16);
            food.x = foodX*ss;
            food.y = foodY*ss;
            for(var i:int = 0; i < snakeParts.length; i++)
            {
                if((snakeParts[i].x == food.x) && (snakeParts[i].y == food.y))
                {
                    foodX = Math.floor(Math.random()*12);
                    foodY = Math.floor(Math.random()*16);
                    food.x = foodX*ss;
                    food.y = foodY*ss;
                }
            }
            addChild(food);
                
        }
        
        public function newPart()
        {
            var newPart:Sprite = new Sprite();
            newPart.graphics.lineStyle(0, 0x000000);
            newPart.graphics.beginFill(0x3ADF00);
            newPart.graphics.drawRect(0, 0, ss, ss);
            newPart.graphics.endFill();
            snakeParts.push(newPart);
            addChild(newPart);
        }
        
        public function placeEnd()
        {
            for(var i:int = snakeParts.length-1; i > 0; i--)
            {
                snakeParts[i].x = snakeParts[i-1].x;
                snakeParts[i].y = snakeParts[i-1].y;
            }
        }
        
        public function gameOver()
        {
            stage.removeEventListener(KeyboardEvent.KEY_DOWN, keyDown);
            gameTimer.stop();
        
        }    
    }
}
