/**
 * Copyright late4 ( http://wonderfl.net/user/late4 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/tZZo
 */

// forked from checkmate's adobe challenge 1
/**
 * 
 * "Use Flash Player 10 drawing API,
 *  specifically drawTriangles.
 *  My favorite part of the new capabilities
 *  is the ability to specify
 *  UVT texture mapping data."
 *                     by Justin Everett-Church
 *  
 * This code is a example of drawTriangle.
 */
package {
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Graphics;
    import flash.display.Loader;
    import flash.display.LoaderInfo;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.geom.Point;
    import flash.net.URLLoader;
    import flash.net.URLRequest;
    import flash.system.LoaderContext;
    import flash.system.Security;
    import fl.motion.easing.*;
    import flash.utils.setInterval;
    import flash.utils.clearInterval;
    
    import com.flashdynamix.motion.Tweensy;
    import com.flashdynamix.motion.TweensyTimeline;
    
    [SWF(width="465", height="465", backgroundColor="0x000000", frameRate="24")]
    public class DrawTriangleTest extends Sprite{
    
        private var bushUrl:String = "http://www.matzmtok.com/wonderfl/checkmate/bush.xml";
        private var obamaUrl:String = "http://www.matzmtok.com/wonderfl/checkmate/obama.xml";
        private var bushImgUrl:String = "http://www.matzmtok.com/wonderfl/checkmate/image/bush.png";
        private var obamaImgUrl:String = "http://www.matzmtok.com/wonderfl/checkmate/image/obama.png";
        private var bushBmpData:BitmapData;
        private var obamaBmpData:BitmapData;
        
        private var interval:int;
        private var chkFlag:uint;
        
        private var oScreen:Sprite;
        private var bScreen:Sprite;
        
        private var bVerD:Vector.<Number>;
        private var oVerD:Vector.<Number>;
        private var verD:Vector.<Number>;
        
        private var oIndD:Vector.<int>;
        private var bIndD:Vector.<int>;
        
        private var bUvtD:Vector.<Number>;
        private var oUvtD:Vector.<Number>;
        
        private var sw:Number = 465;
        private var sh:Number = 465;
        
        public function DrawTriangleTest() {
            
            addEventListener(Event.ADDED_TO_STAGE, addedToStageHandler);
        } 
        
        private function addedToStageHandler(e:Event):void 
        {
            
            trace('initialize');
                        Wonderfl.disable_capture();
                        Wonderfl.capture_delay( 3 );
            removeEventListener(Event.ADDED_TO_STAGE, addedToStageHandler);
            
            Security.loadPolicyFile("http://www.matzmtok.com/wonderfl/crossdomain.xml");
            
            addChild(oScreen = new Sprite());
            addChild(bScreen = new Sprite());
            
            interval = setInterval(waitInitialze, 500);
            
            var l1:URLLoader = new URLLoader();
            l1.load(new URLRequest(bushUrl));
            l1.addEventListener(Event.COMPLETE, bushLoadCompleteHandler);
            
            var l2:URLLoader = new URLLoader();
            l2.load(new URLRequest(obamaUrl));
            l2.addEventListener(Event.COMPLETE, obamaLoadCompleteHandler);
            
            var lc:LoaderContext = new LoaderContext(true);
            var l3:Loader = new Loader();
            l3.load(new URLRequest(bushImgUrl), lc);
            l3.contentLoaderInfo.addEventListener(Event.COMPLETE, bushImagLoadCompleteHandler);
            var l4:Loader = new Loader();
            l4.load(new URLRequest(obamaImgUrl), lc);
            l4.contentLoaderInfo.addEventListener(Event.COMPLETE, obamaImgLoadCompleteHandler);
        }
        
        private function obamaImgLoadCompleteHandler(e:Event):void 
        {
            trace('complete obama img');
            var l:LoaderInfo = e.target as LoaderInfo;
            var bmp:Bitmap;
            
            bmp = l.content as Bitmap;
            obamaBmpData = new BitmapData(bmp.width, bmp.height, true);
            obamaBmpData.draw(bmp);
            
            chkFlag |= 0x01;
        }
        
        private function bushImagLoadCompleteHandler(e:Event):void 
        {
            trace('complete bush img');
            var l:LoaderInfo = e.target as  LoaderInfo;
            var bmp:Bitmap;
            
            bmp = l.content as Bitmap;
            bushBmpData = new BitmapData(bmp.width, bmp.height, true);
            bushBmpData.draw(bmp);
            chkFlag |= 0x02;
        }
        
        private function obamaLoadCompleteHandler(e:Event):void 
        {
            trace('complete obma xml');
            var l:URLLoader = e.target as URLLoader;
            var xml:XML = new XML(l.data);
            var pts:Array = [];
            var _x:Number, _y:Number;
            var xl:XMLList = xml.points.point;
            oVerD = new Vector.<Number>();
            oUvtD = new Vector.<Number>();
            for each(var p:XML in xl) {
                _x = Number(p.@x);
                _y = Number(p.@y);
                oVerD.push(_x, _y);
                oUvtD.push(_x / sw, _y / sh);
            }
            
            oIndD = new Vector.<int>();
            xl = xml.triangles.triangle;
            var i:int;
            for each(var t:XML in xl) {
                i = int(t.@pid0);
                oIndD.push(i);
                i = int(t.@pid1);
                oIndD.push(i);
                i = int(t.@pid2);
                oIndD.push(i);
            }
            chkFlag |= 0x04;
        }
        
        private function bushLoadCompleteHandler(e:Event):void 
        {
            trace('complete bush xml');
            var l:URLLoader = e.target as URLLoader;
            var xml:XML = new XML(l.data);
            var pts:Array = [];
            var _x:Number, _y:Number;
            var xl:XMLList = xml.points.point;
            bVerD = new Vector.<Number>();
            bUvtD = new Vector.<Number>();
            for each(var p:XML in xl) {
                _x = Number(p.@x);
                _y = Number(p.@y);
                bVerD.push(_x, _y);
                bUvtD.push(_x / sw, _y / sh);
            }
            
            bIndD = new Vector.<int>();
            xl = xml.triangles.triangle;
            var i:int;
            for each(var t:XML in xl) {
                i = int(t.@pid0);
                bIndD.push(i);
                i = int(t.@pid1);
                bIndD.push(i);
                i = int(t.@pid2);
                bIndD.push(i);
            }
            chkFlag |= 0x08;            
        }
        
        private function waitInitialze():void {
            if (chkFlag == 0x0F) {
                clearInterval(interval);
                
                verD = new Vector.<Number>(oVerD.length,false);
                                
                oScreen.alpha = 0.0;
                bScreen.alpha = 1;
                var tl:TweensyTimeline = Tweensy.to(bScreen, { alpha:0.0 }, 2, Linear.easeNone);
                tl.onUpdateParams = [tl];
                tl.onUpdate = update;
                tl.repeatType = TweensyTimeline.LOOP;
            }
        }
        private function update(timeline:TweensyTimeline):void {
            oScreen.alpha = 1 - bScreen.alpha;
            var g:Graphics;
            g = bScreen.graphics;
            
            for (var i:int = 0; i < oVerD.length; i++) {
                verD[i] = bVerD[i] + (oVerD[i] - bVerD[i]) * oScreen.alpha;
            }
            
            //bush
            g.clear();
            g.beginBitmapFill(bushBmpData);
            g.drawTriangles(verD, oIndD, bUvtD);
            g.endFill();
            //obama
            g = oScreen.graphics;
            g.clear();
            g.beginBitmapFill(obamaBmpData);
            g.drawTriangles(verD, oIndD, oUvtD);
            g.endFill();
        }
    }
}