/**
 * Copyright hemingway ( http://wonderfl.net/user/hemingway )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/tZZT
 */

package
{
    import flash.display.*;
    import flash.events.*;
    import flash.geom.*;
    
    [SWF(frameRate = 60, width = 465, height = 465)]
    public class Main extends Sprite
    {
        public function Main()
        {
            stage.scaleMode = StageScaleMode.NO_SCALE;
            
            addEventListener(Event.ADDED_TO_STAGE, addedToStage);
        }
        
        public function _init() :void
        {
            addChild(new Cube(182.5, 182.5, 100, 100, 100));
            
            graphics.clear     ();
            graphics.lineStyle (1, 0, 0.75);
            graphics.drawRect  (0, 0, 464, 464);
        }
        
        public function addedToStage($e:Event) :void
        {
            removeEventListener(Event.ADDED_TO_STAGE, addedToStage);
            
            _init();
        }
    }
}

import flash.display.*;
import flash.events.*;
import flash.geom.*;

class Cube extends Sprite
{
    internal var faceTop :Sprite = new Sprite();
    internal var faceLeft :Sprite = new Sprite();
    internal var faceFront :Sprite = new Sprite();
    
    internal var _x:Number;
    internal var _y:Number;
    internal var _w:Number;
    internal var _h:Number;
    internal var _d:Number;
    
    internal var oldPt :Point = new Point();
    internal var newPt :Point = new Point();
    internal var clcPt :Point = new Point();
    
    internal var bDrag :Boolean = false;
    
    public function Cube($x:Number = 232.5, $y:Number = 232.5, $w:Number = 16, $h:Number = 16, $d:Number = 16)
    {
        addEventListener(Event.ADDED_TO_STAGE, addedToStage);
        
        _x = $x;
        _y = $y;
        _w = $w;
        _h = $h;
        _d = ($d / 2);
    }
    
    public function _init() :void
    {
        graphics.clear ();
        graphics.lineStyle (1, 0, 0.75);
        
        /*
        *    6 ----- 1
        *    |\       \
        *    | \       \
        *    5  7 ----- 8
        *     \ |       |
        *      \| (9)   |
        *       4 ----- 3
        */
        
        graphics.moveTo(x, y);                 // -
        graphics.lineTo(x + w, y);             // 1
        graphics.lineTo(x + w + d, y + d);     // 2
        graphics.lineTo(x + w + d, y + h + d); // 3
        graphics.lineTo(x + d, y + h + d);     // 4
        graphics.lineTo(x, y + h);             // 5
        graphics.lineTo(x, y);                 // 6
        graphics.lineTo(x + d, y + d);         // 7 
        graphics.lineTo(x + d + w, y + d);     // 8
        graphics.moveTo(x + d, y + d);         // -
        graphics.lineTo(x + d, y + d + h);     // 9
        
        //top
        faceTop.graphics.clear ();
        faceTop.graphics.beginFill (0, 0.25);
        faceTop.graphics.moveTo(x, y);
        faceTop.graphics.lineTo(x + w, y);
        faceTop.graphics.lineTo(x + w + d, y + d);
        faceTop.graphics.lineTo(x + d, y + d);
        faceTop.graphics.lineTo(x, y);
        faceTop.graphics.endFill ();
        
        //left
        faceLeft.graphics.clear ();
        faceLeft.graphics.beginFill (0, 0.25);
        faceLeft.graphics.moveTo(x, y);
        faceLeft.graphics.lineTo(x, y + h);
        faceLeft.graphics.lineTo(x + d, y + h + d);
        faceLeft.graphics.lineTo(x + d, y + d);
        faceLeft.graphics.lineTo(x, y);
        faceLeft.graphics.endFill ();
        
        //front
        faceFront.graphics.clear ();
        faceFront.graphics.beginFill (0, 0.25);
        faceFront.graphics.moveTo(x + d, y + d);
        faceFront.graphics.lineTo(x + d + w, y + d);
        faceFront.graphics.lineTo(x + d + w, y + d + h);
        faceFront.graphics.lineTo(x + d, y + d + h);
        faceFront.graphics.lineTo(x + d, y + d);
        faceFront.graphics.endFill ();
    }
    
    public function addedToStage($e:Event) :void
    {
        removeEventListener(Event.ADDED_TO_STAGE, addedToStage);
        
        addChild(faceTop);
        addChild(faceLeft);
        addChild(faceFront);
        
        addEventListener(MouseEvent.MOUSE_DOWN, onMouseDown);    
        addEventListener(MouseEvent.MOUSE_OVER, onMouseOver);
        
        _init();
    }
    
    internal var $target:Object;
    
    public function onMouseOver($e:MouseEvent) :void
    {
        addEventListener(MouseEvent.MOUSE_OUT, onMouseOut);
        
        if  ($e.target == faceTop, faceLeft, faceFront && !(bDrag))
            {$e.target.alpha = 0.5;}
    }
    
    public function onMouseOut($e:MouseEvent) :void
    {
        if  ($e.target == faceTop, faceLeft, faceFront && !(bDrag))
            {$e.target.alpha = 1;}
    }
    
    public function onMouseDown($e:MouseEvent) :void
    {
        $target = $e.target;
        
        bDrag = true;
        
        oldPt = new Point($e.stageX, $e.stageY);
        
        if  ($target == faceTop, faceLeft, faceFront)
            {stage.addEventListener(MouseEvent.MOUSE_MOVE, onMouseMove); stage.addEventListener(MouseEvent.MOUSE_UP, onMouseUp); }
    }
    
    public function onMouseMove($e:MouseEvent) :void
    {
        newPt = new Point($e.stageX, $e.stageY);
        clcPt = Point(newPt.subtract(oldPt));
        
        switch ($target)
        {
            case (faceTop):
                if  ((h - clcPt.y) > 10)
                    { h -= clcPt.y; y += clcPt.y;}
            break;
            
            case (faceLeft):
                if  ((w - clcPt.x) > 10)
                    { w -= clcPt.x; x += clcPt.x;}
            break;
            
            case (faceFront):
                if  ((d + clcPt.y) > 5)
                    { d += clcPt.y;}
            break;
        }
        
        oldPt = newPt;
    }
    
    public function onMouseUp($e:MouseEvent) :void
    {
        stage.removeEventListener(MouseEvent.MOUSE_UP, onMouseUp);
        stage.removeEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);
        
        bDrag = false;
        $target.alpha = 1;
    }
    
    public override function get x() :Number
    { return _x }
    public override function get y() :Number
    { return _y }
    public function get w() :Number
    { return _w }
    public function get h() :Number
    { return _h }
    public function get d() :Number
    { return _d }
    public override function set x($value:Number) :void
    { _x = $value; _init(); }
    public override function set y($value:Number) :void
    { _y = $value; _init(); }
    public function set w($value:Number) :void
    { _w = $value; _init(); }
    public function set h($value:Number) :void
    { _h = $value; _init(); }
    public function set d($value:Number) :void
    { _d = $value; _init(); }
}
