/**
 * Copyright aobyrne ( http://wonderfl.net/user/aobyrne )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/tZDr
 */

// forked from yonatan's Depth-aware Lines3D
package {
    import com.bit101.components.CheckBox;
    import com.bit101.components.HBox;
    import com.bit101.components.Label;
    import com.bit101.components.VBox;
    import org.papervision3d.view.BasicView;
    import org.papervision3d.core.geom.Lines3D;
    import org.papervision3d.materials.special.LineMaterial;
    import flash.events.*;
    import flash.utils.*;

    public class BetterLines3DClient extends BasicView {
        private var lines:Lines3D;
        private var lineMat:LineMaterial;
        private var better:String;

        public function BetterLines3DClient() {
            better = 'better';
            lineMat = new LineMaterial(0);
            lines = new BetterLines3D(lineMat);
            
            scene.addChild(lines);
            createCube();
            startRendering();
            var vbox:HBox = new HBox(this, 0, 0);
            new CheckBox(vbox, 0, 0, better, typeOfCube).selected=true;
        }
        
        private function typeOfCube(e:Event):void 
        {
            scene.removeChild(lines);
            var checkBox:CheckBox = e.target as CheckBox;
            if (!checkBox.selected) 
            {
                lines = new Lines3DBis(lineMat);
                checkBox.label = 'normal';
            }
            else
            {
                lines = new BetterLines3D(lineMat);
                checkBox.label = better;
            }
            scene.addChild(lines);
            createCube();
        }

        override protected function onRenderTick(e:Event = null):void {
            camera.x = 400 * Math.sin(getTimer()/1000);
            camera.z = 100 * Math.cos(getTimer()/1000);
            camera.y = 200 * Math.cos(getTimer()/2000);
            super.onRenderTick(e);
        }

        //        ____________   
        //       /|0        /|1  
        //      / |        / |   
        //     /__________/  |   
        //     |4 |       |5 |   
        //     |  |_______|__|   
        //     |  /2      |  /3  
        //     | /        | /    
        //     |/_________|/     
        //      6          7     
        private function createCube():void {
            var scale:Number = 100;
            var v:Array = 
            [
                0, 0, 0,
                1, 0, 0,
                0, 1, 0,
                1, 1, 0,
                0, 0, 1,
                1, 0, 1,
                0, 1, 1,
                1, 1, 1
            ].map(function(...a):*{return a[0]*scale-scale/2;});
            function l(v0:int, v1:int):void { lines.addNewLine(20, v[v0*3+0], v[v0*3+1], v[v0*3+2], v[v1*3+0], v[v1*3+1], v[v1*3+2]) }
            l(0,1); l(1,3); l(3,2); l(2,0);
            l(4,5); l(5,7); l(7,6); l(6,4);
            l(0,4); l(1,5); l(2,6); l(3,7);
        }
    }
}

import org.papervision3d.core.geom.renderables.Line3D;
import org.papervision3d.core.render.command.RenderLine;
import org.papervision3d.core.render.data.RenderSessionData;
import org.papervision3d.materials.special.LineMaterial;
import org.papervision3d.objects.DisplayObject3D;   
import org.papervision3d.core.geom.*;

// This class scales the lines' width relative to their (center) screen Z.
// This can make interconnect points bulge, but I think it's better than the
// lines becoming skinny when they're close to the camera.

class BetterLines3D extends Lines3D {
    public function BetterLines3D(material:LineMaterial = null, name:String=null) {
        super(material, name);
    }
    
    /**
    * Converts 3D vertices into 2D space, to prepare for rendering onto the stage.
    *
    * @param    parent              The parent DisplayObject3D
    * @param    renderSessionData   The renderSessionData object for this render cycle. 
    * 
    */      
    public override function project( parent :DisplayObject3D, renderSessionData:RenderSessionData ):Number
    {
        // This ugly hack is here because I can't do super.super.project(parent, renderSessionData)
        // and I don't want Lines3D::project to add any lines to the render list.
        var tmp:Array = lines;
        lines = [];
        super.project(parent, renderSessionData);
        lines = tmp;
        
        var line3D:Line3D;
        var screenZ:Number;
        var rc:RenderLine;
        
        for each(line3D in lines)
        {
            if(renderSessionData.viewPort.lineCuller.testLine(line3D))
            {
                rc = line3D.renderCommand;
                
                rc.renderer = line3D.material;
                
                screenZ += rc.screenZ = (line3D.v0.vertex3DInstance.z + line3D.v1.vertex3DInstance.z)/2;
                
                var fz:Number = (renderSessionData.camera.focus*renderSessionData.camera.zoom);
                rc.size = line3D.size * fz / (renderSessionData.camera.focus + rc.screenZ);

                rc.v0 = line3D.v0.vertex3DInstance;
                rc.v1 = line3D.v1.vertex3DInstance;
                
                renderSessionData.renderer.addToRenderList(rc);
            }
        }
        
        return screenZ/(lines.length+1);
    }
    
    override public function addNewLine(size:Number, x0:Number, y0:Number, z0:Number, x1:Number, y1:Number, z1:Number):Line3D 
    {
        //material.lineColor = 0xffffff * Math.random();
        material = new LineMaterial(0xffffff * Math.random());
        return super.addNewLine(size, x0, y0, z0, x1, y1, z1);
    }
    
    
}
class Lines3DBis extends Lines3D
{
    public function Lines3DBis(material:LineMaterial = null, name:String=null) {
        super(material, name);
    }
    override public function addNewLine(size:Number, x0:Number, y0:Number, z0:Number, x1:Number, y1:Number, z1:Number):Line3D 
    {
        //material.lineColor = 0xffffff * Math.random();
        material = new LineMaterial(0xffffff * Math.random());
        return super.addNewLine(size, x0, y0, z0, x1, y1, z1);
    }
    
}
