/**
 * Copyright cpu_t ( http://wonderfl.net/user/cpu_t )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/tYrJ
 */

// forked from cpu_t's EscapeTank
// forked from 9re's Wonderfl Tank Game Tank Sample 1
// このコードを新着タンク一覧http://flash-games.wonderfl.net/tank/list/new
// に表示させるにはinfinite-tank-entry
// というタグをつけてください
package 
{
	import flash.display.Graphics;
	import flash.display.Sprite;
	import flash.display.BitmapData;
	import flash.geom.ColorTransform;
	import flash.geom.Matrix;
	
	import net.wonderfl.game.infinity_tank.development.*;
	import net.wonderfl.math.*;
	import net.wonderfl.utils.SequentialLoader;
	/**
	 * @author 9re
	 */
	// クラス名は必ずTankにして、TankBaseクラスを拡張して下さい
	// http://flash-games.wonderfl.net/static/asdoc/net/wonderfl/game/infinity_tank/tank/TankBase.html
	public class Tank extends TankBase
	{
		private var _spTank:Sprite;
		private var _spBattery:Sprite;
		private var _ctfm:ColorTransform;
		private var _mat:Matrix = new Matrix(1, 0, 0, 1, 5, 15);
		
		public function Tank() 
		{
			// 弾のクラスのurlをセットしてください
			// 弾のドキュメントクラスはBulletRendererBaseクラスを拡張したBulletRendererクラスである必要があります
			// 弾の一覧は、http://flash-games.wonderfl.net/tank/list/bullets
			// にあります.
			// http://flash-games.wonderfl.net/static/asdoc/net/wonderfl/game/infinity_tank/development/BulletRendererBase.html
			_bulletRenderer = "http://swf.wonderfl.net/swf/usercode/0/04/046c/046cee45b4334c4f2dac8dfa7ec9ea2b2b2eb27d.swf";
			
			_spTank = new Sprite;
			_spBattery = new Sprite;
			
			initTankDraw();
			
			_ctfm = new ColorTransform(1, 1, 1, 0);
			
			super();
		}
		
		// ※タンクの動きのメイン関数
		// 5フレームに1度呼ばれるcallback
		// 現在のゲームの状態を見るには、_sceneオブジェクトのプロパティーを 調べます.
		// @see http://flash-games.wonderfl.net/static/asdoc/net/wonderfl/game/infinity_tank/development/BattleScene.html
		override public function action():int
		{
			
			
			///////////////////////////////////////////////////////////////////////////
			///////////////////////////////////////////////////////////////////////////
			//タンクの動きはCommandクラスにより操作します。以下Commandクラスのコマンド///////////////
			///////////////////////////////////////////////////////////////////////////
			///////////////////////////////////////////////////////////////////////////
			
			// Command.FIRE           弾を撃つ
			// Command.GUN_TURN_RIGHT 砲台を右旋回
			// Command.GUN_TURN_LEFT  砲台を左旋回
			// Command.TANK_MOVE_FORWARD  前進
			// Command.TANK_MOVE_BACKWARD  後進
			// TANK_TURN_LEFT　左に旋回
			// TANK_TURN_RIGHT　右に旋回
			
			// command.addCommand(Command.コマンド);//実行する動きに追加
			// return command.action;　この関数の最後で実行する
			
			// @see http://flash-games.wonderfl.net/static/asdoc/net/wonderfl/game/infinity_tank/development/Command.html
			
			
			var command:Command = new Command;
			
			
			// AI設定部分
			
			
			
			// command.actionがフラグとなっている
			return command.action;
		}
		
		
		///////////////////////////////////////////////////////////////////////////
		///////////////////////////////////////////////////////////////////////////
		//追加演出//////////////////////////////////////////////////////////////////
		///////////////////////////////////////////////////////////////////////////
		///////////////////////////////////////////////////////////////////////////
		
		// ※被弾時に演出を入れたい時に編集してください。
		// called when a bullet hits this tank
		override public function hit():void {
			// 被弾したときに呼ばれるcallbackです.
		}
		
		// ※発射時に演出を入れたい時に編集してください。
		// called when this tank fires
		override public function fire():void 
		{
			// 弾が発射される時に呼ばれるcallbackです.
		}
		
		///////////////////////////////////////////////////////////////////////////
		///////////////////////////////////////////////////////////////////////////
		//以下修正不要//////////////////////////////////////////////////////////////
		///////////////////////////////////////////////////////////////////////////
		///////////////////////////////////////////////////////////////////////////
		
		//_spTank, _spBatteryに描画
		private function initTankDraw():void
		{
			var g:Graphics;
			
			g = _spBattery.graphics;
			
			g.lineStyle(1, 0x000000, 1.0);
			g.beginFill(0x808080, 1.0);
			g.drawCircle(0, 0, 7.5);
			g.moveTo(0, 0);
			g.lineTo(20, 0);
			
			g = _spTank.graphics;
			
			g.lineStyle(1, 0x000000, 1.0);
			g.beginFill(0x808080, 1.0);
			g.drawRoundRect( -25, -15, 50, 30, 15, 15);
			g.beginFill(0xa0a0a0, 1.0);
			g.moveTo(15, -8);
			g.lineTo(23, 0);
			g.lineTo(15, 8);
			
			_spTank.addChild(_spBattery);
		}
		
		
		
		// ※タンクの向きを描画している関数。修正の必要はありません。
		// 毎フレームごとに呼ばれる描画callback
		// stageと同じ大きさのBitmapDataが渡されます.
		// 現在のゲームの状態を見るには、_sceneオブジェクトのプロパティーを
		// 調べます.
		// @see http://flash-games.wonderfl.net/static/asdoc/net/wonderfl/game/infinity_tank/development/BattleScene.html
		override public function draw(bitmapData:BitmapData):void
		{
			// 砲台の向きをセットします.
			// 砲台はタンクのSpriteの子供のスプライトです.
			_spBattery.rotation = _scene.myGunAngle * 180 / Math.PI;
			
			
			// 単位行列にセット
			_mat.identity();
			// タンクの傾きをセット
			_mat.rotate(_scene.myTankAngle);
			// タンクの位置に平行移動. タンクのグラフィックは中心座標となっています.
			_mat.translate(_scene.myTankPosition.x, _scene.myTankPosition.y);
			
			// 一度BitmapDataをクリア
			bitmapData.colorTransform(bitmapData.rect, _ctfm);
			// BitmapDataを描画
			bitmapData.draw(_spTank, _mat, null, null, null, true);
		}
		
	}
}