/**
 * Copyright Matt_Wakeling ( http://wonderfl.net/user/Matt_Wakeling )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/tX16
 */

package 
{
    // Import External Classes
    import flash.display.Shape;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import net.hires.debug.Stats;
    
    // Reconfigure Stage Properties
    [SWF(width='465',height='465',backgroundColor='#000000',frameRate='60')]
    
    /**
    * Name           : Main 
    * Coded By       : Matt Wakeling
    * Date           : 30th April 2012
    * Description    : Main Class for the Application.
    *                  Simple Cube - Experiment In 3D.
    *
    * @author Matt Wakeling
    */
    public class Main extends Sprite 
    {
        private var $cube:Sprite = new Sprite;
        private var $faces:Array = new Array (6);
        
        // Main Constructor
        public function Main()
        {
            // Constructor Code
            super();
            InitialiseMain();
        }

        // InitialiseMain Method
        private function InitialiseMain():void
        {
            if (stage)
                this.InitialiseStage();
            else addEventListener(Event.ADDED_TO_STAGE, this.InitialiseStage);
        }
        
        
        private function InitialiseStage(e:Event = null):void
        {
            removeEventListener(Event.ADDED_TO_STAGE, this.InitialiseStage);
                                                                   
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align     = StageAlign.TOP_LEFT;
            
            // Black Screen for Wonderfl Capture
            this.graphics.beginFill(0x000000,1);
            this.graphics.drawRect(0,0,stage.stageWidth,stage.stageHeight);
            this.graphics.endFill();  
            
            addChild(new Stats);
            
            drawCube((stage.stageWidth * 0.5), (stage.stageHeight * 0.5));
        }    

        
        // drawCube Method
        private function drawCube($x:uint,$y:uint):void
        {    
            var $shpFace1:Shape = rectFace(0xFFFFFF);
            $shpFace1.rotationY = 90;
            $shpFace1.x += 100;
            $cube.addChild($shpFace1);
            
            var $shpFace2:Shape = rectFace(0xDDDDDD);
            $shpFace2.rotationY = 90;
            $shpFace2.x -= 100;
            $cube.addChild($shpFace2);
            
            var $shpFace3:Shape = rectFace(0xBBBBBB);
            $shpFace3.rotationX = 90;
            $shpFace3.y += 100;
            $cube.addChild($shpFace3);
            
            var $shpFace4:Shape = rectFace(0x999999);
            $shpFace4.rotationX = 90;
            $shpFace4.y -= 100;
            $cube.addChild($shpFace4);
            
            var $shpFace5:Shape = rectFace(0x777777);
            $shpFace5.z += 100;
            $cube.addChild($shpFace5);
            
            var $shpFace6:Shape = rectFace(0x555555);
            $shpFace6.z -= 100;
            $cube.addChild($shpFace6);
                        
            $cube.x = $x;
            $cube.y = $y;
            
            addChild($cube);
        
            $faces[0] = [$shpFace1, $cube.getChildAt(0).z];
            $faces[1] = [$shpFace2, $cube.getChildAt(1).z];
            $faces[2] = [$shpFace3, $cube.getChildAt(2).z];
            $faces[3] = [$shpFace4, $cube.getChildAt(3).z];
            $faces[4] = [$shpFace5, $cube.getChildAt(4).z];
            $faces[5] = [$shpFace6, $cube.getChildAt(5).z];
            
            this.addEventListener(Event.ENTER_FRAME, FrameEvent);
        }

        // FrameEvent Method
        private function FrameEvent(e:Event):void
        {
            rotateThis();
        }
        
        private function rotateThis():void
        {
            $cube.rotationX = ($cube.rotationX + 1);
            $cube.rotationY = ($cube.rotationY + 1);
                    
            for (var $row:int = 0; $row < $faces.length; $row++ )
            {
                $faces[$row][1] =  $faces[$row][0].transform.getRelativeMatrix3D(root).position.z;
            }
            
            $faces.sortOn("1", Array.NUMERIC | Array.DESCENDING); 
            
            for ($row = 0; $row < $faces.length; $row++ )
            {
                $cube.setChildIndex($faces[$row][0],$row);
            } 
        }
        
        private function rectFace($rectColor:uint):Shape
        {
            var $shpFace:Shape = new Shape;
            $shpFace.graphics.beginFill($rectColor, 1);
            $shpFace.graphics.drawRect(-100, -100, 200, 200);
            $shpFace.graphics.endFill();
            
            return ($shpFace);
            
        }
        
    }
}