/**
 * Copyright damionfeller ( http://wonderfl.net/user/damionfeller )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/tWwi
 */

// forked from jamasian's Manipulating Pixels
/*
      _                           _             
     | |                         (_)            
     | | __ _ _ __ ___   __ _ ___ _  __ _ _ __  
 _   | |/ _` | '_ ` _ \ / _` / __| |/ _` | '_ \ 
| |__| | (_| | | | | | | (_| \__ \ | (_| | | | |
 \____/ \__,_|_| |_| |_|\__,_|___/_|\__,_|_| |_|

Copyright 2010, Kaiyi Chan
*/

package
{
    import flash.events.MouseEvent;
    import flash.text.TextField;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.events.Event;
    import flash.display.Sprite;

    import flash.geom.Point;
    import flash.geom.Rectangle;
    
    
    
[SWF(frameRate=60)]

public class pixel extends Sprite
{
    /*----------  VARIABLES  ----------*/
    public var bmd:BitmapData;
    public var bm:Bitmap;
    public var debug:TextField;
    
    public var getPixel:Array=new Array();
    public var COLOR:uint    =    0xBBBB00;
    
    /*---------- CONSTRUCTOR ----------*/
    public function pixel()
    {
        //create Bitmap
        bmd    =    new BitmapData(464, 464, false, 0x000000);
        bm     =    new Bitmap(bmd);
        
        addChild(bm);
        
        //create debug text
        debug              =    new TextField();
        debug.textColor    =    0xFFFFFF;
        debug.selectable   =    false;
        addChild(debug);
        
        //assign object to array
        for (var a:int = 0; a <= 1000; a++)
        {
            getPixel[a]    =    new Entity();
        }
        
        stage.addEventListener(Event.ENTER_FRAME, update);
        stage.addEventListener(MouseEvent.CLICK,  function():void { COLOR = Math.random()*0xFFFFFF; });
    }
    
    
    private function update(e:Event):void
    {
        bmd.fillRect(bmd.rect, 0x000000);
       
        for (var i:int = 0; i <= 1000; i++)
        {
            var x:int        =    mouseX - getPixel[i].X;
            var y:int        =    mouseY - getPixel[i].Y;
            var s:int        =    Math.sqrt( (x)^2 + (y)^2);
            
            getPixel[i].X    +=    _Random(x/0.5) + _Random(1);
            getPixel[i].Y    +=    _Random(y/0.5) + _Random(1);
            
            getPixel[i].Y = (getPixel[i].Y >= 460) ? 460 : (getPixel[i].Y < 5) ? 1 : getPixel[i].Y;
            getPixel[i].X = (getPixel[i].X >= 460) ? 460 : (getPixel[i].X < 5) ? 1 : getPixel[i].X;
            
            bmd.setPixel(getPixel[i].X, getPixel[i].Y, COLOR);
        }
        
        Debug("Coordinates: " + mouseX + ", " + mouseY + "\nx:" + x + "y:" + y + "\nRadius: " + s);
    }
    
    private function Debug(text:String, override:Boolean=true):void
    {
        if (override) { this.debug.text    =    text; }else{ this.debug.appendText(text); }

        this.debug.width   =    50 + (this.debug.text.length * 3);
        this.debug.height  =    50;
        this.debug.autoSize=    "Left";
    }
    
    private function _Random(_int:int=1):int { return Math.random()*_int - Math.random()*_int; }
}
}

dynamic class Entity
{
    public var X:int         =    Math.random()*464;
    public var Y:int         =    Math.random()*464;
    public var GRAVITY:int   =    1;
    
    public function Entity()
    {
        
    }
}
