/**
 * Copyright chimanaco ( http://wonderfl.net/user/chimanaco )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/tWjt
 */

/**
*  bitmapで塗りつぶし。クリックで再描画。
*  ▼自分用参考
*  http://livedocs.adobe.com/flash/9.0_jp/ActionScriptLangRefV3/flash/display/Graphics.html#beginBitmapFill()
*/
package 
{
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Sprite;
	import flash.events.MouseEvent;
	import flash.geom.Matrix;
	import flash.geom.Rectangle;
	
	[SWF(width = "465", height = "465", frameRate = "30", backgroundColor = "#000000")]
	public class Circle extends Sprite 
	{
		private var _num:int = 8;
		private var _centerX:Number = stage.stageWidth / 2;
		private var _centerY:Number = stage.stageHeight/ 2;
		private var _width:uint = 200;
		private var _color:int = 0xFFFFFFF
		
		public function Circle() {
			createCircle();
			stage.addEventListener(MouseEvent.CLICK, onClickHandler);
		}
		
		private function onClickHandler(e:MouseEvent):void {
			createCircle();
		}
		
		public function createCircle():void {
			var bmpd:BitmapData = new BitmapData(4,4);
			var rect:Rectangle = new Rectangle(0, 0, 4, 1);
			bmpd.fillRect(rect, 0xFFFF0098);
			var circle:Sprite;
			
			for (var i:int = 0; i < _num; i++ ) {
				var matrix:Matrix = new Matrix(); 
				matrix.rotate(Math.PI / Math.random() *30);
				circle = new Sprite();
				circle.graphics.lineStyle(1, _color, 1, false, "normal");
				circle.graphics.beginBitmapFill(bmpd, matrix, true, true);
				circle.graphics.drawCircle(_centerX, _centerY, _width -  (i * 30));
				circle.graphics.endFill();
				addChild(circle);
			}
		}
	}
}