/**
 * Copyright bigfish ( http://wonderfl.net/user/bigfish )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/tWgK
 */

package {

    import flash.display.Sprite;
	import flash.utils.getTimer;

    public class CircleDraw extends Sprite {
		
		private const NUM_POINTS:int = 60;
		private const RADIUS:Number = 100;
		private const TWOPI:Number = Math.PI*2;
		private var points:Vector.<Number> = new Vector.<Number>(NUM_POINTS*2);
		private var cmds:Vector.<int> = new Vector.<int>(NUM_POINTS+2);

        public function CircleDraw() {
            
			var start1:Number = getTimer();
			for(var c:int = 0; c < 1000; ++c)
			{
				trigDrawCircle();
				renderCircle();
			}
			var time1:Number = getTimer() - start1;
			trace(time1);
        }
		
		private function trigDrawCircle():void
		{
			cmds[0] = 1;
			var cx:Number = RADIUS + Math.random()*(stage.stageWidth - RADIUS*2);
			var cy:Number = RADIUS + Math.random()*(stage.stageHeight - RADIUS*2);

			for(var i:int = 0; i < NUM_POINTS*2; i+=2)
			{
				points[i] = cx + RADIUS*Math.cos(TWOPI*i/NUM_POINTS);
				points[i+1] = cy + RADIUS*Math.sin(TWOPI*i/NUM_POINTS);

				cmds[int(i*.5)] = i?2:1;
			}
			//cmds[NUM_POINTS+1] = 2;
		}

		private function renderCircle():void
		{
			graphics.lineStyle(0);
			graphics.drawPath(cmds, points);
		}

    }
}
