/**
 * Copyright hemingway ( http://wonderfl.net/user/hemingway )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/tUAH
 */

package {
    import flash.display.Sprite;
    import flash.display.Bitmap;
    import flash.display.BitmapData; 
    import flash.display.Loader;
    import flash.display.LoaderInfo;
    import flash.events.Event;
    import flash.net.URLRequest;
    
    public class FlashTest extends Sprite {
        private var _background:UIBackground;
        
        public function FlashTest() {
            this._background = new UIBackground("http://www.wallpaperup.com/uploads/wallpapers/2012/09/10/13699/6e07ade0cfe8ec9f84fd2d4b3fa7fe60.jpg");
            this.addChild(this._background);
        }
    }
}

import flash.display.Loader;
import flash.display.LoaderInfo;
import flash.events.Event;
import flash.net.URLRequest;
import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.events.ProgressEvent;
import flash.display.DisplayObjectContainer;

internal class UIBackground extends DisplayObjectContainer {
    private var _image:URLRequest;
    private var _loadingInfo:Loader;
    private var _loadingAnimation:Bitmap;
    
    public function UIBackground($image:String, $x:int = 0, $y:int = 0, $width:int = 465, $height:int = 465, $alpha:int = 1) {
        this._loadingInfo = new Loader();
        this.addChild(this._loadingInfo);
        this._loadingAnimation = new UIProgress($width, $height);
        this._image = new URLRequest($image);
        
        this.addEventListener(Event.ADDED_TO_STAGE, this.addedToStageHandler);
    }
    
    private function addedToStageHandler($event:Event) :void {
        this.removeEventListener(Event.ADDED_TO_STAGE, this.addedToStageHandler);
        
        this._loadingInfo.contentLoaderInfo.addEventListener(Event.COMPLETE, this.contentCompleteHandler);
        this._loadingInfo.contentLoaderInfo.addEventListener(ProgressEvent.PROGRESS, this.contentProgressHandler);
        
        this._loadingInfo.load(this._image);
    }
    
    private function contentProgressHandler($event:ProgressEvent) :void {
        var $progress:Number = ($event.bytesTotal > $event.bytesLoaded) ? ($event.bytesLoaded / $event.bytesTotal) : 0.02;
        
        
    }
    
    private function contentCompleteHandler($event:Event) :void {
        this._loadingInfo.contentLoaderInfo.removeEventListener(ProgressEvent.PROGRESS, this.contentProgressHandler);
        this._loadingInfo.contentLoaderInfo.removeEventListener(Event.COMPLETE, this.contentCompleteHandler);
    }

}

internal class UIProgress extends Bitmap {
    public function UIProgress($width:int, $height:int) {
        
    }
}