/**
 * Copyright hiro_loveness ( http://wonderfl.net/user/hiro_loveness )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/tTfa
 */

// forked from minon's ランダムな大きさのグリッドがスクロールするアレ
/**
 * よくあるランダムな大きさのグリッドがスクロースするアレ
 * とりあえず出来てるけど、もっとスマートなやり方が知りたい。
 * 例のごとくソースは超適当、誰か良いやり方教えてほすぃ・・・
 */
package  {
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.geom.Rectangle;
    
    [SWF(width = "465", height = "465", frameRate = "60", backgroundColor = "0xFFFFFF")]
    
    /**
     * ...
     * @author minon
     */
    public class Test extends Sprite {
        
        //配置済みオブジェクトが格納される配列
        private var _objects:Array = [];
        
        //最大描画ライン数
        private var _maxLines:int = 0;
        
        //配置チェック用BitmapData
        private var _grid:BitmapData;
        
        //オブジェクトの大きさ定義
        private var _boxWidth:int = 50;
        private var _boxHeight:int = 50;
        private var _margin:int = 5;
        
        private var _speed:Number = 1;
        private var _moveValue:Number = 0;
        
        private var _nowLine:int = 0;
        private var _c:int = 6;
        
        public function Test() {
            
            stage.scaleMode = "noScale";
            stage.align = "TL";
            
            _grid = new BitmapData( 500, _c, false, 0xFFFFFF );
            
            //最大表示ライン数の変更
            _maxLines = Math.floor( stage.stageWidth / _boxWidth ) + 2;
            
            addEventListener(Event.ENTER_FRAME, _move );
            _createObject();
            
            //ステージリサイズの監視
            stage.addEventListener( Event.RESIZE, _changeStageHandler );
            _changeStageHandler( null );
            
        }
        
        private function _createObject():void {
            
            var dot:uint, mc:Box, max:int;
            var sca:int = 1;
            
            for ( var i:int = _nowLine ; i < _maxLines ; i++ ) {
                
                for ( var j:int = 0; j < _c ; j++ ) {
                    
                    //現在の配置情報取得
                    dot = _grid.getPixel( i, j );
                    
                    //配置済みなら無視
                    if ( dot == 0 ) continue;
                    
                    sca = 0;
                    while ( _grid.getPixel( i, j + sca ) > 0 ) sca++;
                    
                    sca = Math.round( Math.random() * ( sca - 1) ) + 1;
                    
                    _grid.fillRect( new Rectangle( i, j, sca, sca ), 0 );
                    
                    mc = new Box( ( _boxWidth + _margin ) * sca - _margin, ( _boxHeight + _margin ) * sca - _margin );
                    
                    //位置調整
                    mc.x = ( _boxWidth + _margin ) * i - _moveValue;
                    mc.y = ( _boxHeight + _margin ) * j;
                    
                    addChild( mc );
                    _objects.push( mc );
                }
            }
            _nowLine = i;
        }
        
        
        private function _move(e:Event):void {
            
            var i:int = 0;
            var mc:Box;
            
            while ( mc = _objects[i] as Box ) {
                
                mc.x -= _speed;
                
                //消していいか判定するワケですね
                if ( mc.x < -(_boxWidth * _c + _margin ) ) {
                    removeChild( mc );
                    _objects.splice( i, 1 );
                }
                else {
                    i++;
                }
                
            }
            
            _moveValue += _speed;
            
            //1行分スクロールしたとき
            if ( _moveValue >= ( _boxWidth + _margin ) ) {
                
                _nowLine--;
                _moveValue = 0;
                _grid.scroll( -1, 0 );
                
                _createObject();
            }
        }
        
        
        private function _changeStageHandler(e:Event):void {
            
            var w:int = stage.stageWidth;
            var h:int = stage.stageHeight;
            
            this.y = Math.round( ( h - this.height ) / 2 );
            
            var ml:int = Math.floor( w / ( _boxWidth + _margin ) ) + 2;
            if ( _maxLines < ml ) {
                _maxLines = ml;
                _createObject();
            }
        }
    }
}

import flash.display.Graphics;
import flash.display.Sprite;

class Box extends Sprite {
    
    public function Box( w:int, h:int ) {
        
        var g:Graphics = this.graphics;
        
        g.beginFill( Math.round( Math.random() * 0xFFFFFF ) );
        g.drawRect( 0, 0, w, h );
        g.endFill();
        
    }
    
}