/**
 * Copyright syunsuke ( http://wonderfl.net/user/syunsuke )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/tTFW
 */

// forked from hacker_gcv15_bo's raderChart
/*
    ActionScript 3.0 によるレーダーチャート Ver.0.2
    Copyright (C) 2009/2/26 有限会社ずばぴたテック　根岸智幸
    http://www.zubapita.jp/
    フリーウェアです。　好きなようにご利用ください。
    
    項目数は可変。目盛は1〜5。小数点も可。
    ステージのサイズは、Flash側で設定してください。

*/
package {

import flash.display.Sprite;
import flash.display.Graphics;
import flash.text.*;

public class raderChart extends Sprite {

    // 項目名
    var labe:Array = ["引きの強さ", "振込阻止率", "上がり役の大きさ"];
    // 各項目の値
    var ratings:Array = [8 ,0, 4];
    // 各項目の軸の角度。値は、のちほど項目数から算出
    var angles = new Array();

    var unitLength:Number = 5.8;
    // FlashではX=1,Y=0（右横）が0度。そこから右回りに増えるので、Y=1,X=0（真上）は270度になる。
    var startAngle:int = 270;
    
    // 原点はステージの中央
    var originX:Number = stage.stageWidth / 2;
    var originY:Number = stage.stageHeight / 2;


// コンストラクタ もしくは メインルーチン
public function raderChart():void {

    // 真上（270度）から、(360/項目数)度ずつ、足して各項目の軸の角度を求める。
    // 360度を超えても、Flashが自動的に修正してくれる（賢い！）
    var angle:int = startAngle;
    var step:int = 360 / labe.length;
    for(var i:int=0;i<labe.length;i++) {
        angles[i] = angle;
        angle += step; 
    }
    
    // ガイドを引く
    drawGuide();
    // チャートを塗りつぶす
    drawRatings();

}

// ガイドを引く
function drawGuide() {
    var sp:Sprite = new Sprite();
    addChild(sp);
    var g:Graphics = sp.graphics;
    
    g.lineStyle(1, 0x0000ff);
    var x:Number = 0;
    var y:Number = 0;

    // フォント設定
    var label = new Array();
    var textFmt:TextFormat = new TextFormat();
    textFmt.font = "Verdana";
    textFmt.align = "center";
    textFmt.color = "0x000000";
    textFmt.size = 10;
    textFmt.leading = 0;
    textFmt.leftMargin = textFmt.rightMargin = 1;
    textFmt.indent = 0;

    // 軸とラベルを描画
    for(var key in angles) {
        var angle:Number = Number(angles[key]);
        var radian:Number = deg2rad(angle);
        // 目盛の最大値 = 5
        x = originX + getX(radian, 5);
        y = originY + getY(radian, 5);
        drawLine(g, originX, originY, x, y);

        label[key] = new TextField();
        label[key].autoSize = TextFieldAutoSize.CENTER;
        // 目盛5の外側にラベルを表示するから、距離は6
        label[key].x = originX + getX(radian, 6);
        label[key].y = originY + getY(radian, 6) - 10; // -10はY位置の補正
        label[key].defaultTextFormat = textFmt;
        this.addChild(label[key]);
        label[key].text = labe[key]; 

    }

    // 目盛を描画
    drawScale(g);

}

// ガイドに目盛を引く
function drawScale(g:Graphics) {
    // 最後の点から最初の点へ線を引く準備...*1
    angles.push(angles[0]);
    
    // 目盛1から5の線を順に描く
    for(var i=1;i<=5;i++) {
        var x:Number = 0;
        var y:Number = 0;
        var oldX:Number = 0;
        var oldY:Number = 0;
        for(var key in angles) {
            var angle:Number = Number(angles[key]);
            var radian:Number = deg2rad(angle);
            x = originX + getX(radian, i);
            y = originY + getY(radian, i);
            // ループ1週目だけ moveTo、あとはすべてlineTo
            if(oldX==0 && oldY==0) {
                g.moveTo(x, y);
            }  else {
                g.lineTo(x, y);
            }
            oldX = x;
            oldY = y;
        }
    }
    
    // *1の後始末
    angles.pop();
}

// チャートを塗りつぶす
function drawRatings() {
    ratings = [];
            ratings.push(8);
            ratings.push(0);
            ratings.push(4);
    // 最後の点から最初の点へ線を引く準備...*2
    ratings.push(ratings[0]);
    angles.push(angles[0]);
    
    var sp:Sprite = new Sprite();
    addChild(sp);
    var g:Graphics = sp.graphics;

    var x:Number = 0;
    var y:Number = 0;
    var oldX:Number = 0;
    var oldY:Number = 0;

    // 描画
    g.clear();
    //g.lineStyle(1, 0xff0000);
    g.beginFill(0xff0000, 0.64);
    for(var key in ratings) {
        var rating:Number = Number(ratings[key]);
        var angle:Number = Number(angles[key]);
        var radian:Number = deg2rad(angle);
        x = originX + getX(radian, rating);
        y = originY + getY(radian, rating);
        // ループ1週目だけ moveTo、あとはすべてlineTo
        if(oldX==0 && oldY==0) {
            g.moveTo(x, y);
        } else {
            g.lineTo(x, y);
        }
        oldX = x;
        oldY = y;
    }
    g.endFill();
    
    // *2の後始末
    ratings.pop();
    angles.pop();
}

/*
　ユーティリティたち
 */

// 単純に（連続しない）直線を描く
function drawLine(g:Graphics, startX:Number, startY:Number, endX:Number, endY:Number) {
    g.moveTo(startX, startY);
    g.lineTo(endX ,endY);
}

// 角度（ラジアン）と長さからYの位置を得る
function getX(radian:Number, length:Number) {
    return unitLength * length * Math.cos(radian);
}

// 角度（ラジアン）と長さからXの位置を得る
function getY(radian:Number, length:Number) {
    return unitLength * length * Math.sin(radian);
}

// 度をラジアンに変換
function deg2rad(deg:Number):Number {
    return deg * (Math.PI / 180);
}


} // end of class raderChart

} // end of Package

