/**
 * Copyright yasurageruheya ( http://wonderfl.net/user/yasurageruheya )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/tQSB
 */

package {
	import flash.display.Loader;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.geom.Rectangle;
	import flash.system.System;
	import flash.text.TextField;
	import flash.utils.ByteArray;
	public class FlashTest extends Sprite {
		
		public const LOOP:int = 4100;
		
		public const txt:TextField = new TextField();
		
		public var tests:Vector.<Tester> = new Vector.<Tester>();
		
		public var freeMemory:int;
		
		public var gcCount10byte:int = 0;
		
		public var gcCount100byte:int = 0;
		
		public var gcCount1KB:int = 0;
		
		public var gcCount10KB:int = 0;
		
		public var gcCount100KB:int = 0
		
		public var gcCount1MB:int = 0;
		
		public var gcCount10MB:int = 0;
		
		public var gcCount100MB:int = 0;
		
		public var gcCount:int = 0;
		
		public var totalFrames:Number = 1;
		
		public function FlashTest() {
			
			var vec:Vector.<Loader> = new Vector.<Loader>(LOOP);
			var count:int = 0;
			
			/*
			tests[tests.length] = new Tester("プールが空の状態 fromPool : ", function():void
			{
				var i:int = LOOP;
				while (i--)
				{
					vec[i] = PoolLoader.fromPool();
				}
			});
			
			tests[tests.length] = new Tester("プーリング toPool : ", function():void
			{
				var i:int = LOOP;
				while (i--)
				{
					PoolLoader.toPool(vec[i]);
				}
			});
			
			vec = new Vector.<Loader>(LOOP);
			
			tests[tests.length] = new Tester("プールから取り出す fromPool : ", function():void
			{
				var i:int = LOOP;
				while (i--)
				{
					vec[i] = PoolLoader.fromPool();
				}
			});
			/*/
			tests[tests.length] = new Tester("new Loader() : ", function():void
			{
				var i:int = LOOP;
				while (i--)
				{
					new Loader();
				}
			});
			//*/
			
			tests.reverse();
			txt.width = 500;
			txt.height = 500;
			addChild(txt);
			
			freeMemory = System.freeMemory;
			
			// write as3 code here..
			addEventListener(Event.ENTER_FRAME, test);
		}
		
		private function test(e:Event):void 
		{
			var str:String = "";
			var i:int = tests.length;
			while (i--)
			{
				str += tests[i].start();
			}
			if (tests.length > 1)
			{
				str += "プーリングと取り出しの合計 : " + (tests[0].timeAverage + tests[1].timeAverage) + " ms.\n";
			}
			str += "memory : total " + System.totalMemory + " / private " + System.privateMemory + "\n";
			
			const currentFreeMemory:Number = System.freeMemory;
			
			if (freeMemory < currentFreeMemory)
			{
				gcCount++;
				const gcMemory:Number = currentFreeMemory - freeMemory;
				if (gcMemory > 100000000)
				{
					gcCount100MB++;
				}
				else if (gcMemory > 10000000)
				{
					gcCount10MB++;
				}
				else if (gcMemory > 1000000)
				{
					gcCount1MB++;
				}
				else if (gcMemory > 100000)
				{
					gcCount100KB++;
				}
				else if (gcMemory > 10000)
				{
					gcCount10KB++;
				}
				else if (gcMemory > 1000)
				{
					gcCount1KB++;
				}
				else if (gcMemory > 100)
				{
					gcCount100byte++;
				}
				else if (gcMemory > 10)
				{
					gcCount10byte++;
				}
			}
			freeMemory = System.freeMemory;
			
			str += "\n100MB\tGC発生回数？\t: " + gcCount100MB;
			str += "\n10MB\t\tGC発生回数？\t: " + gcCount10MB;
			str += "\n1MB\t\tGC発生回数？\t: " + gcCount1MB;
			str += "\n100KB\t\tGC発生回数？\t: " + gcCount100KB;
			str += "\n10KB\t\tGC発生回数？\t: " + gcCount10KB;
			str += "\n1KB\t\tGC発生回数？\t: " + gcCount1KB;
			str += "\n100byte\tGC発生回数？\t: " + gcCount100byte;
			str += "\n10byte\t\tGC発生回数？\t: " + gcCount10byte;
			str += "\n\t\t\tGC発生回数？\t: " + gcCount;
			
			str += "\n\t\t\tGC発生率？\t: " + ((gcCount / (totalFrames++)) * 100) + "%";
			
			txt.text = str;
		}
	}
}

import flash.display.Loader;
import flash.display.LoaderInfo;
import flash.geom.Rectangle;
import flash.system.System;
import flash.utils.ByteArray;
import flash.utils.Dictionary;
import flash.utils.getTimer;
class Tester
{
	public var time:Number = 0;
	
	public var name:String;
	
	public var test:Function;
	
	public var count:Number = 1;
	
	public function start():String
	{
		const startTime:int = getTimer();
		test();
		time += getTimer() - startTime;
		return name + (time / (count++)) + " ms.\n";
	}
	
	public function get timeAverage():Number
	{
		return time / count;
	}
	
	public function Tester(name:String, test:Function)
	{
		this.name = name;
		this.test = test;
	}
}


class PoolLoader
{
	private static const _pool:Vector.<Loader> = new Vector.<Loader>();
	
	private static const _dic:Dictionary = new Dictionary();
	
	[Inline]
	public static function fromPool():Loader
	{
		var i:int = _pool.length;
		var b:Loader;
		while (i--)
		{
			b = _pool.pop();
			delete _dic[b];
			if (!b.contentLoaderInfo.bytesTotal)
			{
				return b;
			}
		}
		return new Loader();
	}
	
	[Inline]
	public static function toPool(b:Loader):void
	{
		if (!_dic[b])
		{
			b.unloadAndStop();
			_dic[b] = true;
			_pool[_pool.length] = b;
		}
	}
}