/**
 * Copyright yukifuruyoru ( http://wonderfl.net/user/yukifuruyoru )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/tPyk
 */

// forked from clockmaker's あなたのイベントハンドラを教えて！
/**
* あなたのイベントハンドラを教えて！
*
* 複数のイベント＆複数のインスタンスに
* イベントハンドラを設定するときに
* みなさんの記述方法の違いを知りたい。
*
* [ルール]
* 画面上に3つのボタンが用意されており、
* クリックとロールオーバーの
* イベントハンドラを記述してください。
*/
package {
    import flash.display.Sprite;
    import flash.events.MouseEvent;
    public class FlashTest extends Sprite {
    
        private var _btnA:MyButton;
        private var _btnB:MyButton;
        private var _btnC:MyButton;
//yukifu流
/*普段はボタンインスタンスは個別に作らずに
_btnbox相当のものにgraphicsで直接「ボタンの絵」をならべて描いています*/
        private var _btnbox:Sprite=new Sprite();
        private var _label:MyTextField;

        public function FlashTest() {
            // ボタンを作成
            _build();
            
            // 自分流のイベントハンドラを記述ください
            
            // Yukifu流
/*説明しよう！yukifuruは極度のめんどくさがりなのである！*/
/*同じ機能のイベントリスナを何度も登録するのは「面倒」と「判断」したっ！*/
/*残るのは「結果」だけだっ！*/
            // クリック
            
            _btnbox.addEventListener(MouseEvent.CLICK, _onMouseEvent);
           // ロールオーバー
            _btnbox.addEventListener(MouseEvent.ROLL_OVER, _onMouseEvent);
          }
        
            // Yukifuru流
        private function _onMouseEvent(e:MouseEvent):void {

/*説明しよう！yukifuruはごく最近までイベントオブジェクトのtargetプロパティ
の存在を知らなかった！
なんと代わりにマウス座標で押されたボタンを判断していたのである！
しかしそのためにはボタンを同じインスタンスにぶち込まなくてはならない！
ゆえにyukifuruはボタンを作らない！ボタンはgraphicsで「描く」！！！
forkをあまり崩さないために今回はボタンクラスそのままですが*/

/*_btnboxスプライトを親とし、3等分したエリアを0,1,2と番号をきめて
クリックされた座標からエリア番号を計算します。*/
             var i:uint=_btnbox.mouseX/_btnbox.width*3;
             _label.x=_btnbox.x+i*120-18;
             // タイプを判別
             switch(e.type){
                 case MouseEvent.CLICK:
                     // 対象を判別
                     switch(i){
                         case 0: _label.text = "A がクリックされました"; break;
                         case 1: _label.text = "B がクリックされました"; break;
                         case 2: _label.text = "C がクリックされました"; break;
                     }
                     break;
                 case MouseEvent.ROLL_OVER:
                     // 対象を判別
                     switch(i){
                         case 0: _label.text = "A がロールパンナちゃん"; break;
                         case 1: _label.text = "B がロールパンナちゃん"; break;
                         case 2: _label.text = "C がロールパンナちゃん"; break;
                     }
                     break;
             }
             
        }
        
        /**
        * インターフェースを作る
        */
        private function _build():void {
        	with(_btnbox){

            _btnA = new MyButton();
            _btnA.text = "Button A"; 
            addChild(_btnA);
            
            _btnB = new MyButton();
            _btnB.text = "Button B";
            _btnB.x = 120; 
            addChild(_btnB);
   
            _btnC = new MyButton();            
            _btnC.text = "Button C";
            _btnC.x = 240;
            addChild(_btnC);
        }
        _btnbox.x=(465-_btnbox.width)/2;
        _btnbox.y=(465-_btnbox.height)/2;
        addChild(_btnbox);
        
            _label = new MyTextField();
            _label.y = _btnbox.y+50;
            addChild(_label);
        }
    }
}

import flash.display.*
import flash.text.*;

/**
* MyButton クラスはボタン的な挙動をするようにしたSpriteです。
*/
class MyButton extends Sprite {
    private var _text:MyTextField;
    /**
    * 新しい MyButton インスタンスを作成します。
    */
    public function MyButton(){
        graphics.beginFill(0x000000);
        graphics.drawRoundRect(0, 0, 100, 30, 5, 5);
        addChild(_text = new MyTextField);
        buttonMode = true;
    }
    /**
    * ボタンの文言を設定します。
    */
    public function set text(value:String):void {
        _text.text = value;
        _text.x = (100 - _text.textWidth) / 2;
        _text.y = (30 - _text.textHeight) / 2;
    }
}

/**
* MyTextField クラスは適当な初期設定をしただけのテキストフィールドです。
*/
class MyTextField extends TextField {
    /**
    * 新しい MyTextField インスタンスを作成します。
    */
    public function MyTextField() {
        defaultTextFormat = new TextFormat("_sans", 12, 0xFF0000);
        autoSize = "left";
        selectable = false;
        mouseEnabled = false;
    }
}