/**
 * Copyright umhr ( http://wonderfl.net/user/umhr )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/tPkb
 */

package 
{
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.display.Graphics;
	[SWF(width="465", height="465", backgroundColor="0x5FBDF5", frameRate="30")]
	public class Condor extends Sprite
	{
		private var originPoz:Array;
		private var rotationPoz:Array = new Array(0,0,0,0,0.1,0.1);
		private var _stageWidth:Number = stage.stageWidth/2;
		private var _stageHeight:Number = stage.stageHeight/2;
		public function Condor() { 
			var model_array:Array = new Array();
			//座標（ナスカの地上絵の経緯）
			model_array = [-75.126382,-14.698009,-75.126453,-14.697785,-75.126448,-14.697776,-75.126441,-14.697763,-75.126442,-14.69775,-75.126452,-14.697736,-75.126468,-14.697733,-75.126468,-14.697713,-75.126451,-14.697694,-75.126244,-14.697558,-75.126213,-14.697527,-75.126148,-14.697419,-75.126104,-14.697342,-75.126116,-14.697339,-75.126144,-14.69738,-75.126182,-14.697424,-75.126248,-14.697512,-75.126272,-14.697537,-75.126281,-14.697545,-75.126285,-14.697536,-75.12626,-14.6975,-75.12616,-14.697356,-75.126166,-14.697346,-75.126174,-14.697347,-75.126204,-14.69739,-75.126246,-14.697447,-75.126307,-14.69753,-75.12632,-14.697535,-75.126329,-14.697532,-75.12621,-14.697351,-75.126207,-14.697341,-75.126215,-14.697334,-75.126226,-14.697338,-75.126279,-14.697414,-75.126363,-14.697538,-75.126372,-14.69755,-75.126381,-14.697552,-75.126385,-14.697545,-75.126286,-14.69735,-75.126293,-14.69734,-75.126311,-14.697342,-75.126422,-14.697548,-75.126427,-14.697551,-75.126433,-14.697543,-75.126372,-14.69737,-75.126377,-14.697359,-75.126385,-14.697355,-75.126404,-14.697356,-75.126478,-14.697549,-75.126487,-14.697549,-75.126506,-14.697504,-75.126472,-14.697426,-75.126464,-14.697423,-75.126453,-14.697409,-75.12645,-14.697397,-75.126451,-14.69738,-75.126425,-14.697325,-75.126408,-14.697319,-75.126386,-14.697306,-75.126372,-14.697295,-75.126344,-14.697276,-75.126343,-14.697264,-75.126352,-14.697263,-75.126382,-14.697289,-75.126409,-14.697295,-75.126414,-14.697287,-75.12641,-14.697281,-75.126365,-14.69724,-75.126334,-14.697208,-75.126336,-14.697198,-75.126346,-14.6972,-75.126384,-14.697232,-75.126405,-14.69725,-75.126419,-14.697255,-75.126434,-14.697262,-75.12644,-14.697254,-75.126435,-14.697249,-75.126401,-14.697228,-75.12638,-14.697207,-75.126379,-14.697197,-75.126391,-14.697197,-75.126407,-14.697211,-75.126429,-14.697222,-75.126465,-14.697242,-75.126474,-14.697253,-75.126473,-14.697266,-75.126481,-14.697267,-75.126492,-14.697261,-75.126499,-14.697246,-75.12651,-14.69722,-75.126519,-14.697222,-75.12652,-14.697235,-75.12651,-14.697262,-75.126502,-14.697272,-75.126469,-14.697299,-75.126457,-14.69731,-75.126454,-14.697329,-75.126461,-14.697343,-75.126473,-14.697369,-75.12649,-14.697389,-75.126496,-14.697409,-75.126496,-14.697427,-75.126511,-14.697465,-75.126519,-14.697473,-75.126521,-14.697465,-75.126548,-14.697381,-75.126559,-14.697271,-75.126573,-14.697114,-75.126598,-14.696852,-75.126605,-14.696843,-75.126637,-14.696851,-75.126638,-14.696868,-75.126624,-14.696958,-75.126564,-14.697351,-75.126568,-14.697362,-75.126577,-14.697344,-75.126687,-14.696873,-75.126692,-14.696869,-75.126722,-14.696874,-75.126725,-14.696882,-75.126601,-14.697336,-75.126603,-14.697342,-75.126609,-14.697339,-75.126757,-14.696896,-75.126762,-14.69689,-75.126782,-14.696896,-75.126784,-14.696902,-75.126702,-14.697187,-75.12671,-14.697191,-75.126815,-14.696918,-75.126821,-14.696912,-75.126843,-14.696915,-75.126846,-14.696923,-75.126682,-14.697304,-75.126689,-14.697309,-75.126873,-14.696942,-75.126879,-14.696935,-75.126898,-14.696939,-75.126904,-14.696948,-75.12671,-14.697301,-75.1267,-14.697319,-75.126715,-14.697306,-75.126939,-14.696971,-75.12695,-14.696971,-75.126966,-14.696984,-75.126967,-14.696989,-75.126743,-14.697299,-75.126649,-14.697431,-75.12662,-14.6975,-75.126625,-14.6975,-75.126675,-14.697481,-75.12668,-14.697472,-75.126692,-14.69746,-75.126711,-14.697455,-75.126733,-14.697453,-75.126775,-14.697433,-75.126784,-14.697433,-75.126787,-14.697417,-75.126779,-14.697401,-75.126766,-14.697362,-75.126774,-14.69735,-75.126785,-14.697357,-75.126793,-14.697385,-75.126799,-14.697394,-75.126805,-14.697397,-75.126806,-14.69739,-75.126832,-14.697376,-75.126857,-14.697373,-75.126885,-14.697376,-75.126886,-14.697387,-75.12687,-14.697393,-75.12685,-14.69739,-75.126839,-14.697397,-75.126851,-14.697401,-75.126871,-14.697403,-75.126892,-14.697396,-75.126902,-14.697404,-75.126894,-14.697413,-75.126876,-14.697418,-75.126858,-14.69742,-75.126835,-14.69742,-75.126836,-14.697428,-75.126857,-14.69743,-75.126876,-14.697434,-75.126873,-14.697445,-75.126863,-14.697448,-75.126832,-14.697442,-75.126819,-14.697445,-75.126796,-14.697452,-75.126735,-14.697476,-75.126726,-14.697485,-75.126706,-14.697496,-75.126688,-14.697494,-75.126618,-14.697525,-75.12661,-14.697532,-75.126583,-14.6976,-75.126588,-14.697612,-75.1266,-14.697611,-75.126851,-14.697565,-75.126856,-14.697574,-75.126845,-14.697617,-75.126623,-14.697644,-75.126625,-14.69765,-75.126634,-14.697656,-75.126881,-14.69766,-75.126896,-14.69766,-75.1269,-14.697677,-75.126892,-14.69769,-75.126652,-14.697678,-75.126646,-14.697685,-75.126656,-14.6977,-75.126924,-14.697752,-75.126952,-14.697773,-75.126947,-14.69779,-75.126694,-14.697726,-75.126697,-14.697738,-75.12671,-14.697746,-75.126963,-14.697819,-75.126984,-14.69783,-75.126994,-14.697844,-75.126985,-14.697854,-75.126798,-14.697797,-75.126739,-14.697786,-75.126752,-14.697805,-75.126765,-14.697812,-75.127003,-14.697882,-75.127008,-14.697889,-75.127,-14.697899,-75.12677,-14.697844,-75.126733,-14.697831,-75.126518,-14.697727,-75.126509,-14.697735,-75.126501,-14.697742,-75.126507,-14.697753,-75.126511,-14.697762,-75.126502,-14.697781,-75.126485,-14.69779,-75.126474,-14.697791,-75.126408,-14.697957,-75.126397,-14.697983,-75.126382,-14.698009];
			//経緯だと使いにくいので、座標を適当に補正
			var _length:int = model_array.length/2;
			originPoz = new Array(_length);
			var _x:Number = 0;
			var _y:Number = 0;
			for (var i:uint = 0; i<_length; i++) {
				_x += model_array[i*2]/_length;
				_y += model_array[i*2+1]/_length;
			}
			for (i = 0; i<_length; i++) {
				originPoz[i] = [(model_array[i*2]-_x)*400000,0,(model_array[i*2+1]-_y)*400000];
			}
			//実行
			this.addEventListener(Event.ENTER_FRAME,ENTER_FRAME);
		}
		
		private function ENTER_FRAME(e:Event):void{
			var _poz:Array = Mztm3D.arrayClone(originPoz);
			if(0 < stage.mouseX && (stage.mouseX < _stageWidth*2)){
				rotationPoz[4] += (stage.mouseX - _stageWidth)/10000;
			}
			if(0 < stage.mouseY && (stage.mouseY < _stageHeight*2)){
				rotationPoz[5] += (stage.mouseY - _stageHeight)/100000;
			}
			Mztm3D.affine(_poz,rotationPoz)
			Mztm3D.perspective(_poz);
			drawFill(_poz);
		}

		//面を描く
		private function drawFill(__poz:Array):void{
			this.graphics.clear();
			var g:Graphics = this.graphics;
			g.beginFill (0xFFFFFF, 1.0);	// 面のスタイル設定
			var _len:int = __poz.length;
			g.moveTo (__poz[_len-1][0]+_stageWidth, __poz[_len-1][1]+_stageHeight);
			for (var i:int = 0; i<_len; i++) {
				g.lineTo (__poz[i][0]+_stageWidth, __poz[i][1]+_stageHeight);
			}
			g.endFill();			
		}
	}
}

class Mztm3D{
	//arrayの複製。再起処理を行っている。
	public static function arrayClone(ar:Array):Array {
		var _array:Array = new Array();
		var _len:int = ar.length;
		for (var i:int = 0; i<_len; i++) {
			_array[i]=(ar[i] is Array)?arrayClone(ar[i]):ar[i];
		}
		return _array;
	}
	//パースペクティブ
	public static function perspective(__poz:Array):void{
		var _len:int = __poz.length;
		for (var i:int = 0; i<_len; i++) {
			var _per:Number = 300/(300+__poz[i][2]);
			__poz[i] = [__poz[i][0] * _per,__poz[i][1] * _per,_per];				
		}
	}
	//アフィン変換
	public static function affine(__poz:Array,__view:Array):void {
		var n_cx:Number = Math.cos(__view[int(3)]);
		var n_sx:Number = Math.sin(__view[int(3)]);
		var n_cy:Number = Math.cos(__view[int(4)]);
		var n_sy:Number = Math.sin(__view[int(4)]);
		var n_cz:Number = Math.cos(__view[int(5)]);
		var n_sz:Number = Math.sin(__view[int(5)]);
		var d_x:Number = __view[int(0)];
		var d_y:Number = __view[int(1)];
		var d_z:Number = __view[int(2)];
		var af_xx:Number = n_cz*n_cy+n_sx*n_sy*n_sz;
		var af_xy:Number = n_sx*n_sy*n_cz-n_sz*n_cy;
		var af_xz:Number = n_sy*n_cx;
		var af_yx:Number = n_cx*n_sz;
		var af_yy:Number = n_cx*n_cz;
		var af_yz:Number = -n_sx;
		var af_zx:Number = n_cy*n_sx*n_sz-n_sy*n_cz;
		var af_zy:Number = n_sy*n_sz+n_cy*n_sx*n_cz;
		var af_zz:Number = n_cx*n_cy;
		var _len:uint = new uint(__poz.length);
		for (var i:uint = 0; i<_len; i++) {
			var af_x:Number = __poz[i][int(0)];
			var af_y:Number = __poz[i][int(1)];
			var af_z:Number = __poz[i][int(2)];
			__poz[i][uint(0)] = af_x*af_xx+af_y*af_xy+af_z*af_xz+d_x;
			__poz[i][uint(1)] = af_x*af_yx+af_y*af_yy+af_z*af_yz+d_y;
			__poz[i][uint(2)] = af_x*af_zx+af_y*af_zy+af_z*af_zz+d_z;
		}
	}
}