/**
 * Copyright kanonji ( http://wonderfl.net/user/kanonji )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/tP1c
 */

/**
 * Progression4のサンプル「Basic」を参考に書いてます。
 * http://progression.jp/download/4.0.1%20Public%20Beta%201.2/Progression4-Examples.zip
 *
 * wonderflの制限に合わせたのと、多少シンプルにしましたが、意図した通りに動きません。
 * 赤い正方形が表示されると思うのですが、何も表示されません。
 * 間違いを探してみましたが、コンパイル時にエラーも出ないので、お手上げです。
 */
package {
    import jp.progression.Progression;
    import jp.progression.casts.*;
    import jp.progression.config.*;
    import jp.progression.debug.*;
    public class Index extends CastDocument {

        public function Index(){
            //CastDocumentを初期化する際の各種設定
            //第3引数でProgressionの動作モードを指定
            ///jp/progression/config/package-detail.html
            super("index", IndexScene, new WebConfig());
            //super("index", IndexScene, new BasicAppConfig());
            //super("index", IndexScene, new LWAppConfig());
            //super("index", IndexScene, new SlideConfig());
        }
        
        protected override function atReady():void{
            //作成されたProgressionインスタンスをデバッガーに登録。
            //manager:Progression
            Debugger.addTarget(manager);
            
            var square:CastSprite = new CastSprite();
            square.id = "square";
            square.graphics.beginFill( 0xFF0000 );
            square.graphics.drawRect( 0,0,100,100 );
            square.graphics.endFill();
            
            manager.goto( manager.root.sceneId );
            //シーンイベントを発生させない場合。
            //manager.jump( manager.root.sceneId );
        }
    }
}

import jp.progression.scenes.SceneId;
import jp.progression.scenes.SceneObject;
import jp.progression.commands.display.AddChild;
import jp.progression.commands.display.RemoveChild;

class IndexScene extends SceneObject{
    public function IndexScene( name:String = null, initObject:Object = null){
        super( name, initObject );
    }
    
    protected override function atSceneLoad():void{
        //addCommand();
    }
    
    protected override function atSceneInit():void{
        addCommand(
            new AddChild( container, "square" )
        );
    }
    
    protected override function atSceneGoto():void{
        addCommand(
            new RemoveChild( container, "square")
        );
    }
    
    protected override function atSceneUnload():void{
        //addCommand();
    }
}