/**
 * Copyright Naohiko.Ueno ( http://wonderfl.net/user/Naohiko.Ueno )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/tOrM
 */

package 
{
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.system.Capabilities;
    import flash.ui.ContextMenu;
    
    import starling.core.Starling;
    
    [SWF(width="465", height="465", frameRate="60", backgroundColor="#222222")]
    public class Startup extends flash.display.Sprite
    {
        public function Startup()
        {
            // Wonderflのプレピュー用にキャプチャ撮りたいときだけ第1引数をtrueにする。
            // 第2引数はキャプチャを撮るまでの秒数。
            WonderflCaptureUtil.init(true, 1);
            
            var menu:ContextMenu = new ContextMenu();
            menu.hideBuiltInItems();
            contextMenu = menu;
            
            loaderInfo.addEventListener(Event.COMPLETE, loaderInfo_completeHandler);
        }
        
        private var _starling:Starling;
        
        private function loaderInfo_completeHandler(event:flash.events.Event):void
        {
            loaderInfo.removeEventListener(Event.COMPLETE, loaderInfo_completeHandler);
            
            Starling.multitouchEnabled = false; // useful on mobile devices
            Starling.handleLostContext = true; // deactivate on mobile devices (to save memory) 
            
            _starling = new Starling(Root, stage);
            _starling.simulateMultitouch = true;
            _starling.enableErrorChecking = Capabilities.isDebugger;
            _starling.showStats = true;
            _starling.start();
            
            // Wonderflのプレピュー用キャプチャを撮るときだけStarlingの画面をビットマップ化してstage最前面に追加する。
            if (WonderflCaptureUtil.captureEnabled)
            {
                _starling.juggler.delayCall(function():void
                {
                    WonderflCaptureUtil.createStarlingCaptureImage(_starling);
                }, WonderflCaptureUtil.captureDelay - 0.5);
            }
        }
    }
}

import starling.display.Sprite;
import starling.events.Event;
import starling.text.TextField;

class Root extends starling.display.Sprite
{    
    public function Root()
    {
        addEventListener(Event.ADDED_TO_STAGE, init);
    }
    
    public function init():void
    {
        var textField:TextField = new TextField(256, 32, "Starling scaffald for wonderfl");
        textField.x = stage.stageWidth - textField.width >> 1;
        textField.y = stage.stageHeight - textField.height >> 1;
        textField.color = 0xFFFFFF;
        textField.autoScale = true;
        addChild(textField);
    }
}


////////////////////////////////////////////////////////////////////////////////////////////////////////
//
//  WonderflCaptureUtil
//
////////////////////////////////////////////////////////////////////////////////////////////////////////
import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.errors.IllegalOperationError;
import flash.events.MouseEvent;
import flash.text.TextFieldAutoSize;
import flash.text.TextFormat;
import flash.utils.getDefinitionByName;

import starling.core.RenderSupport;
import starling.core.Starling;

class WonderflCaptureUtil
{
    // Wonderfl default setting @see http://wonderfl.net/help#help_capture
    private static var _capture:Boolean = true;
    private static var _captureDelay:Number = 3;
    
    private static var _inited:Boolean = false;
    private static var _wonderflClassChecked:Boolean = false;
    private static var _wonderflClass:Class;
    
    public static function get captureEnabled():Boolean
    {
        return wonderflClass ? _capture : false;
    }
    
    public static function get captureDelay():Number
    {
        return _captureDelay;
    }
    
    public static function get wonderflClass():Class
    {
        if (_wonderflClassChecked)
            return _wonderflClass;
        else
        {
            try
            {
                _wonderflClassChecked = true;
                _wonderflClass = getDefinitionByName("Wonderfl") as Class
                return _wonderflClass;
            }
            catch (e:Error) {}
        }
        
        return null;
    }
    
    public static function init(capture:Boolean=false, captureDelay:Number=3):void
    {
        if (_inited)
            throw new IllegalOperationError("WonderflCaptureUtil is already inited.");
        
        _inited = true;
        _capture = capture;
        _captureDelay = captureDelay;
        
        if (wonderflClass)
        {
            if (capture)
                wonderflClass["capture_delay"](captureDelay);
            else
                wonderflClass["disable_capture"]();
        }
    }
    
    public static function createStarlingCaptureImage(starlingInstance:Starling=null):void
    {
        if (starlingInstance == null)
            starlingInstance = Starling.current;
        
        if (starlingInstance == null)
            throw new IllegalOperationError("Starling instance is missing");
        if (starlingInstance.context == null)
            throw new IllegalOperationError("Contex3D is missing");
        
        var captchaData:BitmapData = new BitmapData(465, 465, false);
        
        var support:RenderSupport = new RenderSupport();
        RenderSupport.clear(starlingInstance.stage.color, 1.0);
        support.setOrthographicProjection(0, 0, captchaData.width, captchaData.height);
        starlingInstance.stage.render(support, 1.0);
        support.finishQuadBatch();
        
        starlingInstance.context.drawToBitmapData(captchaData);
        
        var textField:Object = new (getDefinitionByName("flash.text::TextField"));
        textField.defaultTextFormat = new TextFormat("Arial", 10, 0xFFFFFF);
        textField.text = "This is captured image for winderfl preview.";
        textField.autoSize = TextFieldAutoSize.CENTER;
        textField.x = 465 - textField.width - 4;
        textField.y = 465 - textField.height - 4;
        var sprite:Object = new (getDefinitionByName("flash.display::Sprite"));
        sprite.graphics.beginFill(0x000000, 0.5);
        sprite.graphics.drawRoundRect(textField.x - 2, textField.y - 2, textField.width + 2, textField.height + 2, 6);
        sprite["addChild"](textField);
        captchaData["draw"](sprite);
        
        var captcha:Bitmap = new Bitmap(captchaData);
        starlingInstance.nativeStage.addChild(captcha);
        starlingInstance.nativeStage.addEventListener(MouseEvent.CLICK, nativeStage_clickHandler);
        
        function nativeStage_clickHandler(event:MouseEvent):void
        {
            starlingInstance.nativeStage.removeEventListener(MouseEvent.CLICK, nativeStage_clickHandler);
            starlingInstance.nativeStage.removeChild(captcha);
            captchaData.dispose();
        }
    }
}
