/**
 * Copyright motikawa_rgm ( http://wonderfl.net/user/motikawa_rgm )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/tORz
 */

package  
{
    import com.bit101.components.HSlider;
    import com.bit101.components.Label;
    import flash.display.DisplayObject;
    import flash.display.Graphics;
    import flash.display.InteractiveObject;
    import flash.display.Shape;
    import flash.display.Sprite;
    import flash.events.Event;
    /**
     * ...
     */
    public class Batu extends Sprite
    {
        private static const RADIAN:Number = Math.PI / 180;
        private var _sh:Shape;
        private var _radiusSlider:HSlider;
        private var _lineSlider:HSlider;
        private var _radText:Label;
        private var _lwText:Label;
        public function Batu() 
        {
            init();
        }
        private function init():void
        {
            addChild(_sh = new Shape());
            _sh.x = stage.stageWidth * .5;
            _sh.y = stage.stageHeight * .5;
            
            new Label(this, 10, 380, "Radius:");
            new Label(this, 10, 410, "LineWidth:");
            _radiusSlider = new HSlider(this, 10, 400, onChange);
            _lineSlider = new HSlider(this, 10, 430, onChange);
            _lineSlider.maximum = _radiusSlider.maximum = 100;
            _lineSlider.width = _radiusSlider.width = 200;
            _radiusSlider.value = 50;
            _lineSlider.value = 10;
            
            _radText = new Label(this, 210, 395);
            _lwText = new Label(this, 210, 425);
            onChange();
        }
        private function onChange(e:Event = null):void
        {
            _radText.text = Math.floor(_radiusSlider.value).toString();
            _lwText.text = Math.floor(_lineSlider.value).toString();
            createBatsu(_sh.graphics, _radiusSlider.value, _lineSlider.value);
        }
        private static function createBatsu(graphics:Graphics,radius:Number = 50, lineWidth:Number = 30,lineColor:uint = 0x000000,a:Number = 1):void
        {
            graphics.clear();
            graphics.clear();
            graphics.lineStyle(1, 0x0);
            graphics.drawCircle(0, 0, radius);
            graphics.beginFill(lineColor, a);
            var angles:Array = [45 , 135 , 225, 315],
                lw_2:Number = lineWidth * .5,
                innerRadius:Number = Math.SQRT2 * lw_2,
                r2:Number = radius * Math.cos(Math.asin(lineWidth / (radius * 2))),
                x1:Number = Math.cos(angles[0] * RADIAN) * r2,
                x2:Number = Math.cos(angles[1] * RADIAN) * r2,
                x3:Number = Math.cos(angles[2] * RADIAN) * r2,
                x4:Number = Math.cos(angles[3] * RADIAN) * r2,
                y1:Number = Math.sin(angles[0] * RADIAN) * r2,
                y2:Number = Math.sin(angles[1] * RADIAN) * r2,
                y3:Number = Math.sin(angles[2] * RADIAN) * r2,
                y4:Number = Math.sin(angles[3] * RADIAN) * r2,
                xx1:Number = Math.cos((angles[0] - 45) * RADIAN) * innerRadius,
                yy1:Number = Math.sin((angles[0] - 45) * RADIAN) * innerRadius,
                xx2:Number = Math.cos((angles[1] - 45) * RADIAN) * innerRadius,
                yy2:Number = Math.sin((angles[1] - 45) * RADIAN) * innerRadius,
                xx3:Number = Math.cos((angles[2] - 45) * RADIAN) * innerRadius,
                yy3:Number = Math.sin((angles[2] - 45) * RADIAN) * innerRadius,
                xx4:Number = Math.cos((angles[3] - 45) * RADIAN) * innerRadius,
                yy4:Number = Math.sin((angles[3] - 45) * RADIAN) * innerRadius,
                x10:Number = x1 + Math.cos((angles[0] -90) * RADIAN) * lw_2,
                x11:Number = x1 - Math.cos((angles[0] -90) * RADIAN) * lw_2,
                y10:Number = y1 + Math.sin((angles[0] -90) * RADIAN) * lw_2,
                y11:Number = y1 - Math.sin((angles[0] -90) * RADIAN) * lw_2,
                x20:Number = x2 + Math.cos((angles[1] -90) * RADIAN) * lw_2,
                x21:Number = x2 - Math.cos((angles[1] -90) * RADIAN) * lw_2,
                y20:Number = y2 + Math.sin((angles[1] -90) * RADIAN) * lw_2,
                y21:Number = y2 - Math.sin((angles[1] -90) * RADIAN) * lw_2,
                x30:Number = x3 + Math.cos((angles[2] -90) * RADIAN) * lw_2,
                x31:Number = x3 - Math.cos((angles[2] -90) * RADIAN) * lw_2,
                y30:Number = y3 + Math.sin((angles[2] -90) * RADIAN) * lw_2,
                y31:Number = y3 - Math.sin((angles[2] -90) * RADIAN) * lw_2,
                x40:Number = x4 + Math.cos((angles[3] -90) * RADIAN) * lw_2,
                x41:Number = x4 - Math.cos((angles[3] -90) * RADIAN) * lw_2,
                y40:Number = y4 + Math.sin((angles[3] -90) * RADIAN) * lw_2,
                y41:Number = y4 - Math.sin((angles[3] -90) * RADIAN) * lw_2;
                
            graphics.moveTo(x10, y10);
            graphics.lineTo(x11, y11);
            graphics.lineTo(xx2, yy2);
            graphics.lineTo(x20, y20);
            graphics.lineTo(x21, y21);
            graphics.lineTo(xx3, yy3);
            graphics.lineTo(x30, y30);
            graphics.lineTo(x31, y31);
            graphics.lineTo(xx4, yy4);
            graphics.lineTo(x40, y40);
            graphics.lineTo(x41, y41);
            graphics.lineTo(xx1, yy1);
            graphics.lineTo(x10, y10);
            graphics.endFill();
        }
        private function mogero():void
        {
            
        }
        
    }

}