/**
 * Copyright wh0 ( http://wonderfl.net/user/wh0 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/tOH3
 */

package {
    import flash.external.ExternalInterface;
    import com.actionscriptbible.Example;
    public class FlashTest extends Example {
        public function FlashTest() {
            var tag:XML = <tag foo="ffff" bar="2 + 4" />;
            var obj:Object = {ffff: 'foo'};
            
            // attribute values are not strings
            trace(tag.@foo is String); // false
            
            // sometimes you can use them as keys
            trace(tag.@foo in obj); // true
            trace(obj[tag.@foo]); // foo
            
            // sometimes you can't
            try {
                delete obj[tag.@foo];
            } catch (e:Error) {
                trace(e); // TypeError: Error #1119
                // 1119 isn't even a legitimate runtime error code...
                // http://help.adobe.com/en_US/FlashPlatform/reference/actionscript/3/runtimeErrors.html
            }
            
            // delete, why you gotta be like that?
            delete obj[tag.@foo.toString()];
            trace(tag.@foo in obj); // false
            
            // P. S., sending XML stuff through ExternalInterface doesn't, like, escape it or whatever
            // allow script access to see this test
            try {
                ExternalInterface.call('alert', tag.@bar); // 6
                ExternalInterface.call('alert', tag.@bar.toString()); // 2 + 4
            } catch (e:Error) {
                trace(e); // sandbox violation when viewing in Wonderfl
            }
        }
    }
}