/**
 * Copyright undo ( http://wonderfl.net/user/undo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/tO8p
 */

package
{
    import flash.net.URLRequest;
    import flash.net.navigateToURL;
    import flash.display.Sprite;
    import flash.events.KeyboardEvent;
    import flash.events.TimerEvent;
    import flash.geom.Point;
    import flash.text.TextField;
    import flash.text.TextFormat;
    import flash.ui.Keyboard;
    import flash.utils.Timer;
    import flash.utils.getTimer;
    import flash.utils.setTimeout;
    import flash.utils.escapeMultiByte;   
    
    import flashx.textLayout.formats.TextAlign;
    
    [SWF(frameRate="60", width="465", height="465")]
    public class Setsuna extends Sprite
    {
        public function Setsuna()
        {
            init();
        }
        
        private var _tf:TextField;
        private var _state:String = 'title';
        private var _point:Point;
        private var _timer:Timer;
        private var _startTime:Number = 0;
        private var _resultTime:String = '';
        
        private var _keyEnabled:Boolean = false;
        
        private function init():void
        {
            createItems();
            events();
            
            gameInit();
            _state = 'title';
            _keyEnabled = true;
        }
        
        private function createItems():void
        {
            _tf = addChild(new TextField()) as TextField;
            _tf.width = _tf.height = 465;
            var tf:TextFormat = new TextFormat('_sans',null,null,null,null,null,null,null,TextAlign.CENTER);
            _tf.defaultTextFormat = tf;
            _tf.selectable = false;
            _tf.wordWrap = true;
            _tf.multiline = true;
            
            _point = new Point();
        }
        
        private function events():void
        {
            stage.addEventListener(KeyboardEvent.KEY_DOWN, onKeyDown);
        }
        
        private function gameInit():void
        {
            _tf.text = '"！！"が出たらキーを押すゲーム\nひとりモードならどのキーでもOK\n対戦モードでは1P：AかQか←　2P：LかPか→　お手つきは相手のポイント\n\nA：ひとりモード\n\nB：対戦モード\n\nEscキー：タイトルにもどる';
            _point = new Point();
        }
        
        private function startGame():void
        {
            _timer = new Timer(Math.random()*10000 + 1000, 1);
            _timer.addEventListener(TimerEvent.TIMER, onTimer);
            switch(_state)
            {
                case '1p':
                    _tf.text = '';
                    break;
                case '2p':
                    _tf.text = '1P：A or Q or ←\n2P：L or P or →';
                    break;
            }
            _tf.appendText('\n\n\n\n\nReady!!');
            setTimeout(onReady, 2000);
            _keyEnabled = false;
        }
        
        private function onReady():void
        {
            switch(_state)
            {
                case '1p':
                    _tf.text = '';
                    _state = '1pReady';
                    break;
                case '2p':
                    _tf.text = '1P：A or Q or ←\n2P：L or P or →';
                    _state = '2pReady';
                    break;
            }
            
            _timer.start();
            _keyEnabled = true;
        }
        
        private function onTimer(evt:TimerEvent):void
        {
            _timer.stop();
            _timer.removeEventListener(TimerEvent.TIMER, onTimer);
            
            _tf.appendText('\n\n\n\n\n！！');
            switch(_state)
            {
                case '1pReady':
                    _state = '1pTriggerd';
                    break;
                case '2pReady':
                    _state = '2pTriggerd';
                    break;
            }
            _startTime = getTimer();
        }
        
        private function onKeyDown(evt:KeyboardEvent):void
        {
            if(!_keyEnabled) return;
            
            switch(_state)
            {
                case 'title':
                    if(evt.keyCode == Keyboard.A)
                    {
                        _state = '1p';
                        startGame();
                    }
                    else if(evt.keyCode == Keyboard.B)
                    {
                        _state = '2p';
                        startGame();
                    }
                    break;
                
                case '1pReady':
                    fail(0);
                    break;
                case '1pTriggerd':
                    check(0);
                    break;
                
                case '2pReady':
                    if(evt.keyCode == Keyboard.A
                        || evt.keyCode == Keyboard.Q
                        || evt.keyCode == Keyboard.LEFT
                        )
                    {
                        fail(1);
                    }
                    else if(evt.keyCode == Keyboard.L
                        || evt.keyCode == Keyboard.P
                        || evt.keyCode == Keyboard.RIGHT
                        )
                    {
                            fail(2);
                    }
                    break;
                
                case '2pTriggerd':
                    if(evt.keyCode == Keyboard.A
                        || evt.keyCode == Keyboard.Q
                        || evt.keyCode == Keyboard.LEFT
                    )
                    {
                        check(1);
                    }
                    else if(evt.keyCode == Keyboard.L
                        || evt.keyCode == Keyboard.P
                        || evt.keyCode == Keyboard.RIGHT
                    )
                    {
                        check(2);
                    }
                    break;
                
                case '1pResult':
                    if(evt.keyCode == Keyboard.ESCAPE)
                    {
                        _state = 'title';
                        gameInit();
                    }
                    else if(evt.keyCode == Keyboard.T)
                    {
                        var req:URLRequest = new URLRequest();
                        req.url = 'https://twitter.com/intent/tweet?text=' + escapeMultiByte('刹那の見切りで' + _resultTime + '秒を叩き出しました。') + '&url=http://wonderfl.net/c/tO8p&hashtags=setsuna';
                        navigateToURL(req, '_blank');
                    }
                    else
                    {
                        _state = '1p';
                        startGame();
                    }
                    break;
                
                case '2pResult':
                    if(evt.keyCode == Keyboard.ESCAPE)
                    {
                        _state = 'title';
                        gameInit();
                    }
                    else
                    {
                        _state = '2p';
                        startGame();
                    }
                    break;
            }
        }
        
        private function fail(type:int):void
        {
            _timer.stop();
            _timer.removeEventListener(TimerEvent.TIMER, onTimer);
            
            _keyEnabled = false;
            
            switch(type)
            {
                case 0:
                    _point = new Point();
                    _tf.text = 'miss!\n\npress any key';//\n\n'+_point.x+'combo';
                    _state = '1pResult';
                    break;
                case 1:
                    _point.y ++;
                    _tf.text = '1P miss!\n\n1P：'+ _point.x + '\n2P：' + _point.y;
                    _state = '2pResult';
                    break;
                case 2:
                    _point.x ++;
                    _tf.text = '2P miss!\n\n1P：'+ _point.x + '\n2P：' + _point.y;
                    _state = '2pResult';
                    break;
            }
            
            setTimeout(function():void{ _keyEnabled = true; }, 1000);
            
        }
        
        private function check(type:int):void
        {
            _keyEnabled = false;
            _resultTime =  String(Math.floor((getTimer() - _startTime)/10)/100);
            
            switch(type)
            {
                case 0:
                    _point.x ++;
                    _tf.text = 'good!\n\ntime:' + _resultTime + 'sec\n\nt：つぶやく\nEsc：タイトルへ\nother：リトライ';//\n\n'+_point.x+'combo';
                    _state = '1pResult';
                    break;
                case 1:
                    _point.x ++;
                    _tf.text = '1P win!\ntime:' + _resultTime + 'sec\n\n1P：'+ _point.x + '\n2P：' + _point.y;
                    _state = '2pResult';
                    break;
                case 2:
                    _point.y ++;
                    _tf.text = '2P win!\ntime:' + _resultTime + 'sec\n\n1P：'+ _point.x + '\n2P：' + _point.y;
                    _state = '2pResult';
                    break;
            }
            
            setTimeout(function():void{ _keyEnabled = true; }, 1000);
        }
            
    }
}