/**
 * Copyright vlad.el.rojo ( http://wonderfl.net/user/vlad.el.rojo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/tMNc
 */

// forked from jozefchutka's Game of life
// Conway's Game of Life http://en.wikipedia.org/wiki/Conway's_Game_of_Life
// field 38x38 px

package{
    import flash.display.Sprite;
    
    public class GameOfLife extends Sprite{
        public function GameOfLife(){
            with(x)
            for each(i in w=h=38,a=new Array(w*h),b=[63,99,101,127,128,135,136,
                149,150,164,168,173,174,187,188,191,192,201,207,211,212,229,230,
                239,243,245,246,251,253,277,283,291,316,320,355,356])
                a[i]=1;
            addEventListener("enterFrame",function():void{
                with(graphics){
                for(clear(),c=[i=0];i<w*h;i++)
                    X=i%w,Y=int(i/w),j=X-1,k=X+1,l=Y-1,m=Y+1,
                    n=int(j>-1&&l>-1?a[i-37]:0)
                    +int(l>-1?a[i-w]:0)
                    +int(k<w&&l>-1?a[i-39]:0)
                    +int(j>-1?a[i-1]:0)
                    +int(k<w?a[i+1]:0)
                    +int(j>-1&&m<h?a[i+37]:0)
                    +int(m<h?a[i+w]:0)
                    +int(k<w&&m<h?a[i+39]:0),
                    c[i]=a[i]?(n==2||n==3)?1:0:int(n==3),
                    a[i]?drawRect(X*10,Y*10,10,10):beginFill(0);
                    a=c;
                }
            });
        }
    }
}