/**
 * Copyright lizhi ( http://wonderfl.net/user/lizhi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/tLwH
 */

// forked from sliz's car
package {
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Shape;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.KeyboardEvent;
	import flash.events.MouseEvent;
	import flash.geom.ColorTransform;
	import flash.geom.Point;
	import flash.ui.Keyboard;
	import flash.utils.getTimer;
	import sliz.miniui.Radio;
	import sliz.miniui.RadioGroup;
	import sliz.miniui.ToggleButton;

	/**
	 * ...
	 * @author sliz http://game-develop.net/blog/
	 */
	public class Test2 extends Sprite {
		private var w:int = stage.stageWidth, h:int = stage.stageHeight;
		private var acc:int = 1000;
		private var maxSpeed:int = 60;
		private var maxBakSpeed:int = 20;
		private var rotSpeed:int = 2;

		private var lastPos:Point = new Point(100, 100);
		private var pos:Point = new Point(100, 100);
		private var vel:Point = new Point(0, 0);
		private var dir:Point = new Point(0, 1);
		private var lastUpdate:int = getTimer();


		private var isUp:Boolean = false;
		private var isLeft:Boolean = false;
		private var isRight:Boolean = false;
		private var isDown:Boolean = false;

		private var that:Shape = new Shape();
		private var pen:Shape = new Shape();
		private var roadLayer:BitmapData = new BitmapData(w, h, true, 0x00ffffff);
		
		private var map:BitmapData = new BitmapData(w, h, false, 0xffffff);
		private var mapEdit:Sprite = new Sprite();
		private var drawBtn:ToggleButton;
		private var clearBtn:ToggleButton;

		public function Test2(){
			addEventListener(Event.ENTER_FRAME, update);
			addChild(new Bitmap(map));
			drawBtn = new Radio("draw", 10, 10, this);
			drawBtn.setToggle(true);
			clearBtn = new Radio("clear", 10, 30, this);
			new RadioGroup([drawBtn, clearBtn]);
			stage.addEventListener(MouseEvent.MOUSE_DOWN, onMD);
			
			stage.addEventListener(KeyboardEvent.KEY_DOWN, onKeyDown);
			stage.addEventListener(KeyboardEvent.KEY_UP, onKeyUp);
			addChild(new Bitmap(roadLayer));
			addChild(that);
			that.graphics.lineStyle(0);
			that.graphics.moveTo(10, 0);
			that.graphics.lineTo(-10, 4);
			that.graphics.lineTo(-10, -4);
			that.graphics.lineTo(10, 0);
			
		}
		
		private function onMD(e:MouseEvent):void 
		{
			stage.addEventListener(MouseEvent.MOUSE_UP, onMU);
			stage.addEventListener(MouseEvent.MOUSE_MOVE, onMM);
			mapEdit.graphics.moveTo(mouseX, mouseY);
		}
		
		private function onMU(e:MouseEvent):void 
		{
			stage.removeEventListener(MouseEvent.MOUSE_MOVE, onMM);
			stage.removeEventListener(MouseEvent.MOUSE_UP, onMU);
			mapEdit.graphics.clear();
		}
		
		private function onMM(e:MouseEvent):void 
		{
			if(drawBtn.getToggle()){
				mapEdit.graphics.lineStyle(50, 0xcccccc);
				mapEdit.graphics.lineTo(mouseX, mouseY);
				map.draw(mapEdit);
			}else if (clearBtn.getToggle()) {
				mapEdit.graphics.lineStyle(50, 0xffffff);
				mapEdit.graphics.lineTo(mouseX, mouseY);
				map.draw(mapEdit);
			}
		}

		private function onKeyUp(e:KeyboardEvent):void {
			switch (e.keyCode){
				case Keyboard.UP:
					isUp = false;
					break;
				case Keyboard.DOWN:
					isDown = false;
					break;
				case Keyboard.LEFT:
					isLeft = false;
					break;
				case Keyboard.RIGHT:
					isRight = false;
					break;
			}
		}

		private function onKeyDown(e:KeyboardEvent):void {
			switch (e.keyCode){
				case Keyboard.UP:
					isUp = true;
					isDown = false;
					break;
				case Keyboard.LEFT:
					isLeft = true;
					isRight = false;
					break;
				case Keyboard.RIGHT:
					isRight = true;
					isLeft = false;
					break;
				case Keyboard.DOWN:
					isDown = true;
					isUp = false;
					break;
			}
		}

		private function rotate(p:Point, angle:Number):void {
			var x:Number = p.x, y:Number = p.y;
			p.x = x * Math.cos(angle) - Math.sin(angle) * y;
			p.y = x * Math.sin(angle) + Math.cos(angle) * y;
		}

		private function update(e:Event):void {
			var forceChange:Boolean = false;
			var nowTime:int = getTimer();
			var tDelta:Number = (nowTime - lastUpdate) / 1000;
			lastUpdate = nowTime;

			if (isUp){
				vel = vel.add(new Point(dir.x * acc * tDelta, dir.y * acc * tDelta));
			} else if (isDown){
				vel = vel.add(new Point(-dir.x * acc * tDelta, -dir.y * acc * tDelta));
			} else {
				vel.x *= 0.96;
				vel.y *= 0.96;
			}

			if (isUp && vel.length > maxSpeed){
				vel.normalize(maxSpeed);
			} else if (isDown && vel.length > maxBakSpeed){
				vel.normalize(maxBakSpeed);
			}
			var rs:Number = rotSpeed * vel.length;
			if ((isLeft && isUp) || (isRight && isDown)){
				forceChange = true;
				rotate(dir, (rs * tDelta * -1) * Math.PI / 180);
			} else if ((isRight && isUp) || (isLeft && isDown)){
				forceChange = true;
				rotate(dir, rs * tDelta * Math.PI / 180);
			}
			pos = pos.add(new Point(vel.x * tDelta, vel.y * tDelta));
			if (map.getPixel(pos.x,pos.y)!=0xffffff||(pos.x < 0 && vel.x < 0) || (pos.x > w && vel.x > 0) || (pos.y < 0 && vel.y < 0) || (pos.y > h && vel.y > 0)){
				vel.x = vel.y = 0;
				pos.x = lastPos.x;
				pos.y = lastPos.y;
			}

			that.x = pos.x;
			that.y = pos.y;
			that.rotation = Math.atan2(dir.y, dir.x) * 180 / Math.PI;

			pen.graphics.clear();
			pen.graphics.lineStyle(0, 0x999999);
			pen.graphics.moveTo(lastPos.x, lastPos.y);
			pen.graphics.lineTo(pos.x, pos.y);
			roadLayer.draw(pen);
			roadLayer.colorTransform(roadLayer.rect, new ColorTransform(1, 1, 1, 1, 0, 0, 0, -1));

			lastPos.x = pos.x;
			lastPos.y = pos.y;
		}
	}
}