/**
 * Copyright tepe ( http://wonderfl.net/user/tepe )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/tLkG
 */

// forked from tepe's forked from: forked from: forked from: flash on 2014-5-19
// forked from tepe's forked from: forked from: flash on 2014-5-19
// forked from tepe's forked from: flash on 2014-5-19
//汎用ウィンドウクラスを作る
package{
    import flash.display.*;
    import flash.ui.*;
    import flash.text.*;
    import flash.events.*;
    public class Main extends Sprite{
        
        public function Main(){
            
            var wPanel:WindowPanel = new WindowPanel();
            addChild(wPanel);
            //wPanel.x = 100;
            //wPanel.y = 200;
            var tf:TextField = new TextField();
            tf.text = "test";
            tf.type = "input";
            tf.multiline = true;
            wPanel.target = tf;
            wPanel.title = "title";
            var wp2:WindowPanel = new WindowPanel(ui);

            var node:TreeNode = new TreeNode();
            node.name="test";
            node.createPath("a/b/c/d");
            node.createNode("test2\naaaaa");
            node.createNode("test3\nggg\nhhh");
            node.createNode("test3\nggg\nhhh");
            var node2:TreeNode = new TreeNode();
            node2.name ="a";
            node2.createPath("aiu/eo/kakiku/keko");
            node2.createPath("aiu/eo/kakiku/keko2");
            node2.addNode(node);
            var ui:TreeUI = node2.createUI();
            addChild(node2.createUI());
            ui.addEventListener(MouseEvent.CLICK,function(e:MouseEvent):void{
                if(e.target.parent is TreeNodeUI){
                    tf.text = e.target.parent.node.toString()+"\n";
                }
                tf.appendText(e.target.toString());

            });
            ui.x = 200;
            
            addChild(ui);

            // コンテキストメニューオブジェクトを作成
            var context_menu:ContextMenu = new ContextMenu();

            // メニューアイテムを作成
            var menu_item1:ContextMenuItem = new ContextMenuItem("表示テスト１");
            var menu_item2:ContextMenuItem = new ContextMenuItem("表示テスト２");

            // メニューアイテムを登録
            context_menu.customItems = [menu_item1 , menu_item2];
            ui.contextMenu = context_menu;
        }
        
    }

}

import flash.display.*;
import flash.events.*;
import flash.text.*;
class WindowPanel extends Sprite{
    private var _title:String = "";
    private var _mx:Number = 20;
    private var _my:Number = 10;
    private var _target:DisplayObject;
    private var _tf:TextField;
    public function WindowPanel(o:DisplayObject=null){
        if(o!=null)target=o;
        draw();
        addEventListener(MouseEvent.MOUSE_MOVE,onMove);
        addEventListener(MouseEvent.MOUSE_OUT,onOut);
        addEventListener(MouseEvent.MOUSE_DOWN,onDrag);
        addEventListener(MouseEvent.MOUSE_UP,onDrop);
    }
    public function set target(o:DisplayObject):void{
        _target = o;
        addChild(o);
        x = o.x;
        y = o.y;
        o.x=0;
        o.y=0;
        
        draw();
    }
    
    public function set title(t:String):void{
        _title = t;
        draw();
    }


    //タイトル表示
    private function initTF():void{
        _tf = new TextField();
        _tf.text = _title;
        _tf.y = -_my;
        _tf.selectable = false;
        _tf.width = _tf.textWidth+5;
        _tf.height = _tf.textHeight+5;
        addChild(_tf);
    }

    //ウィンドウ更新
    public function draw(c:uint=0x000000,a:Number=0.2):void{
        initTF();
        var w:Number,h:Number;
        if(_target==null){w=this.width;h=this.height;}
        else{ 
            w=_target.width;h=_target.height;
            this.x += _target.x;
            this.y += _target.y;
            _target.x = 0;
            _target.y = 0;
        }
        
        this.graphics.clear();
        this.graphics.lineStyle(0,0x0,a);
        this.graphics.beginFill(c,a);
        this.graphics.drawRect(-_mx,-_my,w+_mx*2,h+_my*2);
        this.graphics.endFill();
    }
    
    private function onOut(e:MouseEvent):void{
        Mouse.cursor = MouseCursor.AUTO;
    }

    private function onMove(e:MouseEvent):void{
        if(e.target == this)Mouse.cursor = MouseCursor.HAND;
        else Mouse.cursor = MouseCursor.AUTO;
    }

        
    private function onDrag(e:MouseEvent):void{
        if(e.target == this){
            this.startDrag();
        }
        draw();
        e.currentTarget.parent.setChildIndex(e.currentTarget,e.currentTarget.parent.numChildren-1); //並べ替え
    }
    private function onDrop(e:MouseEvent):void{
        this.stopDrag();
        draw();
    }
}



import flash.events.*;
import flash.text.*;
import flash.display.*;
import flash.geom.*;
import flash.ui.*;

    class TreeUI extends WindowPanel{
        
        
        private var rootTree:TreeNode = new TreeNode();
        private var treeUI:Sprite = new Sprite();
        private var pen:Pen = new Pen(treeUI.graphics,0x444444);
        public function TreeUI(){
            this.target = treeUI;
            rootTree.name="/"
            rootTree.closed = false;
            render();
        }
        
        public function set node(tree:TreeNode):void{
            rootTree = tree;
            render();            
        }

        
        //描画処理
        public function render():void {
            treeUI.graphics.clear();
            while (treeUI.numChildren > 0) treeUI.removeChildAt(0);
            renderCell(rootTree, 0, 0);//ノード描画
            draw();
        }
        
        private function renderCell(tree:TreeNode, x:Number, y:Number):Number {
            var sy:Number = y;
            var tui:TreeNodeUI = new TreeNodeUI(tree, x, y,this);
            var h:Number = tui.height;
            treeUI.addChild(tui);
            
            y += h+5;
            if (!tree.closed) {//子リストの描画
                var n:Number = 10;
                var vx:Number = x + 7;
                var vy:Number = y;
                
                for each(var child:TreeNode in tree.list) {
                    //pen.moveTo(vx, y+10);
                    pen.moveTo(vx, y+n);
                    pen.lineTo(vx + 10, y + n);//横線
                    //vy = y+10;
                    vy = y+n;
                    y = renderCell(child, x + 20, y);//子リスト
                }
                if(0<tree.list.length){
                    pen.moveTo(vx, sy+15);
                    pen.lineTo(vx, vy);//縦線
                }
            }
            return y;
        }
    }
    



import com.bit101.components.PushButton;

class TreeNodeUI extends Sprite{
    public var node:TreeNode;
    public var treeUI:TreeUI;
    private var _minBtn:PushButton;
    public var tf:TextField;
    
    public function TreeNodeUI(_node:TreeNode,x:Number,y:Number,main:TreeUI) {
        node = _node;
        treeUI = main;
        
        
        tf = new TextField();
        tf.autoSize = "left";
        tf.text = node.name;
        tf.backgroundColor = 0xffffff;
        tf.addEventListener(MouseEvent.MOUSE_OVER,function():void{
            tf.border=true;
            tf.background = true;
        });
        tf.addEventListener(MouseEvent.MOUSE_OUT,function():void{
            tf.border=false;
            tf.background = false;
        });

        //tf.background =true;
        //tf.border=true;
        tf.selectable=false;

        addChild(tf);
        if(0<node.length){
            _minBtn = createMinBtn(); 
            addChild(_minBtn);
            tf.x = _minBtn.width+2;
        }
        
        this.x = x;
        this.y = y;
    }
    

    
    //最小化ボタン
    private function createMinBtn():PushButton {
        var result:PushButton = new PushButton(null, 0, 3, "+", minimize);
        result.width = result.height = 14; result.draw();
        result.addEventListener(MouseEvent.CLICK,minimize);
        result.label = (node.closed) ? "+" : "-"; 
        return result;
    }
    
    private function minimize(event:MouseEvent = null):void {
        node.closed = !node.closed;
        treeUI.render();
        if (_minBtn) { 
            _minBtn.label = (node.closed) ? "-" : "+"; 
        }
    }
    
}

class TreeNode {
    
    public static var ID:int = 0;
    public var parent:TreeNode;//親
    public var closed:Boolean = true;//展開状態
    public var name:String = "node" + (ID++);//表示名
    private var _children:Vector.<TreeNode>;//子リスト
    
    public function TreeNode(str:String=null){
        if(str!=null)name=str;
        _children= new Vector.<TreeNode>;
    }

    public function get length():int{
        return _children.length;
    }
    
    //TreeUI生成
    public function createUI():TreeUI{
        var ui:TreeUI = new TreeUI();
        ui.node = this;
        return ui;
    }


    
    public function get list():Vector.<TreeNode>{
        //createChild();
        return _children;
    }
    
    //名前を指定してノード取得
    public function getNode(n:String=null):TreeNode{
        for(var i:int=0;i<_children.length;i++){
            if(_children[i].name==n)return _children[i];
        }
        return null;
    }


    //ノードを追加
    public function addNode(t:TreeNode):void{
        _children.push(t);
    }
    //ノード生成
    public function createNode(str:String):void{
        var node:TreeNode = new TreeNode(str);
        _children.push(node);
    }
    //パスを指定して生成する
    public function createPath(path:String):void{
        var ar:Array = path.split("/");
        var node:TreeNode = this;
        for(var i:int=0;i<ar.length;i++){
            
            //指定されたツリーが存在しなければ生成。存在すればそのまま
            if(node.getNode(ar[i])==null)node.createNode(ar[i]);
            node = node.getNode(ar[i]);
        }

    }



}

class Pen{
    
        private var g:Graphics;
        private var sx:Number;
        private var sy:Number;
        private var color:uint;
        public function Pen(g:Graphics,c:uint=0x000000){
            this.g = g;
            this.color = c;
        }
        public function moveTo(x:Number, y:Number):void {
            g.moveTo(x, y);
            sx = x;
            sy = y;
        }
        
        public function lineTo(x:Number, y:Number):void {
            g.lineStyle(0,color);
            g.lineTo(x, y);
            sx = x;
            sy = y;
        }
    }

