/**
 * Copyright rettuce ( http://wonderfl.net/user/rettuce )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/tLVo
 */

package 
{
    import flash.display.Sprite;
    import flash.events.Event;
	[SWF(width = 800, height = 800, backgroundColor = 0xFFFFFF, frameRate = 20)]
    /**
     * ...
     * @author 
     */
    public class Main extends Sprite 
    {
        public function Main():void 
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }

        private var bd:birdoid;
        private function init(e:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);

			bd  =   new birdoid( stage.stageWidth, stage.stageHeight );
            addChild(bd);
			addEventListener(Event.ENTER_FRAME, enterFrame);
        }
        //
        private function enterFrame(e:Event):void 
        {   //  フレーム毎に点を動かす
            bd.move();
        }
    }
}


    import flash.display.Shape;
	import flash.display.Graphics;
	import flash.geom.Point;

    class birdoid extends Shape
    {
        public static const point_length:int = 100; //  個体数
		public static const rad:int = 3 ; // 個体サイズ
        private var objs:Array; // 個体収容配列
        var sw:Number; // stageサイズ - 個体サイズ
        var sh:Number;
		
        //  birdoidクラスのコンストラクタ
        public function birdoid(w:Number, h:Number) 
        {
			sw = w - rad*2 ;
			sh = h - rad*2 ;			
			this.x = this.y = rad;
			
            objs = new Array();
            for (var i:int = 0; i < point_length; i++)
            {
                objs.push(newPoint( sw , sh ));   // 点を登録
            }
			draw();   // 点を描画
        }
		
		public function newPoint(w:Number, h:Number):Object //任意の位置とスピードを持つ点
		{
			var one:Object = new Object();
			var r:Number = Math.random() * Math.PI * 2.0;

			var p:Point = new Point(Math.random() * w, Math.random() * h );
			var s:Point = new Point(Math.cos(r)*3, Math.sin(r)*3 );

			one.p = p;
			one.s = s;
			return one;
		}		
		
		//  全ての点を描画
        public function draw():void 
        {
            for (var i:int = 0; i < point_length; i++)
            {
				graphics.beginFill(0x000099);   //  ちょっと暗めの青
				graphics.drawCircle(objs[i].p.x, objs[i].p.y, rad)
            }
        }

		//  全ての点を動かす
		public function move():void 
		{
			for (var i:int = 0; i < point_length; i++)
			{
				var one:Object = objs[i];
				
				for (var ii:int = i+1; ii < point_length; ii++)
				{
					var next:Object = objs[ii];
					var dis:Number = Point.distance(one.p,next.p);
				}
				
				one.p.offset(one.s.x,one.s.y); //poin位置にスピード分加算
				if(one.p.x < 0 || one.p.x > sw){ one.s.x = -one.s.x; }
				if(one.p.y < 0 || one.p.y > sh){ one.s.y = -one.s.y; }

				graphics.clear();
			}
			draw();
		}
		
		//  点同士の距離を計る
		public function research():void 
		{
			var distance_arr:Array;
			for (var i:int = 0; i < point_length; i++)
			{
				var one:Object = objs[i];
				
				for (var ii:int = i+1; ii < point_length; ii++)
				{
					var next:Object = objs[ii];
					
//					var dis:Number = Point.distance(one.p,next.p);
					var d:Number = one.p.subtract(next.p).length;

				}
				
/*				
				if(Point.distance(one.p,next.p) < 10)
				{
					
				};
				//trace(distance_arr);
				
				one.p.offset(one.s.x,one.s.y); //poin位置にスピード分加算
				if(one.p.x < 0 || one.p.x > sw){ one.s.x = -one.s.x; }
				if(one.p.y < 0 || one.p.y > sh){ one.s.y = -one.s.y; }
*/
			}
		}
		
    }

