/**
 * Copyright agenda23 ( http://wonderfl.net/user/agenda23 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/tKsB
 */

/*
japaninoと測距センサで球体に気のエネルギーを送ってる感じのテスト2

attention : standardfirmata使用

usage : japaninoと測距センサを二つ用意してjapaninoのアナログ入力0と2にそれぞれの出力をつなぐ。
        再生して球体が表示されたらおもむろに測距センサに手などをかざしてみる。
        入力2につないだセンサはx,y軸の回転速度に影響する。
        入力0のセンサは頂点の移動距離に影響する。
        
        もろもろつながってないとなんのこっちゃわからんので
        デバイスが見つからない場合、
        スライダで値を入力できるようにした。
        
        操作デモ動画うｐしました。

 */
package
{
    import com.bit101.components.TextArea;
    import flash.display.*;
    import flash.events.*;
    import flash.text.*;
    import flash.geom.*;
    import flash.filters.*;
    import flash.utils.*;
    
    import org.papervision3d.core.geom.renderables.Vertex3D;
    import org.papervision3d.cameras.Camera3D;
    import org.papervision3d.render.BasicRenderEngine;
    import org.papervision3d.scenes.Scene3D;
    import org.papervision3d.view.Viewport3D;
    import org.papervision3d.view.layer.*;
    import org.papervision3d.objects.primitives.*;
    import org.papervision3d.materials.*;
    import org.papervision3d.materials.special.CompositeMaterial;
    import org.papervision3d.core.effects.*;
    import org.papervision3d.core.effects.utils.*;
    
    import net.kawa.tween.*;
    import net.kawa.tween.easing.*;
    
    import com.bit101.components.*;
    
    import net.hires.debug.Stats;    
    
    import funnel.*;
    import funnel.gui.*;
    
    


    [SWF(frameRate=60,backgroundColor=0x000000) ]

    public class PV2_ver2 extends Sprite
    {
        private var scene:Scene3D;
        private var viewport:Viewport3D;
        private var camera:Camera3D;
        private var renderer:BasicRenderEngine;
        private var objSphere:Sphere;
        private var isTween:Boolean;
        
        private var _japanino:Arduino;

        private var pin0:Pin;
        private var pin2:Pin;
        private var pin0_tf:TextField;
        private var pin2_tf:TextField;
        private var pin0_value:Number = 1.01;
        private var pin2_value:Number = 1.01;
        
        private var slider1:HSlider;
        private var slider2:HSlider;
        private var slider1_value:Number;
        private var slider2_value:Number;
        
        private var funnelrestxt:TextField;
        
        private var num:Number = 0;
        

        public function PV2_ver2()
        {
        /*
         * 
         * japanino 初期化
         * 
         */
            //configを用意
            var config:Configuration = Arduino.FIRMATA;
            //7〜13番PINをデジタル出力に設定
            for (var i:int = 7; i <= 13; i++)
            {
                config.setDigitalPinMode(i, Pin.DOUT);
            }
            
            //Japanino生成
            _japanino = new Arduino(config);
            
            
            
            _japanino.addEventListener(FunnelEvent.READY, onFunnelReady);
            
            

            
            //各アナログ入力イベント登録
            pin0 = _japanino.analogPin(0);
            pin0.addFilter(new Scaler(0, 0.6, 1, 3, Scaler.LINEAR, false));
            pin0.addFilter(new Convolution(Convolution.MOVING_AVERAGE));
            //pin0.addEventListener(PinEvent.CHANGE, pin0_change);
            
            pin2 = _japanino.analogPin(2);
            pin2.addFilter(new Scaler(0, 0.6, 1, 3, Scaler.LINEAR, false));
            pin2.addFilter(new Convolution(Convolution.MOVING_AVERAGE));
            //pin2.addEventListener(PinEvent.CHANGE, pin2_change);
            
            setTimeout(function():void {
                if (pin0.value == 0) {
                        funnelrestxt = new TextField();
                        addChild(funnelrestxt);
                        funnelrestxt.text = " Connection failed. \n Activate GUI input.";
                        funnelrestxt.width = 240;
                        funnelrestxt.x = 5;
                        funnelrestxt.y = 120;
                        funnelrestxt.textColor = 0x08FF10;
                        setTimeout(
                                    function():void { 
                                    removeChild(funnelrestxt); 
                                    _japanino.removeEventListener(FunnelEvent.READY, onFunnelReady);
                                    _japanino.removeEventListener(PinEvent.CHANGE, pin0_change);
                                    _japanino.removeEventListener(PinEvent.CHANGE, pin2_change);
                                    initGui();
                                }
                                ,3000);
                    }
                },5000);
            
        /*
         * 
         * pv3d 初期化
         * 
         */            
            
            stage.align = StageAlign.TOP_LEFT;
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.quality = StageQuality.LOW;
            init3D();
            
            
            //テキストフィールド生成
            pin0_tf = new TextField();
            pin2_tf = new TextField();

            addChild(pin0_tf);
            addChild(pin2_tf);
            
            //テキストフィールド設定
            pin0_tf.x = 5;
            pin0_tf.y = 120;
            pin0_tf.width = 240;
            pin0_tf.textColor = 0x08FF10;
            
            pin2_tf.x = 5;
            pin2_tf.y = 135;
            pin2_tf.width = 240;
            pin2_tf.textColor = 0x08FF10;
            

            addChild(new Stats( { bg: 0x1A1A1A } ));
            
        }

        private function init3D():void
        {
            viewport = new Viewport3D(0,0,true);
            viewport.opaqueBackground = 0x000000;
            addChild(viewport);

            
            
            renderer = new BasicRenderEngine();

            camera = new Camera3D();
            camera.z = -300;
            camera.focus = 500;
            camera.zoom = 1;

            scene = new Scene3D();

            var colorMat:ColorMaterial = new ColorMaterial( 0x000000, 1 );
            var wireMat:WireframeMaterial = new WireframeMaterial( 0x08FF10 );
            var compoMat:CompositeMaterial = new CompositeMaterial();
            compoMat.addMaterial(colorMat);
            compoMat.addMaterial(wireMat);
            compoMat.doubleSided = true;

            objSphere = new Sphere(compoMat, 80, 10, 10 );
            
            
            scene.addChild(objSphere);
            
            
            
            
            addEventListener(Event.ENTER_FRAME, onEnterFrame);
            
            renderer.renderScene(scene, camera, viewport);
            
            //移動前の頂点座標を保持
            for each(var i:* in objSphere.geometry.vertices) {
                i.extra = { x0 : i.x, y0 : i.y, z0 : i.z };
            }    
        }
        
        private function initGui():void {
            var slider1_label:TextField = new TextField();
            addChild(slider1_label);
            slider1_label.text = "analog pin 0 value[vertex motion]";
            slider1_label.width = 240;
            slider1_label.x = 5;
            slider1_label.y = 110;
            slider1_label.textColor = 0x08FF10;
            
            var slider2_label:TextField = new TextField();
            addChild(slider2_label);
            slider2_label.text = "analog pin 2 value[rotation speed]";
            slider2_label.width = 240;
            slider2_label.x = 5;
            slider2_label.y = 140;
            slider2_label.textColor = 0x08FF10;
            
            slider1 = new HSlider(this, 5, 130, onChange);
            slider1.minimum = 100;
            slider1.maximum = 350;
            slider1.width = 120;
            slider2 = new HSlider(this, 5, 160, onChange);
            slider2.minimum = 100;
            slider2.maximum = 350;
            slider2.width = 120;
            
        }
        private function onChange(event:Event):void {
            pin0_value = slider1.value / 100;
            pin2_value = slider2.value / 100;
        }
        
        private function onFunnelReady(evt:FunnelEvent):void
        {
            funnelrestxt = new TextField();
            addChild(funnelrestxt);
            funnelrestxt.text = " Connection succeed.";
            funnelrestxt.width = 240;
            funnelrestxt.x = 5;
            funnelrestxt.y = 120;
            funnelrestxt.textColor = 0x08FF10;
            setTimeout(
                    function():void { 
                        removeChild(funnelrestxt); 
                        
                        //japaninoとの接続が完了し、準備ができました。
                        _japanino.removeEventListener(FunnelEvent.READY, onFunnelReady);
                        
                        pin0.addEventListener(PinEvent.CHANGE, pin0_change);
                        pin2.addEventListener(PinEvent.CHANGE, pin2_change);
                        
                    }
                    ,3000);
            
            
        }


        private function onEnterFrame(event:Event):void
        {
                objSphere.rotationY += pin2_value;
                objSphere.rotationX += pin2_value;
                objSphere.rotationZ += 1;
                
                    //頂点移動
                    if (num < objSphere.geometry.vertices.length){
                        KTween.from(objSphere.geometry.vertices[num], 0.6, { 
                                                    x:objSphere.geometry.vertices[num].x * pin0_value, 
                                                    y:objSphere.geometry.vertices[num].y * pin0_value, 
                                                    z:objSphere.geometry.vertices[num].z * pin0_value
                                                    }, Quad.easeOut);
                        num++;
                    }else{
                        num = 0;
                    }

            renderer.renderScene(scene,camera,viewport);
        }
        
        private function pin0_change(evt:PinEvent):void
        {
            pin0_tf.text = "analog pin 0 input[vertex motion] : " + pin0_value;
            pin0_value = Math.round((Pin(_japanino.analogPin(0)).value) * 1000) / 1000;
        }
        private function pin2_change(evt:PinEvent):void
        {
            pin2_tf.text = "analog pin 2 input[rotation speed] : " + pin2_value;
            pin2_value = Math.round((Pin(_japanino.analogPin(2)).value) * 1000) / 1000;
        }
    }

}
