/**
 * Copyright Nicolas ( http://wonderfl.net/user/Nicolas )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/tKpK
 */

// forked from Nicolas's Sphereの頂点番号の表示 forked from: Pixel3Dの座標⇒普通のxy座標
// forked from sake's Pixel3Dの座標⇒普通のxy座標
/*
   プリミティブオブジェクトのどの頂点が頂点番号何番なのか今一分からないので、
   fork元のsakeさんのコードのShapeをTextFieldにして
   TextFieldの位置を各頂点の座標に合わせ、頂点番号を表示しました。
   クラス化してテスト用に使えるようにしたい。
   
   ↓
   
   一応クラス化しました。
   メインクラスに書くコードを最小限にとどめようと思ったらこうなりました。
   TextFormatとかいじれるようにする必要がありますね。　
 */

package
{
	import flash.events.ErrorEvent;
	import flash.text.TextField;
	import flash.display.Shape;
	import flash.display.StageQuality;
	import flash.events.Event;

	import org.papervision3d.core.effects.utils.BitmapClearMode;
	import org.papervision3d.view.layer.BitmapEffectLayer;
	import org.papervision3d.core.geom.Pixels;
	import org.papervision3d.core.geom.renderables.Pixel3D;
	import org.papervision3d.core.geom.renderables.Vertex3DInstance;
	import org.papervision3d.core.geom.renderables.Vertex3D;
	import org.papervision3d.materials.WireframeMaterial;
	import org.papervision3d.objects.primitives.*;
	import org.papervision3d.view.BasicView;
	

	[SWF(width="465", height="465", backgroundColor="0x000000", frameRate="40")]
	public class Main extends BasicView
	{
		private const RADIUS:int = 90;
		private var pixels:Pixels;
		private var sphere:Sphere;
		private var plane:Plane;

		// コンストラクタ
		public function Main()
		{
			// もろもろの準備
			stage.quality=StageQuality.HIGH;
			super(0, 0, true, true);
			camera.z=-500;
			
			//マテリアルの生成
			var material:WireframeMaterial = new WireframeMaterial(0xdddddd, 0.1, 1);
			material.doubleSided = true;
			
			//Sphereの生成
			sphere　=　new Sphere(material, Math.sqrt(RADIUS * RADIUS * 3), 10, 10);
			sphere.x = -130;
			sphere.y = 130;
			scene.addChild(sphere);
			
			//Planeの生成
			plane = new Plane(material, 250, 250, 4, 4);
			plane.x = 150;
			plane.y = -150;
			scene.addChild(plane);
			
			
			//VertexNumberViewerを使用します
			//sphere用
			var viewer1:VertexNumberViewer = addChild(new VertexNumberViewer(sphere)) as VertexNumberViewer;
			//plane用
			var viewer2:VertexNumberViewer = addChild(new VertexNumberViewer(plane)) as VertexNumberViewer;
			
			// Let's レンダリング！
			startRendering();
			addEventListener(Event.ENTER_FRAME, onFrame);
		}

		// エンターフレーム
		private function onFrame(e:Event):void
		{
			sphere.rotationX+=0.5;
			sphere.rotationY+=0.5;
			plane.rotationY += 2;
		}
	}
}

import flash.display.*;
import flash.text.*;
import flash.events.Event;
import org.papervision3d.objects.*
import org.papervision3d.core.geom.renderables.*;
import org.papervision3d.core.effects.utils.BitmapClearMode;
import org.papervision3d.core.geom.Pixels;
import org.papervision3d.view.layer.BitmapEffectLayer;
import org.papervision3d.view.*;
import org.papervision3d.scenes.*;
/**
* 頂点の番号を表示させるクラスです。
* BasicViewに直接addChildして使います。sceneにaddChildするのではありません。
*/
class VertexNumberViewer extends Sprite
{
	
	private var pixels:Pixels;
	private var ary:Array;
	private var s:Scene3D;
	private var vp:Viewport3D;
	private var _obj:DisplayObject3D;
	private var verticesNum:uint;
	private var offsetX:Number;
	private var offsetY:Number;
	
	/**
	* コンストラクタ。
	* @param obj 頂点番号を表示させる対象オブジェクト
	*/
	public function VertexNumberViewer(obj:DisplayObject3D)
	{
		_obj = obj;
		addEventListener(Event.ADDED_TO_STAGE, onAdd);
	}
	
	/*
	* テキストフィールドなどの生成を行います。
	* 親オブジェクトやステージの大きさを知るため、ADD_TO_STAGEイベントのリスナにしています
	* @param e
	*/
	private function onAdd(e:Event):void {
		var bv:BasicView = this.parent as BasicView;
		s = bv.scene;
		vp = bv.viewport;
		
		
		var layer:BitmapEffectLayer = new BitmapEffectLayer(vp, 465, 465, true, 0, BitmapClearMode.CLEAR_PRE, true);
		layer.clearBeforeRender=true;
		vp.containerSprite.addLayer(layer);
		
		//Pixels生成
		pixels = new Pixels(layer);
		s.addChild(pixels);
		
		verticesNum = _obj.geometry.vertices.length;//頂点数
		var p:Pixel3D;
		var vertex:Vertex3D;
		for (var v:int = 0; v < verticesNum; v++)
		{
			vertex = _obj.geometry.vertices[v];
			p = new Pixel3D(0xFFFFFFFF, vertex.x, vertex.y, vertex.z);
			pixels.addPixel3D(p);
		}
		
		//TextField生成
		ary=[];
		var tf:TextField;
		for (var i:int=0; i < verticesNum; i++)
		{
			tf = new TextField();
			tf.textColor = 0xFFFFFF;
			tf.text = i.toString();
			addChild(tf);
			ary[i] = tf;
		}
		
		
		offsetX = stage.stageWidth >> 1;
		offsetY = stage.stageHeight >> 1;
				
		addEventListener(Event.ENTER_FRAME, redraw);
	}
	
	/**
	* テキストフィールドの位置を対象オブジェクトの座標と同期します。
	* とりあえずEnterFrameで回すようにしましたが、パフォーマンス上あんまりよくないかもしれないです
	* @param e
	*/
	public function redraw(e:Event = null):void
	{
		//pixelsの変換
		pixels.rotationX = _obj.rotationX;
		pixels.rotationY = _obj.rotationY;
		pixels.rotationZ = _obj.rotationZ;
		pixels.x = _obj.x;
		pixels.y = _obj.y;
		pixels.z = _obj.z;
		

		var v3d:Vertex3DInstance;
		var i:int=0;
		for each (var _p:Pixel3D in pixels.pixels)
		{
			v3d = _p.vertex3D.vertex3DInstance;
			if (v3d.visible)
			{
				(ary[i] as TextField).x=v3d.x + offsetX;
				(ary[i] as TextField).y=v3d.y + offsetY;
				i++;
			}
		}
	}
	
	
}
