/**
 * Copyright majoraze ( http://wonderfl.net/user/majoraze )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/tKY7
 */

// forked from yasohachi's 煙にしましたforked from: コレを煙にします
// forked from Kay's コレを煙にします
package { 
    import flash.display.*; 
    import flash.events.*; 
    import flash.filters.BlurFilter;
    import flash.filters.ColorMatrixFilter;
    import flash.geom.*; 
    [SWF(width=465,height=465,backgroundColor=0x000000,frameRate=30)] 
    public class Smoke extends Sprite { 
         
        private const SW:Number = stage.stageWidth; 
        private const SH:Number = stage.stageHeight; 
        private var hNum:uint = 200; 
        private var vNum:uint = 200; 
        private var noise:Texture; 
        private var smoke:Sprite; 
        
        private var blur:BlurFilter;
        private var smokeBitmap:Bitmap;
        private var smokeBitmapData:BitmapData;
        private var matrix:Matrix;
        private var colorTransform:ColorTransform;
        private var clearBitmap:BitmapData;
        private var rect:Rectangle;
        private var point:Point;
        
        public function Smoke():void {
            var spriteBack:Sprite = new Sprite();
            spriteBack.graphics.beginFill(0x000000,1);
            spriteBack.graphics.drawRect(0,0,stage.stageWidth, stage.stageHeight);
            addChild(spriteBack);
            
            noise = new Texture(hNum, vNum); 
            addEventListener(Event.ENTER_FRAME, xRun); 
            // 検証用 
            var bm:Bitmap = new Bitmap(noise); 
            addChild(bm); 
            // 煙になるかな？ 
            smoke = new Sprite(); 
            smoke.x = SW/2; 
            smoke.y = SH; 
            //addChild(smoke); 
            
          smokeBitmapData = new BitmapData(SW, SH, true, 0x00000000);
          smokeBitmap = new Bitmap(smokeBitmapData, "auto", true);
            
          addChild(smokeBitmap);
            
          blur = new BlurFilter(8, 8, 1);
          smoke.filters = [blur];
            
          matrix = new Matrix(1, 0, 0, 1, smoke.x, smoke.y);
          colorTransform = new ColorTransform(1, 1, 1, 0.8);
            
          clearBitmap = new BitmapData(SW, SH, true, 0x00000000); 
            
          rect = new Rectangle(0, 0, SW, SH);
          point = new Point(0, 0);
        } 
         
        private function xRun(e:Event):void { 
            // Noiseを動かして（Point値を更新） 
            noise.xDraw(1,1); 
            // Noiseから座標を取得して煙の祖片を描画 
            smoke.graphics.clear(); 
            smoke.blendMode = BlendMode.ADD;
            for (var v:uint = 0; v < 10; v++) { 
                var nX:Number = 0; 
                var nY:Number = 0; 
                var alpha:Number = 0.2 / 40;
                smoke.graphics.lineStyle(0,0xffffff,0.2); 
                smoke.graphics.moveTo(nX,nY); 
                for (var h:uint = 0; h < 40; h++) { 
                    var nColor:uint = noise.getPixel(v,h); 
                    var colors:Array = toRGB(nColor); 
                    nX += (colors[1]-128)/15; 
                    nY += (colors[2]-128)/10 - 10; 
                    smoke.graphics.lineTo(nX, nY); 
                    
                    //上に行くほど透明に
                       smoke.graphics.lineStyle(0, 0xffffff, 0.2 - alpha * h);
                } 
            } 
            
            
          //ブラーかけて重ね合わせ
            smokeBitmapData.lock();
          smokeBitmapData.colorTransform(rect, colorTransform);
          smokeBitmapData.applyFilter(smokeBitmapData, rect, point, blur);
          smokeBitmapData.draw(smoke, matrix, null,BlendMode.ADD);
          smokeBitmapData.unlock();
        } 
        private function toRGB(nColor:uint):Array { 
            var nB:uint = nColor & 0xff; 
            var nG:uint = (nColor >> 8) & 0xff; 
            var nR:uint = (nColor >> 16) & 0xff; 
            return ([nR, nG, nB]); 
        } 
    } 
} 

import flash.display.*; 
import flash.geom.*; 
class Texture extends BitmapData { 
    public var point:Point = new Point(0,0); 
    private var seed:uint = Math.floor(Math.random() * 10); 
    private var channels:uint = BitmapDataChannel.GREEN | BitmapDataChannel.BLUE; 
    public function Texture (w:uint=200, h:uint=200) { 
        super(w, h, true, 0xffffffff); 
    } 
    public function xDraw(pX:Number, pY:Number):void { 
        point.x += pX; 
        point.y += pY; 
        perlinNoise(80, 80, 4, seed, true, true, channels, false, [point]); 
    } 
}