/**
 * Copyright 3f5 ( http://wonderfl.net/user/3f5 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/tJvy
 */

// forked from 3f5's エッジ抽出した
// forked from 3f5's エッジ抽出できない
package {
    import flash.system.Security;
    import flash.text.TextField;
    import flash.net.URLRequest;
    import flash.events.Event;
    import flash.display.Loader;
    import flash.display.BitmapData;
    import flash.display.Bitmap;
    import flash.display.Sprite;
    public class Edge extends Sprite {
        private const BACKGROUND_COLOR:uint = 0xFF0000;
        private const FOREGROUND_COLOR:uint = 0xFFFFFF;
        public function Edge() {
            Security.loadPolicyFile('http://assets.wonderfl.net/crossdomain.xml');
            var loader:Loader = new Loader();
            loader.contentLoaderInfo.addEventListener(Event.COMPLETE, init);
            loader.load(new URLRequest('http://assets.wonderfl.net/images/related_images/a/a5/a522/a52274a406486307d2ef6469f1801c1ebe6bc728'));
        }
        
        private function init(event:Event):void {
            var bitmap:BitmapData = new BitmapData(event.target.loader.width, event.target.loader.height, false, 0xFFFFFF);
            bitmap.draw(event.target.loader);
            var sprite:Sprite = new Sprite();
            sprite.graphics.lineStyle(1.5, 0x000000, 1, false);
            //sprite.graphics.beginFill(0xFF0000);
            
            //addChild(new Bitmap(bitmap));
            var map:Object = {};
            addChild(sprite);
            var p:Array = [
                [1, 0],
                [0, -1],
                [-1, 0],
                [1, 1],
                [0, 1],
                [-1, -1],
                [-1, 1],
                [1, -1]
            ];
            
            for (var _x:uint = 0; _x < bitmap.width; _x++) {
                map[_x] = {};
                for (var _y:uint = 0; _y < bitmap.height; _y++) {
                    map[_x][_y] = false;
                }
            }
            
            var next:Array, prev:Array, y:int, x:int, pattern:Array, _pattern:Array, length:int;

            for (y = 0; y < bitmap.height; y++) {
                for (x = 0; x < bitmap.width; x++) {
                    if (compColor(bitmap.getPixel(x, y), FOREGROUND_COLOR) && !map[x][y]) {
                        //sprite.graphics.lineStyle(1, Math.floor(Math.random() * 0xFFFFFF));
                        sprite.graphics.moveTo(x, y);
                        next = [x, y];
                        while (next != null) {
                          map[next[0]][next[1]] = true;
                          prev = [next[0], next[1]];
                          sprite.graphics.lineTo(next[0], next[1]);
                          next = null;
                          for each (pattern in p) {
                              _x = pattern[0] + prev[0];
                              _y = pattern[1] + prev[1];
                              if (!map[_x][_y] && compColor(bitmap.getPixel(_x, _y), FOREGROUND_COLOR)) {
                                 for each (_pattern in p) {
                                     if (compColor(bitmap.getPixel(_x + _pattern[0], _y + _pattern[1]), BACKGROUND_COLOR)) {
                                         next = [_x, _y];
                                         break;
                                     }
                                 }
                              }
                              if (next != null) break;
                          }
                       }
                    }

                }
            }
            
            sprite.graphics.endFill();
            //addChild(new Bitmap(bitmap));
        }

        private function compColor(col1:uint, col2:uint):Boolean {
            if (col1 === 0 || col2 === 0) return false;
            /*
            
            var r1:int = (col1 >> 16) & 0xFF;
            var g1:int = (col1 >>  8) & 0xFF;
            var b1:int = (col1 >>  0) & 0xFF;

            var r2:int = (col2 >> 16) & 0xFF;
            var g2:int = (col2 >>  8) & 0xFF;
            var b2:int = (col2 >>  0) & 0xFF;
            
            if (Math.abs(r1 - r2) <= 40 && Math.abs(g1 - g2) <= 40 && Math.abs(b1 - b2) <= 40) {
                return true;
            }
            else {
                return false;
            }*/

            if (Math.abs(col1 - col2) <= 2048575) {
              return true;
            }
            
            return false;
        }

    }
}