/**
 * Copyright path.hki ( http://wonderfl.net/user/path.hki )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/tJn4
 */

// forked from paq's [PV3D]AS3Dmod
/*
 * モディファイアライブラリ「as3dmod」を無理矢理wonderflで使ってみる。
 * http://code.google.com/p/as3dmod/
*/
package {
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.StageAlign;
    import flash.display.StageQuality;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.net.URLRequest;
    import flash.system.LoaderContext;
    import jp.progression.commands.lists.SerialList;
    import jp.progression.data.getResourceById;
    import org.papervision3d.materials.BitmapFileMaterial;
    import org.papervision3d.materials.BitmapMaterial;
    import org.papervision3d.objects.primitives.Plane;
    import org.papervision3d.core.proto.MaterialObject3D;
    import org.papervision3d.materials.ColorMaterial;
    import org.papervision3d.materials.WireframeMaterial;
    import org.papervision3d.materials.special.CompositeMaterial;
    import org.papervision3d.materials.utils.MaterialsList;
    import org.papervision3d.objects.DisplayObject3D;
    import org.papervision3d.objects.primitives.Cube;
    import org.papervision3d.view.BasicView;

    [SWF(frameRate=60)]
    public class Main extends BasicView {

        private var c:DisplayObject3D;
        private var m:ModifierStack;
        private var w:Twist;
        private var wph:Phase;
        private var IMG_URL:Array = [
        "http://flash-scope.com/wonderfl/WonderflQuest/yuusha/yuushaF1.png",
        "http://flash-scope.com/wonderfl/WonderflQuest/map/map0.png",
        "http://flash-scope.com/wonderfl/WonderflQuest/map/map1.png",
        "http://flash-scope.com/wonderfl/WonderflQuest/map/map2.png",
        "http://flash-scope.com/wonderfl/WonderflQuest/map/map3.png",
        "http://flash-scope.com/wonderfl/WonderflQuest/map/map9.png"
        ];

        public function Main() {
            
            stage.quality = StageQuality.LOW;
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
            
            var list:SerialList = new SerialList();
            var cmd:IllegalLoadBitmapData;
            
            for each(var url:String in IMG_URL)
            {
                list.addCommand(new IllegalLoadBitmapData(new URLRequest(url), { context: new LoaderContext(true) } ));
            }
            
            list.addCommand(function():void {
                var ml:MaterialsList = new MaterialsList();
                var bfm1:BitmapMaterial = new BitmapMaterial(getResourceById(IMG_URL[0]).toBitmapData());
                var bfm2:BitmapMaterial = new BitmapMaterial(getResourceById(IMG_URL[1]).toBitmapData());
                var bfm3:BitmapMaterial = new BitmapMaterial(getResourceById(IMG_URL[2]).toBitmapData());
                var bfm4:BitmapMaterial = new BitmapMaterial(getResourceById(IMG_URL[3]).toBitmapData());
                var bfm5:BitmapMaterial = new BitmapMaterial(getResourceById(IMG_URL[4]).toBitmapData());
                var bfm6:BitmapMaterial = new BitmapMaterial(getResourceById(IMG_URL[5]).toBitmapData());
                ml.addMaterial(bfm1 ,"front");
                ml.addMaterial(bfm2 ,"back");
                ml.addMaterial(bfm3 ,"left");
                ml.addMaterial(bfm4 ,"right");
                ml.addMaterial(bfm5 ,"top");
                ml.addMaterial(bfm6 , "bottom");
                
                c = new Cube(ml, 400, 400, 400, 8, 8, 8);
                c.rotationY = 45;
                scene.addChild(c);
                
                m = new ModifierStack(new LibraryPv3d(), c);
                w = new Twist(Math.PI / 2);
                wph = new Phase();
                m.addModifier(w);
                startRendering();
            });
            
            list.execute();
        }

        protected override function onRenderTick(event:Event = null):void {
            wph.value += 0.05;
            w.angle = Math.PI / 4 * wph.phasedValue;
            
            c.rotationY += (mouseX - 465/2)/70;
            c.rotationX += (mouseY - 465/2)/70;
            
            super.onRenderTick(event);
            m.apply();
        }
    }
}
import flash.display.Loader;
import flash.errors.IOError;
import flash.events.Event;
import flash.events.IOErrorEvent;
import flash.events.ProgressEvent;
import flash.net.URLRequest;
import flash.system.LoaderContext;
import jp.progression.commands.net.LoadCommand;

/**
 * クロスドメイン問題を無視してロードするLoadBitmapData
 * @see http://wonderfl.net/code/7d4580e10184a21248a18b04a8d2948deaa2ade6
 * @see http://wonderfl.net/code/5c164cb968b9883d1eee01b236c5206956e57545
 */
class IllegalLoadBitmapData extends LoadCommand {
    public function IllegalLoadBitmapData(request:URLRequest, initObject:Object = null) {
        // 引数を設定する
        _request = request;

        // 親クラスを初期化する
        super(request, initObject);
    }
    private var _context:LoaderContext;
    private var _request:URLRequest;
    private var loaderA:Loader;
    private var loaderB:Loader;

    public function get context():LoaderContext {
        return _context;
    }

    public function set context(value:LoaderContext):void {
        _context = value;
    }

    override protected function executeFunction():void {
        // Loader を作成する
        loaderA = new Loader();

        // イベントリスナーを登録する
        loaderA.contentLoaderInfo.addEventListener(Event.COMPLETE, _complete1);
        loaderA.contentLoaderInfo.addEventListener(IOErrorEvent.IO_ERROR, _ioError2);
        loaderA.contentLoaderInfo.addEventListener(ProgressEvent.PROGRESS, super.dispatchEvent);

        // ファイルを読み込む
        loaderA.load(_request, context);
    }

    /**
     * データが正常にロードされたときに送出されます。
     */
    private function _complete1(e:Event):void {
        loaderB = new Loader();
        loaderB.contentLoaderInfo.addEventListener(Event.INIT, _complete2);
        loaderB.loadBytes(loaderA.contentLoaderInfo.bytes);
    }

    private function _complete2(e:Event):void {
        var loader:Loader = e.currentTarget.loader;

        var bmd:BitmapData = new BitmapData(loader.width, loader.height, true, 0x00000000);
        bmd.draw(loader);

        // データを保持する
        super.data = bmd;

        // 処理を終了する
        super.executeComplete();
    }

    private function _ioError2(e:IOErrorEvent):void {
        super.throwError(this, new IOError(e.text));
    }
}

/**
 * Copyright (c) 2008 Bartek Drozdz (http://www.everydayflash.com)
 * 
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following
 * conditions:
 * 
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 * 
 * Same license applies to every file in this package and its subpackages.  
 */
internal class Phase {private var v:Number;public function Phase() {v = 0;}public function get value():Number {return v;}public function set value(v:Number):void {this.v = v;}public function get phasedValue():Number {return Math.sin(v);}public function get absPhasedValue():Number {return Math.abs(phasedValue);}}internal class Library3d {public function get id():String {return "";}public function get meshClass():String {return "";}public function get vertexClass():String {return "";}}internal class XMath {public static function normalize(start:Number, end:Number, val:Number):Number{var range:Number = end - start;var normal:Number;if (range == 0) {normal = 1;} else {normal = (Math.min (Math.max ((val - start) / end, 0.0), 1.0));}return normal;}}internal class ModifierStack  {private var lib3d:Library3d;private var baseMesh:MeshProxy;private var stack:Array;public function ModifierStack(lib3d:Library3d, mesh:*) {this.lib3d = lib3d;baseMesh = PluginFactory.getMeshProxy(lib3d);baseMesh.setMesh(mesh);baseMesh.analyzeGeometry();stack = new Array();}public function get mesh():MeshProxy {return baseMesh;}public function addModifier(mod:IModifier):void {mod.setModifiable(baseMesh);stack.push(mod);}public function apply():void {baseMesh.resetGeometry();for (var i:int = 0; i < stack.length; i++) {(stack[i] as IModifier).apply();}}public function collapse():void {apply();baseMesh.collapseGeometry();stack = new Array();}public function clear():void {stack = new Array();}}internal interface IModifier {function setModifiable(mod:MeshProxy):void;function apply():void;}internal class Modifier {protected var mod:MeshProxy;public function setModifiable(mod:MeshProxy):void {this.mod = mod;}public function getVertices():Array {return mod.getVertices();}}internal class Twist extends Modifier implements IModifier {private var _vector:Vector3D = new Vector3D(0, 1, 0);private var _angle:Number;public var center:Vector3D = new Vector3D();public function Twist(a:Number = 0) {_angle = a;}public function get angle():Number { return _angle; }public function set angle(value:Number):void { _angle = value; }public function get vector():Vector3D { return _vector; }public function set vector(value:Vector3D):void { _vector = value; }public function apply():void {_vector.normalize();var dv:Vector3D = new Vector3D(mod.maxX / 2, mod.maxY / 2, mod.maxZ / 2);var d:Number = -Vector3D.dot(_vector, center);for(var i:int = 0;i < mod.getVertices().length; i++) {var vertex:VertexProxy = mod.getVertices()[i];var dd:Number = Vector3D.dot(new Vector3D(vertex.x, vertex.y, vertex.z), _vector) + d;twistPoint(vertex, (dd / dv.modulo) * _angle);}}private function twistPoint(v:VertexProxy, a:Number):void {var mat:Matrix3D = Matrix3D.translationMatrix(v.x, v.y, v.z);mat = Matrix3D.multiply(Matrix3D.rotationMatrix(_vector.x, _vector.y, _vector.z, a), mat);v.x = mat.n14;v.y = mat.n24;v.z = mat.n34;}}internal class Bend extends Modifier implements IModifier {private var frc:Number;private var ofs:Number;private var cst:int = ModConstant.NONE;private var maa:int = ModConstant.NONE;private var mia:int = ModConstant.NONE;public function Bend(f:Number=0, o:Number=.5) {force = f;offset = o;}public function set force(f:Number):void {frc = f;}public function set offset(o:Number):void {ofs = o;ofs = Math.max(0, o);ofs = Math.min(1, o);}public function set constraint(c:int):void {cst = c; }public function get force():Number {return frc;}public function get offset():Number {return ofs;}public function get constraint():int {return cst; }public function set bendAxis(a:int):void {maa = a;}public function set pointAxis(a:int):void {mia = a;}public function apply():void {if(force == 0) return;if (maa == ModConstant.NONE) maa = mod.maxAxis;if (mia == ModConstant.NONE) mia = mod.minAxis;var pto:Number = mod.getMin(maa);var ptd:Number = mod.getMax(maa) - pto;var vs:Array = mod.getVertices();var vc:int = vs.length;var distance:Number = pto + ptd * offset;var radius:Number = ptd / Math.PI / force;var angle:Number = Math.PI * 2 * (ptd / (radius * Math.PI * 2));for (var i:int = 0; i < vc; i++) {var v:VertexProxy = vs[i] as VertexProxy;var p:Number = v.getRatio(maa);if (constraint == ModConstant.LEFT && p <= offset) continue;if (constraint == ModConstant.RIGHT && p >= offset) continue;var fa:Number = ((Math.PI / 2) - angle * offset) + (angle * p);var op:Number = Math.sin(fa) * (radius + v.getValue(mia)) - radius;var ow:Number = distance - Math.cos(fa) * (radius + v.getValue(mia));v.setValue(mia, op);v.setValue(maa, ow);}}}internal class Bloat extends Modifier implements IModifier {private var _x:Number = 0;public function get x ():Number { return _x; }public function set x (v:Number):void { _x = v; }private var _y:Number = 0;public function get y ():Number { return _y; }public function set y (v:Number):void { _y = v; }private var _z:Number = 0;public function get z ():Number { return _z; }public function set z (v:Number):void { _z = v; }private var _r:Number = 0;public function get r ():Number { return _r; }public function set r (v:Number):void { _r = Math.max (0, v); }private var _a:Number = 1e-2;public function get a ():Number { return _a; }public function set a (v:Number):void { _a = Math.max (0, v); }public function apply():void {var vs:Array = mod.getVertices();var vc:int = vs.length;for (var i:int = 0; i < vc; i++) {var v:VertexProxy = VertexProxy (vs [i]);var ux:Number = v.x - _x;var uy:Number = v.y - _y;var uz:Number = v.z - _z;var ur:Number = Math.sqrt (ux * ux + uy * uy + uz * uz);if (ur > 0) {ux /= ur; uy /= ur; uz /= ur;} else {ux = 1.0;}ur += _r * Math.exp ( -ur * _a);v.x = _x + ux * ur;v.y = _y + uy * ur;v.z = _z + uz * ur;}}}internal class Noise extends Modifier implements IModifier {private var frc:Number;private var axc:int = ModConstant.NONE;private var start:Number = 0;private var end:Number = 0;public function Noise(f:Number=0) {this.frc = f;}public function set force(f:Number):void {frc = f;}public function get force():Number {return frc;}public function constraintAxes(c:int):void {this.axc = c;}public function setFalloff(start:Number=0, end:Number=1):void {this.start = start;this.end = end;}public function apply():void {var vs:Array = mod.getVertices();var vc:int = vs.length;for (var i:int = 0; i < vc; i++) {var v:VertexProxy = vs[i] as VertexProxy;var r:Number = (Math.random() * force) - (force / 2);var p:Number = v.getRatio(mod.maxAxis);if(start < end) {if (p < start) p = 0;if (p > end) p = 1;} else if(start > end) {p = 1 - p;if (p > start) p = 0;if (p < end) p = 1;} else {p = 1;}if (!(axc & 1)) v.x += r * p;if (!(axc >> 1 & 1)) v.y += r * p;if (!(axc >> 2 & 1)) v.z += r * p;}}}import flash.display.Bitmap;import flash.display.BitmapData;import flash.display.BitmapDataChannel;import flash.geom.Point;internal class Perlin extends Modifier implements IModifier {private var b:BitmapData = null;private var off:Number;private var frc:Number;private var seed:Number;private var start:Number = 0;private var end:Number = 0;public function Perlin(f:Number=1) {frc = f;b = new BitmapData(25, 11);off = 0;seed = Math.random() * 1000;}public function setFalloff(start:Number=0, end:Number=1):void {this.start = start;this.end = end;}public function set force(f:Number):void {frc = f;}public function get previev():Bitmap {var pr:Bitmap = new Bitmap(b);pr.scaleX = pr.scaleY = 4;return pr;}public function get force():Number {return frc;}public function apply():void {var p:Point = new Point(off++, 0);b.perlinNoise(25, 11, 1, seed, false, true, BitmapDataChannel.RED, true, [p, p, p]);var vs:Array = mod.getVertices();var vc:int = vs.length;for (var i:int = 0; i < vc; i++) {var v:VertexProxy = vs[i] as VertexProxy;var py:int = Math.round(v.getRatio(mod.maxAxis) * 24);var px:int = Math.round(v.getRatio(mod.midAxis) * 10);var vzpos:Number = b.getPixel(py, px) & 0xff;var fa:Number = v.getRatio(mod.maxAxis);if(start < end) {if (fa < start) fa = 0;if (fa > end) fa = 1;} else if(start > end) {fa = 1 - fa;if (fa > start) fa = 0;if (fa < end) fa = 1;} else {fa = 1;}v.setValue(mod.minAxis, v.getValue(mod.minAxis) + (128 - vzpos) * frc * fa);}}}internal class Skew extends Modifier implements IModifier{private var frc:Number;public function Skew(f:Number) {f = force;}public function set force(f:Number):void {frc = f;}public function get force():Number {return frc;}public function apply():void {var vs:Array = mod.getVertices();var vc:int = vs.length;for (var i:int = 0; i < vc; i++) {var v:VertexProxy = vs[i] as VertexProxy;var vl:Number = v.getValue(mod.minAxis) + force * Math.pow(v.getRatio(mod.maxAxis), 2);v.setValue(mod.minAxis, vl);}}}internal class Taper extends Modifier implements IModifier{private var frc:Number;private var pow:Number;private var start:Number = 0;private var end:Number = 1;public function Taper(f:Number) {frc = f;pow = 1;}public function setFalloff(start:Number=0, end:Number=1):void {this.start = start;this.end = end;}public function set force(value:Number):void {frc = value;}public function get force():Number {return frc;}public function get power():Number { return pow; }public function set power(value:Number):void { pow = value; }public function apply():void {var vs:Array = mod.getVertices();var vc:int = vs.length;for (var i:int = 0; i < vc; i++) {var v:VertexProxy = vs[i] as VertexProxy;var ar:Number = Math.pow(XMath.normalize(start, end, v.getRatio(mod.maxAxis)), pow);var sc:Number = frc * ar;var m:Matrix3D = Matrix3D.scaleMatrix(1+sc, 1+sc, 1);var n:Vector3D = new Vector3D(v.getValue(mod.minAxis), v.getValue(mod.midAxis), v.getValue(mod.maxAxis));Matrix3D.multiplyVector(m, n);v.setValue(mod.minAxis, n.x);v.setValue(mod.midAxis, n.y);}}}internal class Matrix3D {public var n11:Number;public var n12:Number;public var n13:Number;public var n14:Number;public var n21:Number;public var n22:Number;public var n23:Number;public var n24:Number;public var n31:Number;public var n32:Number;public var n33:Number;public var n34:Number;public var n41:Number;public var n42:Number;public var n43:Number;public var n44:Number;public function Matrix3D(pn11:Number = 1, pn12:Number = 0 , pn13:Number = 0 , pn14:Number = 0,pn21:Number = 0, pn22:Number = 1 , pn23:Number = 0 , pn24:Number = 0,pn31:Number = 0, pn32:Number = 0 , pn33:Number = 1 , pn34:Number = 0,pn41:Number = 0, pn42:Number = 0 , pn43:Number = 0 , pn44:Number = 1 ) {n11 = pn11; n12 = pn12; n13 = pn13; n14 = pn14;n21 = pn21; n22 = pn22; n23 = pn23; n24 = pn24;n31 = pn31; n32 = pn32; n33 = pn33; n34 = pn34;n41 = pn41; n42 = pn42; n43 = pn43; n44 = pn44;}public static function translationMatrix( x:Number, y:Number, z:Number ):Matrix3D {var m:Matrix3D = new Matrix3D();m.n14 = x;m.n24 = y;m.n34 = z;return m;}public static function scaleMatrix( x:Number, y:Number, z:Number ):Matrix3D {var m:Matrix3D = new Matrix3D();m.n11 = x;m.n22 = y;m.n33 = z;return m;}public static function rotationMatrix( x:Number, y:Number, z:Number, rad:Number, targetmatrix:Matrix3D = null ):Matrix3D {var m:Matrix3D;if(!targetmatrix) m = new Matrix3D();else m = targetmatrix; var nCos:Number = Math.cos(rad);var nSin:Number = Math.sin(rad);var scos:Number = 1 - nCos;var sxy:Number = x * y * scos;var syz:Number = y * z * scos;var sxz:Number = x * z * scos;var sz:Number = nSin * z;var sy:Number = nSin * y;var sx:Number = nSin * x;m.n11 = nCos + x * x * scos;m.n12 = -sz + sxy;m.n13 = sy + sxz;m.n14 = 0;m.n21 = sz + sxy;m.n22 = nCos + y * y * scos;m.n23 = -sx + syz;m.n24 = 0;m.n31 = -sy + sxz;m.n32 = sx + syz;m.n33 = nCos + z * z * scos;m.n34 = 0;return m;}public function calculateMultiply( a:Matrix3D, b:Matrix3D ):void {var a11:Number = a.n11; var b11:Number = b.n11;var a21:Number = a.n21; var b21:Number = b.n21;var a31:Number = a.n31; var b31:Number = b.n31;var a12:Number = a.n12; var b12:Number = b.n12;var a22:Number = a.n22; var b22:Number = b.n22;var a32:Number = a.n32; var b32:Number = b.n32;var a13:Number = a.n13; var b13:Number = b.n13;var a23:Number = a.n23; var b23:Number = b.n23;var a33:Number = a.n33; var b33:Number = b.n33;var a14:Number = a.n14; var b14:Number = b.n14;var a24:Number = a.n24; var b24:Number = b.n24;var a34:Number = a.n34; var b34:Number = b.n34;this.n11 = a11 * b11 + a12 * b21 + a13 * b31;this.n12 = a11 * b12 + a12 * b22 + a13 * b32;this.n13 = a11 * b13 + a12 * b23 + a13 * b33;this.n14 = a11 * b14 + a12 * b24 + a13 * b34 + a14;this.n21 = a21 * b11 + a22 * b21 + a23 * b31;this.n22 = a21 * b12 + a22 * b22 + a23 * b32;this.n23 = a21 * b13 + a22 * b23 + a23 * b33;this.n24 = a21 * b14 + a22 * b24 + a23 * b34 + a24;this.n31 = a31 * b11 + a32 * b21 + a33 * b31;this.n32 = a31 * b12 + a32 * b22 + a33 * b32;this.n33 = a31 * b13 + a32 * b23 + a33 * b33;this.n34 = a31 * b14 + a32 * b24 + a33 * b34 + a34;}public static function multiply( a:Matrix3D, b:Matrix3D ):Matrix3D {var m:Matrix3D = new Matrix3D();m.calculateMultiply(a, b);return m;}public static function multiplyVector( m:Matrix3D, v:Vector3D ):void {var vx:Number = v.x;var vy:Number = v.y;var vz:Number = v.z;v.x = vx * m.n11 + vy * m.n12 + vz * m.n13 + m.n14;v.y = vx * m.n21 + vy * m.n22 + vz * m.n23 + m.n24;v.z = vx * m.n31 + vy * m.n32 + vz * m.n33 + m.n34;}}internal class Vector3D {public var x:Number;public var y:Number;public var z:Number;public function Vector3D( x:Number = 0, y:Number = 0, z:Number = 0 ) {this.x = x;this.y = y;this.z = z;}public function get modulo():Number {return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);}public function normalize():void {var mod:Number = this.modulo;if( mod != 0 && mod != 1) {this.x /= mod;this.y /= mod;this.z /= mod;}}public static function dot( v:Vector3D, w:Vector3D ):Number {return ( v.x * w.x + v.y * w.y + w.z * v.z );}}internal class ModConstant {public static const NONE:int = 0;public static const X:int = 1;public static const Y:int = 2;public static const Z:int = 4;public static var LEFT:int = -1;public static var RIGHT:int = 1;}internal class VertexProxy {private var _ratioX:Number;private var _ratioY:Number;private var _ratioZ:Number;protected var ox:Number;protected var oy:Number;protected var oz:Number;public function VertexProxy() {}public function setVertex(vertex:*):void {}public function setRatios(rx:Number, ry:Number, rz:Number):void {_ratioX = rx;_ratioY = ry;_ratioZ = rz;}public function setOriginalPosition(ox:Number, oy:Number, oz:Number):void {this.ox = ox;this.oy = oy;this.oz = oz;}public function get x():Number {return 0;}public function get y():Number {return 0;}public function get z():Number {return 0;}public function set x(v:Number):void {}public function set y(v:Number):void {}public function set z(v:Number):void {}public function getValue(axis:int):Number {switch(axis) {case ModConstant.X: return x;case ModConstant.Y: return y;case ModConstant.Z: return z;}return 0;}public function setValue(axis:int, v:Number):void {switch(axis) {case ModConstant.X: x = v; break;case ModConstant.Y: y = v; break;case ModConstant.Z: z = v; break;}}public function get ratioX():Number {return _ratioX;}public function get ratioY():Number {return _ratioY;}public function get ratioZ():Number {return _ratioZ;}public function getRatio(axis:int):Number {switch(axis) {case ModConstant.X: return _ratioX;case ModConstant.Y: return _ratioY;case ModConstant.Z: return _ratioZ;}return -1;}public function get originalX():Number {return ox;}public function get originalY():Number {return oy;}public function get originalZ():Number {return oz;}public function getOriginalValue(axis:int):Number {switch(axis) {case ModConstant.X: return ox;case ModConstant.Y: return oy;case ModConstant.Z: return oz;}return 0;}public function reset():void {x = ox;y = oy;z = oz;}public function collapse():void {ox = x;oy = y;oz = z;}}internal class MeshProxy {protected var vertices:Array;protected var _maxX:Number;protected var _maxY:Number;protected var _maxZ:Number;protected var _minX:Number;protected var _minY:Number;protected var _minZ:Number;protected var _maxAxis:int;protected var _midAxis:int;protected var _minAxis:int;protected var _sizeX:Number;protected var _sizeY:Number;protected var _sizeZ:Number;public function MeshProxy() {vertices = new Array();}public function setMesh(mesh:*):void {}public function getVertices():Array {return vertices;}public function analyzeGeometry():void {var vc:int = getVertices().length;var i:int;var v:VertexProxy;for (i = 0; i < vc; i++) {v = getVertices()[i] as VertexProxy;if (i == 0) {_minX = _maxX = v.x;_minY = _maxY = v.y;_minZ = _maxZ = v.z;} else  {_minX = Math.min(_minX, v.x);_minY = Math.min(_minY, v.y);_minZ = Math.min(_minZ, v.z);_maxX = Math.max(_maxX, v.x); _maxY = Math.max(_maxY, v.y); _maxZ = Math.max(_maxZ, v.z); }v.setOriginalPosition(v.x, v.y, v.z);}_sizeX = _maxX - _minX;_sizeY = _maxY - _minY;_sizeZ = _maxZ - _minZ;var maxe:Number = Math.max(_sizeX, Math.max(_sizeY, _sizeZ));var mine:Number = Math.min(_sizeX, Math.min(_sizeY, _sizeZ));if (maxe == _sizeX && mine == _sizeY) {_minAxis = ModConstant.Y;_midAxis = ModConstant.Z;_maxAxis = ModConstant.X;} else if (maxe == _sizeX && mine == _sizeZ) {_minAxis = ModConstant.Z;_midAxis = ModConstant.Y;_maxAxis = ModConstant.X;} else if (maxe == _sizeY && mine == _sizeX) {_minAxis = ModConstant.X;_midAxis = ModConstant.Z;_maxAxis = ModConstant.Y;} else if (maxe == _sizeY && mine == _sizeZ) {_minAxis = ModConstant.Z;_midAxis = ModConstant.X;_maxAxis = ModConstant.Y;} else if (maxe == _sizeZ && mine == _sizeX) {_minAxis = ModConstant.X;_midAxis = ModConstant.Y;_maxAxis = ModConstant.Z;} else if (maxe == _sizeZ && mine == _sizeY) {_minAxis = ModConstant.Y;_midAxis = ModConstant.X;_maxAxis = ModConstant.Z;}for (i = 0; i < vc; i++) {v = getVertices()[i] as VertexProxy;v.setRatios((v.x - _minX) / _sizeX, (v.y - _minY) / _sizeY, (v.z - _minZ) / _sizeZ);}}public function resetGeometry():void {var vc:int = getVertices().length;for (var i:int = 0; i < vc; i++) {var v:VertexProxy = getVertices()[i] as VertexProxy;v.reset();}}public function collapseGeometry():void {var vc:int = getVertices().length;for (var i:int = 0; i < vc; i++) {var v:VertexProxy = getVertices()[i] as VertexProxy;v.collapse();}analyzeGeometry();}public function get minX():Number {return _minX;}public function get minY():Number {return _minY;}public function get minZ():Number {return _minZ;}public function getMin(axis:int):Number {switch(axis) {case ModConstant.X: return _minX;case ModConstant.Y: return _minY;case ModConstant.Z: return _minZ;}return -1;}public function get maxX():Number {return _maxX;}public function get maxY():Number {return _maxY;}public function get maxZ():Number {return _maxZ;}public function getMax(axis:int):Number {switch(axis) {case ModConstant.X: return _maxX;case ModConstant.Y: return _maxY;case ModConstant.Z: return _maxZ;}return -1;}public function get maxAxis():int {return _maxAxis;}public function get midAxis():int {return _midAxis;}public function get minAxis():int {return _minAxis;}}import org.papervision3d.core.geom.renderables.Vertex3D;import org.papervision3d.objects.DisplayObject3D;internal class Pv3dMesh extends MeshProxy {private var do3d:DisplayObject3D;override public function setMesh(mesh:*):void {do3d = mesh as DisplayObject3D;var vs:Array = do3d.geometry.vertices;var vc:int = vs.length;for (var i:int = 0; i < vc; i++) {var nv:Pv3dVertex = new Pv3dVertex();nv.setVertex(vs[i] as Vertex3D);vertices.push(nv);}}}import flash.utils.getDefinitionByName;internal class PluginFactory {public static function getMeshProxy(lib3d:Library3d):MeshProxy {return new Pv3dMesh();}}internal class LibraryPv3d extends Library3d {public function LibraryPv3d() {var m:MeshProxy = new Pv3dMesh();var v:VertexProxy = new Pv3dVertex();}override public function get id():String {return "pv3d";}override public function get meshClass():String {return "Pv3dMesh";}override public function get vertexClass():String {return "com.as3dmod.plugins.pv3d.Pv3dVertex";}}import org.papervision3d.core.geom.renderables.Vertex3D;internal class Pv3dVertex extends VertexProxy {private var vx:Vertex3D;public function Pv3dVertex() {}override public function setVertex(vertex:*):void {vx = vertex as Vertex3D;ox = vx.x;oy = vx.y;oz = vx.z;}override public function get x():Number {return vx.x;}override public function get y():Number {return vx.y;}override public function get z():Number {return vx.z;}override public function set x(v:Number):void {vx.x = v;}override public function set y(v:Number):void {vx.y = v;}override public function set z(v:Number):void { vx.z = v; }}internal class LibraryAlternativa3d extends Library3d {public function LibraryAlternativa3d() {var m:MeshProxy = new Alternativa3dMesh();var v:VertexProxy = new Alternativa3dVertex();}override public function get id():String {return "alternativa3d";}override public function get meshClass():String {return "com.as3dmod.plugins.alternativa3d.Alternativa3dMesh";}override public function get vertexClass():String {return "com.as3dmod.plugins.alternativa3d.Alternativa3dVertex";}}import alternativ5.engine3d.core.Mesh;import alternativ5.types.Set;internal class Alternativa3dMesh extends MeshProxy {private var awm:Mesh;public function Alternativa3dMesh() {}override public function setMesh(mesh:*):void {awm = mesh as Mesh;var vs:Set = awm.vertices.toSet();while (!vs.isEmpty()) {var nv:Alternativa3dVertex = new Alternativa3dVertex();nv.setVertex(vs.take());vertices.push(nv);}}}import alternativ5.engine3d.core.Vertex;internal class Alternativa3dVertex extends VertexProxy {private var vx:Vertex;public function Alternativa3dVertex() {}override public function setVertex(vertex:*):void {vx = vertex as Vertex;ox = vx.x;oy = vx.y;oz = vx.z;}override public function get x():Number {return vx.x;}override public function get y():Number {return vx.y;}override public function get z():Number {return vx.z;}override public function set x(v:Number):void {vx.x = v;}override public function set y(v:Number):void {vx.y = v;}override public function set z(v:Number):void {vx.z = v;}}