/**
 * Copyright alterna_in ( http://wonderfl.net/user/alterna_in )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/tJDw
 */

//三角がうまくかけない。
package 
{
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	
	import org.libspark.betweenas3.BetweenAS3;
	import org.libspark.betweenas3.easing.*
	
	import org.si.sion.*;
	import org.si.sion.utils.SiONPresetVoice;
	import org.si.sion.events.SiONTrackEvent;
	
	/**
	 * ...
	 * @author izm_design
	 */
	
	[SWF(backgroundColor = "#000000", frameRate = 30, width = 450, height = 450)]
	public class Main extends Sprite 
	{
		private var driver:SiONDriver;
		private var pVoice:SiONPresetVoice;
		private var voice:SiONVoice;
		private var soundArray:Array;
		
		public function Main():void 
		{
			driver = new SiONDriver();
			driver.play();
			pVoice = new SiONPresetVoice();
			voice = new SiONVoice();
			voice = pVoice["saw"];
			
			var KeyBoad:Sprite = generateKeyBoad();
			KeyBoad.x = stage.stageWidth/2 - KeyBoad.width / 2;
			KeyBoad.y = stage.stageHeight/2 - KeyBoad.height / 2;
			addChild(KeyBoad);
			generateSound();	
		}
		
		private function generateSound():void
		{
			soundArray = new Array();
			soundArray[0]  = 0   + 6 * 12;
			soundArray[1]  = 0.5 + 6 * 12;
			soundArray[2]  = 1   + 6 * 12;
			soundArray[3]  = 1.5 + 6 * 12;
			soundArray[4]  = 2   + 6 * 12;
			soundArray[5]  = 3   + 6 * 12;
			soundArray[6]  = 3.5 + 6 * 12;
			soundArray[7]  = 4   + 6 * 12;
			soundArray[8]  = 4.5 + 6 * 12;
			soundArray[9]  = 5   + 6 * 12;
			soundArray[10] = 5.5 + 6 * 12;
			soundArray[11] = 6   + 6 * 12;
		}
		
		private function generateKeyBoad():Sprite {
			var KeyBoad:Sprite = new Sprite();
			var keyPosXArray:Array = [0, 25, 50, 75, 100, 150, 125, 200, 225, 250, 275, 300];
			
			for (var i:int = 0; i < 12; i++) {
				var key:Key	= new Key();
				key.id = i;
				key.x = keyPosXArray[i];
				switch(i) {
					case 1:
					case 3:
					case 6:
					case 8:
					case 10:
						key.height = 100;
						KeyBoad.addChild(key);
					break;
					default:
						KeyBoad.addChildAt(key, 0);
						break;
				}
				key.addEventListener(MouseEvent.MOUSE_DOWN, keyMouseDownHandler);
				key.addEventListener(MouseEvent.MOUSE_UP, keyMouseUpHandler);
			}
			return KeyBoad;
		}
		
		private function keyMouseDownHandler(e:MouseEvent):void 
		{
			driver.noteOn(soundArray[e.target.id], voice, 0, 0, 0, 0, 0, 1, 1);
			var shape:Shape = new Shape();
			shape.x = mouseX;
			shape.y = mouseY;
			BetweenAS3.serial(
				BetweenAS3.addChild(shape, this),
				BetweenAS3.tween(shape, {scaleX:7, scaleY:7,alpha:0,rotation:0}, {scaleX:1, scaleY:1}, 0.7, Expo.easeOut),
				BetweenAS3.removeFromParent(shape)
			).play();
		}
		
		private function keyMouseUpHandler(e:MouseEvent):void 
		{
			driver.noteOff(soundArray[e.target.id]);
		}
	}
}

import flash.display.Sprite;
class Key extends Sprite {
	private var _id:int;
	public function Key() {
		buttonMode = true;
		
		graphics.beginFill(0x000000);
		graphics.drawRect(0, 0, 50, 200);
		graphics.endFill();
		
		graphics.lineStyle(2, 0xAAAAAA);
		graphics.lineTo(50,   0);
		graphics.lineTo(50, 200);
		graphics.lineTo( 0, 200);
		graphics.lineTo( 0,   0);
	}
	public function get id():int { return _id; }
	
	public function set id(value:int):void 
	{
		_id = value;
	}
}

import flash.display.Sprite;
class Shape extends Sprite {

	private const LINE_COLOR:uint = 0x00FFFF;
	
	public function Shape():void
	{
		var rand:int = Math.floor (Math.random () * 4);
			switch(rand) {
				case 0:
					createCircle();
					break;
				case 1:
					createSquare();
					break;
				case 2:
					createTriangle();
					break;
				case 3:
					createLine();
					break;
		}
		rotation = 45;
	}
	private function createCircle():void
	{
		graphics.lineStyle(5, LINE_COLOR);
		graphics.drawCircle( 0, 0, 50);
	}
	private function createSquare():void
	{
		graphics.moveTo( -50, -50);
		graphics.lineStyle(5, LINE_COLOR);		
		graphics.lineTo( 50,-50);
		graphics.lineTo( 50, 50);
		graphics.lineTo(-50, 50);
		graphics.lineTo(-50,-50);
	}
	private function createTriangle():void {
		graphics.moveTo( 0, 25);
		graphics.lineStyle(5, LINE_COLOR);		
		graphics.lineTo( -25,50);
		graphics.lineTo( 25, 50);
		graphics.lineTo( 0 , 25);
	}
	private function createLine():void {
		graphics.lineStyle(10, LINE_COLOR);	
		graphics.moveTo( Math.random () * -450,Math.random () * -450);
		graphics.lineTo( Math.random () * 450 ,Math.random () * 450);
		rotation=0;
	}
}