/**
 * Copyright hemingway ( http://wonderfl.net/user/hemingway )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/tIjz
 */

package
{
    import flash.display.*;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.geom.Matrix;
    import flash.geom.Utils3D;
    import flash.geom.Vector3D;
    import flash.geom.Matrix3D;
    import flash.geom.PerspectiveProjection;
    import net.hires.debug.Stats;

    [SWF(width="465", height="465", backgroundColor="0x000000", frameRate="60")]
    public class Pseudo3D extends Sprite
    {
        private const NUM_POINTS:int = 10000;
        private const SIZE_CANVAS:int = 465;

        private var _canvas:BitmapData;
        private var _bitmap:Bitmap;
        
        private var _matrix:Matrix = new Matrix(0.25, 0, 0, 0.25);
        private var _matrix3D:Matrix3D = new Matrix3D();

        private var _pointsData:Vector.<Number>;
        private var _uvtData:Vector.<Number> = new Vector.<Number>();
        private var _projectedVerts:Vector.<Number> = new Vector.<Number>();
        
        private var _mouse:Boolean;
        private var _mousePos:Vector.<int>;

        public function Pseudo3D()
        {
            this._mouse = false;
            this._mousePos = new Vector.<int>;
            this._pointsData = new Vector.<Number>(); 
            
            for(var $:int=0; $ < this.NUM_POINTS; $++)
            {
                var $tA:Number = (360 * Math.random()) * (Math.PI / 180); 
                var $tB:Number = (180 * Math.random() - 180) * (Math.PI / 180); 
                var $r:Number = 135;
                
                this._pointsData.push($r * Math.cos($tB) * Math.sin($tA));
                this._pointsData.push($r * Math.cos($tA)); 
                this._pointsData.push($r * Math.cos($tB) * Math.cos($tA)); 
            }
            
            this.addEventListener(Event.ADDED_TO_STAGE, this.addedToStageHandler);    
        }
        
        private function addedToStageHandler($event:Event):void {
            this.removeEventListener(Event.ADDED_TO_STAGE, this.addedToStageHandler);
        
            this._canvas = new BitmapData(this.SIZE_CANVAS, this.SIZE_CANVAS, false, 0x000000);    
            this._bitmap = this.addChild(new Bitmap(this._canvas)) as Bitmap;
            this.addChild(new Stats());
            
            //this._matrix3D.appendScale(5, 5, 5);
        
            this.stage.addEventListener(MouseEvent.MOUSE_DOWN, this.mouseDownHandler);
            this.stage.addEventListener(MouseEvent.MOUSE_UP, this.mouseUpHandler);
            this.addEventListener(Event.ENTER_FRAME, this.enterFrameHandler);
        }

        
        private function mouseDownHandler($event:MouseEvent):void {
            this._mouse = true;
            this._mousePos[0] = stage.mouseX as int;
            this._mousePos[1] = stage.mouseY as int;
            this._mousePos[2] = this._mousePos[3] = 0;
        }

        private function mouseUpHandler($event:MouseEvent):void {
            this._mouse = false;
            this._matrix3D.position.scaleBy(40);
        }
        
        private function enterFrameHandler($event:Event):void
        {
            Utils3D.projectVectors(this._matrix3D, this._pointsData, this._projectedVerts, this._uvtData); 
            
            this._canvas.lock();
            this._canvas.fillRect(this._canvas.rect, 0x000000);
            for (var $:int = 0; $ < NUM_POINTS; $++) {
                this._canvas.setPixel((this._projectedVerts[$ * 2] + (this.SIZE_CANVAS/2)), (this._projectedVerts[$ * 2 + 1] + (this.SIZE_CANVAS/2)), 0xffffff);
            }
            this._canvas.unlock();
            
            this._mousePos[2] = this._mousePos[0];
            this._mousePos[3] = this._mousePos[1];
            this._mousePos[0] = stage.mouseX as int;
            this._mousePos[1] = stage.mouseY as int;            
            
            if (this._mouse) {
                for($=0; $ < this.NUM_POINTS; $++)
                {
                    if (!($ % 0)) {
                        this._pointsData[$]--;
                    }
                }
                
                this._matrix3D.appendRotation(1, Vector3D.X_AXIS);
            }
        }
    }
}
