/**
 * Copyright leichtgewicht ( http://wonderfl.net/user/leichtgewicht )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/tIbR
 */

// forked from leichtgewicht's flash on 2012-8-19
package {
    import flash.geom.Point;
    import flash.events.Event;
    import flash.display.Bitmap;
    import flash.geom.Rectangle;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        
        private const SIZE: Rectangle = new Rectangle(0, 0, 400, 400);
        private const CENTER: Point = new Point(200, 200);

        private var _out: BitmapData;
        
        private const _sinData: Object = {};
        private const _cosData: Object = {};
        
        private var _outData: Vector.<uint>;
        private var _particles: Vector.<Particle>;
        
        public function FlashTest() {
            
            const width: int = SIZE.width;
            const height: int = SIZE.height;
            
            _out = new BitmapData(width, height, true, 0);
            _outData = _out.getVector(SIZE);
            _particles = createParticles();            
            
            initParticleRotation();
            
            addEventListener(Event.ENTER_FRAME, animate);
            
            addChild(new Bitmap(_out));
            
            graphics.beginFill(0);
            graphics.drawRect(0,0,stage.stageWidth,stage.stageHeight);
        }
        
        private function initParticleRotation(): void {
            const size: int = _particles.length;
            const x: Number = CENTER.x;
            const y: Number = CENTER.y;
            for( var i: int = 0; i<size; ++i) {
                var part: Particle = _particles[i];
                var xD: Number = part.x - x;
                var yD: Number = part.y - y;
                part.distance = Math.sqrt(xD*xD+yD*yD);
                part.angle = Math.atan2(xD, yD); 
                part.angleSpeed = (200-part.distance)/(200*5);
            }
        }

        
        private function drawParticles(): void {
            const size:int = _particles.length;
            const width:int = SIZE.width;
            const outLen: int = _outData.length;
            clear();
            for( var i: int = 0; i<size; ++i) {
                var part: Particle = _particles[i];
                var p: int = int(part.x+0.5)+int(part.y+0.5)*width;
                if( p < outLen && p >= 0 ) {
                    _outData[p] = 0xFFFFFFFF;
                }
            }
            _out.setVector(SIZE, _outData);
        }
        
        private function clear(): void {
            const size: int = _outData.length;
            for( var i: int = 0; i<size; ++i) {
                _outData[i] = 0;
            }
        }

        
        private function calcParticles(): void {
            const size:int = _particles.length;
            const width:int = SIZE.width;
            const outLen: int = _outData.length;
            const diff: Number = 0.2;
            var x: Number = CENTER.x;
            var y: Number = CENTER.y;
            for( var i: int = 0; i<size; ++i) {
                var part: Particle = _particles[i];
                var angle: Number = part.angle += part.angleSpeed;
                part.x = x + (Math.sin(angle))*part.distance;
                part.y = y + (Math.cos(angle))*part.distance; 
            }
        }

        
        private function animate(e:*): void {
            calcParticles();
            drawParticles();
        }

        
        private function createParticles(amount: int = 24000): Vector.<Particle> {
            const result: Vector.<Particle> = new Vector.<Particle>(amount);
            for(var i: int= 0; i<amount;++i) {
                result[i] = createParticle();
            }
            return result;
        }
        
        
        private function createParticle(): Particle {
            const particle: Particle = new Particle;
            particle.x = 100+Math.random()*200;
            particle.y = 100+Math.random()*200;
            return particle;
        }
    }
}

class Particle {
    public var x: Number;
    public var y: Number;
    public var angle: Number;
    public var angleSpeed: Number;
    public var distance: Number;
    public var xSpeed: Number;
    public var ySpeed: Number;
}

var trace: Function = Wonderfl.log;