/**
 * Copyright e2o ( http://wonderfl.net/user/e2o )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/tHjl
 */

// forked from hacker_c0kgmotg's flash on 2010-2-24
package {
    import flash.display.*;
    import flash.events.*;
    import flash.geom.Matrix;
    
    import idv.cjcat.stardust.common.clocks.SteadyClock;
    import idv.cjcat.stardust.common.emitters.Emitter;
    import idv.cjcat.stardust.common.renderers.Renderer;
    import idv.cjcat.stardust.threeD.papervision3d.renderers.PV3DParticleRenderer;
    
    import org.papervision3d.core.geom.Particles;
    import org.papervision3d.core.math.Number3D;
    import org.papervision3d.materials.WireframeMaterial;
    import org.papervision3d.objects.primitives.*;
    import org.papervision3d.view.BasicView;
    import org.papervision3d.view.layer.ViewportLayer;
    import org.papervision3d.objects.DisplayObject3D;
    
    import net.hires.debug.*;

    [SWF(width=465, height=465, frameRate=60)]
    public class KiraKiraParticle extends BasicView {
        // エミッター
        private var emitter:Emitter;
        // レンダラー
        private var particleRenderer:Renderer;
        // パーティクルのラッパー
        private var particles:Particles;
        //モーションの角度
        private var rot:Number = 0;
        // コンストラクタ
        public function KiraKiraParticle() {
            // PV3Dのパーティクル
            particles = new Particles();
            scene.addChild(particles);        
            // パーティクルシステムの構築
            emitter = new MyEmitter(new SteadyClock(3)); // エミッターに1フレームに発生させたい数値を指定
            particleRenderer = new PV3DParticleRenderer(particles);
            particleRenderer.addEmitter(emitter);
            // エンターフレームイベントの登録
            addEventListener(Event.ENTER_FRAME, loop);
            // 背景
            opaqueBackground = 0x0;
            
        }
        // エンターフレームイベント
        private function loop(e:Event):void {
            rot += 3;
            // 円周上を動いているかのようにみせる
            MyEmitter(emitter).point.x = 400 * Math.sin(rot * Number3D.toRADIANS);
            MyEmitter(emitter).point.y = 200 ;
            MyEmitter(emitter).point.z = 100 * Math.cos(rot * Number3D.toRADIANS);
            // パーティクルの方向を変える
            MyEmitter(emitter).sphereCap.rotationX = 90;
            MyEmitter(emitter).sphereCap.rotationZ = -rot - 90;
            // エミッター更新
            emitter.step();
            // Papervision3Dのレンダリング
            singleRender();            
        }
    }
}
import idv.cjcat.stardust.common.actions.Age;
import idv.cjcat.stardust.common.actions.DeathLife;
import idv.cjcat.stardust.common.actions.ScaleCurve;
import idv.cjcat.stardust.common.clocks.Clock;
import idv.cjcat.stardust.common.initializers.Life;
import idv.cjcat.stardust.common.math.UniformRandom;
import idv.cjcat.stardust.threeD.actions.Accelerate3D;
import idv.cjcat.stardust.threeD.actions.Move3D;
import idv.cjcat.stardust.threeD.emitters.Emitter3D;
import idv.cjcat.stardust.threeD.initializers.Position3D;
import idv.cjcat.stardust.threeD.initializers.Velocity3D;
import idv.cjcat.stardust.threeD.papervision3d.initializers.PV3DParticle;
import idv.cjcat.stardust.threeD.zones.SinglePoint3D;
import idv.cjcat.stardust.threeD.zones.SphereCap;

import org.papervision3d.materials.special.ParticleMaterial;
class MyEmitter extends Emitter3D　{
    public var point:SinglePoint3D = new SinglePoint3D(); // パーティクルの発生位置
    public var sphereCap:SphereCap = new SphereCap(0, 0, 0, 1, 0, 40); // パーティクルの拡散
    public function MyEmitter(clock:Clock = null) {
        super(clock);
        // マテリアル
        var mat:ParticleMaterial = new ParticleMaterial(0xFFCCBB, 1, 1, 6);
        // パーティクルの属性を定義
        addInitializer(new Position3D(point));　// 発生位置
        addInitializer(new PV3DParticle([mat]));
        addInitializer(new Life(new UniformRandom(120, 0)));
        addInitializer(new Velocity3D(sphereCap));
        // パーティクルのアクションを定義
        addAction(new Age()); // 寿命を有効化
        addAction(new DeathLife()); // 消えるを有効化
        addAction(new Accelerate3D(0.05)); // 加速を有効化
        addAction(new Move3D()); // 移動を有効化
        addAction(new ScaleCurve(20, 20)); //スケール変更を有効化
    }
}